import os
import os.path
import sys
import glob
import fnmatch
import string

if __name__ == '__main__':
    print 'usage: python astyle.py -r on -l on path/to/src'

    if len(sys.argv) != 6 or sys.argv[1] != '-r' or sys.argv[3] != '-l':
        print 'error: input'
        print 'usage: python pep8.py -r on -l on path/to/src'
        exit()

    if not os.path.exists(sys.argv[5]):
        print 'error: file or path not exists.'
        print 'usage: python pep8.py -r on -l on path/to/src'
        exit()

    if sys.argv[2] == 'on':
        recursive = True
    elif sys.argv[2] == 'off':
        recursive = False
    else:
        recursive = True

    if sys.argv[4] == 'on':
        log = True
    elif sys.argv[4] == 'off':
        log = False
    else:
        log = False

    filelist = []
    path = sys.argv[5]
    
    ext = path[-4:]
    if ext == '.cpp':
        filelist.append(path)
    else:
        if recursive:
            for (root, dirnames, filenames) in os.walk(path):
                for filename in fnmatch.filter(filenames, '*.cpp'):
                    filelist.append(os.path.join(root, filename))
        else:
            filelist = glob.glob(path + '*.cpp')

    ext = path[-2:]
    if ext == '.h':
        filelist.append(path)
    else:
        if recursive:
            for (root, dirnames, filenames) in os.walk(path):
                for filename in fnmatch.filter(filenames, '*.h'):
                    filelist.append(os.path.join(root, filename))
        else:
            filelist = glob.glob(path + '*.h')
    
    print 'Warning: All the .cpp and .h files will be reformatted.'
    for f in filelist:
        os.system('ls -l ' + f)

    ido = raw_input('Are you sure (y/n)?')

    if ido == 'y':
        pass
    else:
        exit()

    for f in filelist:
        print f
        os.system('ls -l ' + f)
        os.system('cp ' + f + ' ' + f + '_')
        os.system('astyle --style=allman --indent=spaces=4 ' + f)
        if log:
            print 'compare begin=============<'
            os.system('diff ' + f + ' ' + f + '_')
            print 'compare end===============>'

        os.system('rm -f ' + f + '_')
        os.system('ls -l ' + f)
        print 'Format done!'
