#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for user defined

from scattering import *
from tube import *
from detector import *
from transmission import *
from monitor import *
from experiment import *
from model.chopperModel import *


class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSMainTab, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.scatteringPage = CSNSScatteringPage(self)
        self.tubePage = CSNSTubePage(self)
        self.detectorPage = CSNSDetectorPage(self)
        self.transmissionPage = CSNSTransmissionPage(self)
        self.monitorPage = CSNSMonitorPage(self)
        self.experimentPage = CSNSExperimentPage(self)

        self.addTab(self.scatteringPage, 'Scattering')
        self.addTab(self.tubePage, 'Tube')
        self.addTab(self.detectorPage, 'Detector')
        self.addTab(self.transmissionPage, 'Transmission')
        self.addTab(self.monitorPage, 'Monitor')
        self.addTab(self.experimentPage, 'Progress')

        self.setTabEnabled(4,False)

        self.currentChanged.connect(self.tabChange)

    def setIndex(self, index):
        self.setCurrentIndex(index)

    def clearCanvas(self):
        self.scatteringPage.clearCanvas()
        self.tubePage.clearCanvas()
        self.detectorPage.clearCanvas()
        self.transmissionPage.clearCanvas()
        self.monitorPage.clearCanvas()
        self.experimentPage.clearCanvas()

    def updateDiffractionSimulator(self):
        self.histogramPage.startDiffractionSimulator()

    def updateDataStreaming(self):
        self.histogramPage.startDataStreaming()

    def updateProton(self, threadID):
        self.experimentPage.startProtonSimulator()

    def getScatteringPath(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        path6 = []
        path7 = []
        path8 = []
        path1 = '/SANS/workspace/MantidData/xy_image/x'
        path2 = '/SANS/workspace/MantidData/xy_image/y'
        path3 = '/SANS/workspace/MantidData/xy_image/value'
        index = 0
        _index = 0

        # path4 = '/SANS/workspace/MantidData/IQxy/x'
        # path5 = '/SANS/workspace/MantidData/IQxy/y'
        # path6 = '/SANS/workspace/MantidData/IQxy/counts'
        # path7 = '/SANS/workspace/MantidData/IQ_raw/q'
        # path8 = '/SANS/workspace/MantidData/IQ_raw/counts'

        index = self.scatteringPage.comboSelected()
        if index == 0:
            path4 = '/SANS/workspace/MantidData/raw/tof'
            path5 = '/SANS/workspace/MantidData/raw/counts'
        elif index == 1:
            path4 = '/SANS/workspace/MantidData/raw/wavelength'
            path5 = '/SANS/workspace/MantidData/raw/wcounts'
            
        _indexWave = self.scatteringPage.waveSelected()
        _index = self.scatteringPage.normSelected()
        if _index == 0:
            if _indexWave == 0:
                path6 = '/SANS/workspace/MantidData/raw/q_All'
                path7 = '/SANS/workspace/MantidData/raw/intensity_All'
            else:
                path6 = '/SANS/workspace/MantidData/raw/q_'+str(_indexWave+1)
                path7 = '/SANS/workspace/MantidData/raw/intensity_'+str(_indexWave+1)
        elif _index == 1:
            if _indexWave == 0:
                path6 = '/SANS/workspace/MantidData/reduction/monitor/q_All'
                path7 = \
                    '/SANS/workspace/MantidData/reduction/monitor/intensity_All'
            else:
                path6 = '/SANS/workspace/MantidData/reduction/monitor/q_'+str(_indexWave+1)
                path7 = \
                    '/SANS/workspace/MantidData/reduction/monitor/intensity_'+str(_indexWave+1)
        elif _index == 2:
            if _indexWave == 0:
                path6 = '/SANS/workspace/MantidData/reduction/PC/q_All'
                path7 = '/SANS/workspace/MantidData/reduction/PC/intensity_All'
            else:
                path6 = '/SANS/workspace/MantidData/reduction/PC/q_'+str(_indexWave+1)
                path7 = '/SANS/workspace/MantidData/reduction/PC/intensity_'+str(_indexWave+1)
        path8 = '/SANS/workspace/MantidData/BeamCenter'
        return (
            path1,
            path2,
            path3,
            path4,
            path5,
            path6,
            path7,
            path8,
            )

    def getTubePath(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        _tube = self.tubePage.getTubeNum()
        path1 = '/SANS/workspace/MantidData/tube' + str(_tube) \
            + '/xy_image/x'
        path2 = '/SANS/workspace/MantidData/tube' + str(_tube) \
            + '/xy_image/y'
        path3 = '/SANS/workspace/MantidData/tube' + str(_tube) \
            + '/xy_image/value'
        path4 = '/SANS/workspace/MantidData/tube' + str(_tube) + '/tof'
        path5 = '/SANS/workspace/MantidData/tube' + str(_tube) \
            + '/counts'
        return (path1, path2, path3, path4, path5)

    def getDetectorPath(self):
        path1 = []
        path2 = []
        path3 = []
        _indexWave = self.scatteringPage.waveSelected()
        if _indexWave == 0:
            path1 = '/SANS/workspace/MantidData/IQxy_All/x'
            path2 = '/SANS/workspace/MantidData/IQxy_All/y'
            path3 = '/SANS/workspace/MantidData/IQxy_All/counts'
        else:
            path1 = '/SANS/workspace/MantidData/IQxy_'+str(_indexWave+1)+'/x'
            path2 = '/SANS/workspace/MantidData/IQxy_'+str(_indexWave+1)+'/y'
            path3 = '/SANS/workspace/MantidData/IQxy_'+str(_indexWave+1)+'/counts'
        return (path1, path2, path3)

    def getTransmissionPath(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        path6 = []
        _index = self.transmissionPage.getCheckBoxIndex()
        if _index == 0:
            path1 = '/SANS/workspace/MantidData/trans/wavelength'
            path2 = '/SANS/workspace/MantidData/trans/transmission'
        else:
            path1 = '/SANS/workspace/MantidData/reduction/wavelength'
            path2 = '/SANS/workspace/MantidData/reduction/transmission'
        _comboIndex = self.transmissionPage.getComboIndex()
        if _comboIndex == 0:
            path3 = '/SANS/workspace/MantidData/monitor2/tof'
            path4 = '/SANS/workspace/MantidData/monitor2/counts'
            path5 = '/SANS/workspace/MantidData/monitor3/tof'
            path6 = '/SANS/workspace/MantidData/monitor3/counts'
        elif _comboIndex == 1:
            path3 = '/SANS/workspace/MantidData/monitor2/wavelength'
            path4 = '/SANS/workspace/MantidData/monitor2/intensity'
            path5 = '/SANS/workspace/MantidData/monitor3/wavelength'
            path6 = '/SANS/workspace/MantidData/monitor3/intensity'
        return (
            path1,
            path2,
            path3,
            path4,
            path5,
            path6,
            )

    def getMonitorPath(self):
        monitorStatus = []
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        _index = self.monitorPage.getComboIndex()
        for i in range(len(self.monitorPage.monitorDock)):
            monitorStatus.append(self.monitorPage.monitorDock[i].pauseButton.text())
            path1.append('/SANS/workspace/MantidData/monitor' + str(i
                         + 1) + '/xy_image/x')
            path2.append('/SANS/workspace/MantidData/monitor' + str(i
                         + 1) + '/xy_image/y')
            path3.append('/SANS/workspace/MantidData/monitor' + str(i
                         + 1) + '/xy_image/value')
            if _index[i] == 0:
                path4.append('/SANS/workspace/MantidData/monitor'
                             + str(i + 1) + '/tof')
                path5.append('/SANS/workspace/MantidData/monitor'
                             + str(i + 1) + '/counts')
            else:

                # path4.append('/SANS/tmp/x')
                # path5.append('/SANS/tmp/y')

                path4.append('/SANS/workspace/MantidData/monitor'
                             + str(i + 1) + '/wavelength')
                path5.append('/SANS/workspace/MantidData/monitor'
                             + str(i + 1) + '/intensity')
        return (
            monitorStatus,
            path1,
            path2,
            path3,
            path4,
            path5,
            )

    def getExperimentPath(self):
        path1 = []
        path2 = []
        path3 = []
        path1 = '/SANS/drone/proton_charge'
        path2 = '/SANS/drone/detector_counts'
        path3 = '/SANS/drone/pulse_counts'
        return (path1, path2, path3)

    def setStatus(self):
        self.tabChange()

    def tabChange(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        path6 = []
        path7 = []
        path8 = []
        path9 = []
        path10 = []
        path11 = []
        monitorStatus = []

        tabIndex = self.currentIndex()
        if tabIndex == 0:
            (
                path1,
                path2,
                path3,
                path4,
                path5,
                path6,
                path7,
                path8,
                ) = self.getScatteringPath()
            kwargs = {
                'tabIndex': tabIndex,
                'path1': path1,
                'path2': path2,
                'path3': path3,
                'path4': path4,
                'path5': path5,
                'path6': path6,
                'path7': path7,
                'path8': path8,
                }
        elif tabIndex == 1:
            (path1, path2, path3, path4, path5) = self.getTubePath()
            kwargs = {
                'tabIndex': tabIndex,
                'path1': path1,
                'path2': path2,
                'path3': path3,
                'path4': path4,
                'path5': path5,
                }
        elif tabIndex == 2:
            (path1, path2, path3) = self.getDetectorPath()
            kwargs = {
                'tabIndex': tabIndex,
                'path1': path1,
                'path2': path2,
                'path3': path3,
                }
        elif tabIndex == 3:
            (
                path1,
                path2,
                path3,
                path4,
                path5,
                path6,
                ) = self.getTransmissionPath()
            kwargs = {
                'tabIndex': tabIndex,
                'path1': path1,
                'path2': path2,
                'path3': path3,
                'path4': path4,
                'path5': path5,
                'path6': path6,
                }
        elif tabIndex == 4:
            (
                monitorStatus,
                path1,
                path2,
                path3,
                path4,
                path5,
                ) = self.getMonitorPath()
            kwargs = {
                'tabIndex': tabIndex,
                'path1': path1,
                'path2': path2,
                'path3': path3,
                'path4': path4,
                'path5': path5,
                'status': monitorStatus,
                }
        elif tabIndex == 5:
            (path1, path2, path3) = self.getExperimentPath()
            kwargs = {
                'tabIndex': tabIndex,
                'path1': path1,
                'path2': path2,
                'path3': path3,
                }
        #elif tabIndex == 4:
        #    (
        #        monitorStatus,
        #        path1,
        #        path2,
        #        path3,
        #        path4,
        #        path5,
        #        ) = self.getMonitorPath()
        #    kwargs = {
        #        'tabIndex': tabIndex,
        #        'path1': path1,
        #        'path2': path2,
        #        'path3': path3,
        #        'path4': path4,
        #        'path5': path5,
        #        'status': monitorStatus,
        #        }

        self.parent.setDataPath(kwargs)


