'''
Created on 2015.6.4
@author: yll
'''
from conf.constants import *
from canvas import *
#from model.readData import *
#from model.readImage import *

class CSNSTransmissionPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSTransmissionPage, self).__init__(parent=None)
        self.setupUi(self)
        self.parent = parent

    def setupUi(self,Widget):
    	#self.setTabPosition(QTabWidget.West)
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.mainGrid = QtGui.QGridLayout(self.first)
        self.checkBox = QtGui.QCheckBox("DirecetBeam Correction", self)
        self.checkBox.stateChanged.connect(self.checkBoxChanged)

        '''
        self.gisansFigure = Figure((6,3), dpi=150, facecolor="white", edgecolor=None, linewidth=1.0, frameon=False, tight_layout=False)

        self.gisansFigure.subplots_adjust(left=0.0, bottom=0.05, right=0.95, top=0.95)
        self.gisansCanvas = FigureCanvas(self.gisansFigure)
        self.gisansCanvas.setParent(self)

        self.gisansnAxes = self.gisansFigure.add_subplot(122,projection='3d')
        X, Y, Z, C = CSNSReadImageSurface("./img/XY ++.png")
        self.gisansnAxes.plot_surface(X, Y, Z, rstride=1, cstride=1, facecolors=cm.jet(C), linewidth=0, antialiased=False, shade=False)
        self.gisansnAxes.tick_params(axis='both', which='major', labelsize=5)
        '''
        _xsize = 6
        _ysize = 3
        self.canvas1 = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'Wavelength / A',
            'Transmission',
            )
        self.canvas2 = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'TOF',
            'Neutron Counts',
            )
        self.canvas3 = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'TOF',
            'Neutron Counts',
            )
        self.comboBox = QtGui.QComboBox()
        self.comboBox.addItem('TOF')
        self.comboBox.addItem('Wavelength')
        self.comboBox.setMaximumWidth(150)
        #self.comboBox.activated.connect(self.parent.tabChange)
 
        _nline = 0
        self.mainGrid.addWidget(self.checkBox,_nline,0,1,1)
        _nline += 1
        self.mainGrid.addWidget(self.canvas1,_nline,0,1,2)
        _nline += 1
        self.mainGrid.addWidget(self.comboBox,_nline,0,1,1)
        _nline += 1
        self.mainGrid.addWidget(self.canvas2,_nline,0,1,1)
        self.mainGrid.addWidget(self.canvas3,_nline,1,1,1)

        self.verticalLayout.addWidget(self.scrollArea)
            
        self.checkBoxIndex = 0
        self.pix1 = None
        self.pix2 = None
        self.pix3 = None

    def checkBoxChanged(self):
        if self.checkBox.isChecked():
            self.checkBoxIndex = 1
        else:
            self.checkBoxIndex = 0
        
        self.parent.tabChange()        

    def getCheckBoxIndex(self):
        return self.checkBoxIndex
    
    def getComboIndex(self):
        index = self.comboBox.currentIndex()
        return index

    def updateCanvas(self, value, started, _command):
        if _command in ('configure', 'stop', 'abort'):
            self.pix1 = None
            self.pix2 = None
            self.pix3 = None
        else:
            if not started:
                pass
            else:
                try:
                    if len(value[0]) != len(value[1]) or len(value[1]) == 0:
                        pass
                    else:
                        if not self.pix1:
                            self.canvas1.ax.clear()
                            self.pix1, = self.canvas1.ax.plot(value[0], value[1], color='r')
                            self.canvas1.ax.add_patch(self.canvas1.rect)
                            self.canvas1.ax.set_xlabel('Wavelength / A')
                            self.canvas1.ax.set_ylabel('Transmission')
                        else:
                            self.pix1.set_ydata(value[1])
                        if self.canvas1.zoomSelected and (self.canvas1.minX != self.canvas1.maxX) and (self.canvas1.minY != self.canvas1.maxY):
                            self.canvas1.ax.set_xlim(self.canvas1.minX, self.canvas1.maxX)
                            self.canvas1.ax.set_ylim(self.canvas1.minY, self.canvas1.maxY)
                        self.canvas1.ax.relim()
                        self.canvas1.ax.autoscale_view()
                        self.canvas1.draw()
                except:
                    self.pix1 = None
                try:
                    if len(value[2]) != len(value[3]) or len(value[3]) == 0:
                        pass
                    else:
                        if not self.pix2:
                            self.canvas2.ax.clear()
                            self.pix2, = self.canvas2.ax.plot(value[2], value[3], color='b')
                            self.canvas2.ax.add_patch(self.canvas2.rect)
                            self.canvas2.ax.set_xlabel('TOF')
                            self.canvas2.ax.set_ylabel('Neutron Counts')
                            self.canvas2.ax.set_title('Incident Monitor 2', fontsize=6)
                        else:
                            self.pix2.set_ydata(value[3])
                        if self.canvas2.zoomSelected and (self.canvas2.minX != self.canvas2.maxX) and (self.canvas2.minY != self.canvas2.maxY):
                            self.canvas2.ax.set_xlim(self.canvas2.minX, self.canvas2.maxX)
                            self.canvas2.ax.set_ylim(self.canvas2.minY, self.canvas2.maxY)
                        self.canvas2.ax.relim()
                        self.canvas2.ax.autoscale_view()
                        self.canvas2.draw()
                except:
                    self.pix2 = None
                try:
                    if len(value[4]) != len(value[5]) or len(value[5]) == 0:
                        pass
                    else:
                        if not self.pix3:
                            self.canvas3.ax.clear()
                            self.pix3, = self.canvas3.ax.plot(value[4], value[5], color='b')
                            self.canvas3.ax.add_patch(self.canvas3.rect)
                            self.canvas3.ax.set_xlabel('TOF')
                            self.canvas3.ax.set_ylabel('Neutron Counts')
                            self.canvas3.ax.set_title('Transmit Monitor 3', fontsize=6)
                        else:
                            self.pix3.set_ydata(value[5])
                        if self.canvas3.zoomSelected:
                            self.canvas3.ax.set_xlim(self.canvas3.minX, self.canvas3.maxX)
                            self.canvas3.ax.set_ylim(self.canvas3.minY, self.canvas3.maxY)
                        self.canvas3.ax.relim()
                        self.canvas3.ax.autoscale_view()
                        self.canvas3.draw()
                except:
                    self.pix3 = None
