#!/usr/bin/python
# -*- coding: utf-8 -*-

# for pyqt4

from conf.constants import *
from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

import matplotlib
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg
from matplotlib.figure import Figure


class figureCanvas(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=3,
        height=3,
        dpi=150,
        plotColor='',
        title='',
        xlabel='',
        ylabel='',
        ):

        self.fig = Figure(
            figsize=(width, height),
            dpi=dpi,
            facecolor='white',
            edgecolor=None,
            linewidth=1.0,
            frameon=False,
            tight_layout=True,
            )

        self.fig.patch.set_alpha(0.1)
        self.ax = self.fig.add_subplot(111)  # axisbg='r'
        self.ax.tick_params(axis='both', which='major', labelsize=5)
        self.fig.subplots_adjust(left=0.2, bottom=0.25, right=0.95,
                                 top=0.85)
        #self.fig.subplots_adjust(left=0.2, bottom=0.25, right=0.95, top=0.85)

        # self.fig.subplots_adjust(left=0.05, bottom=0.05, right=0.95,
        #                         top=0.95)

        self.xtitle = ''
        self.ytitle = ''

        self.ax.set_xlabel(xlabel, fontsize=5)
        self.ax.set_ylabel(ylabel, fontsize=5)

        self.plotColor = plotColor
        self.title = title
        self.grid_status = True
        self.xaxis_style = 'linear'
        self.yaxis_style = 'linear'

        # self.ax.hold(True)

        # self.ax.patch.set_alpha(0)

        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self,
                QtGui.QSizePolicy.Expanding,
                QtGui.QSizePolicy.Expanding)
        FigureCanvasQTAgg.updateGeometry(self)

        self.draw()


class zoomCanvas(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=3,
        height=2,
        dpi=150,
        plotColor='',
        title='',
        xlabel='',
        ylabel='',
        ):

        self.fig = Figure(
            figsize=(width, height),
            dpi=dpi,
            facecolor='white',
            edgecolor=None,
            linewidth=1.0,
            frameon=False,
            tight_layout=False,
            )

        self.fig.patch.set_alpha(0.1)
        self.ax = self.fig.add_subplot(111)  # axisbg='r'
        self.ax.tick_params(axis='both', which='major', labelsize=5)
        self.fig.subplots_adjust(left=0.12, bottom=0.25, right=0.95,
                                 top=0.85)

        self.xtitle = ''
        self.ytitle = ''

        self.ax.set_xlabel(xlabel, fontsize=5)
        self.ax.set_ylabel(ylabel, fontsize=5)

        self.plotColor = plotColor
        self.title = title
        self.grid_status = True
        self.xaxis_style = 'linear'
        self.yaxis_style = 'linear'

        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self,
                QtGui.QSizePolicy.Expanding,
                QtGui.QSizePolicy.Expanding)
        FigureCanvasQTAgg.updateGeometry(self)

        self.rect = Rectangle(
            (0, 0),
            0,
            0,
            facecolor='None',
            edgecolor='black',
            alpha=0.8,
            zorder=5,
            )
        self.ax.add_patch(self.rect)

        self.draw()

        self.zoomClick = False
        self.zoomSelected = False
        self.minX = 0
        self.maxX = 0
        self.minY = 0
        self.maxY = 0

        self.zoomEvents()

    def zoomEvents(self):
        self.mpl_connect('button_press_event', self.zoomFigurePress)
        self.mpl_connect('button_release_event', self.zoomFigureRelease)
        self.mpl_connect('motion_notify_event', self.zoomFigureMove)

    def zoomFigurePress(self, event):
        if event.button == 1:
            self.zoomClick = True
            self.zoomSelected = True
            self.x1 = event.xdata
            self.y1 = event.ydata
        elif event.button == 3:
            self.ax.autoscale(enable=True)
            self.draw()
            self.zoomSelected = False
            self.rect.set_width(0)
            self.rect.set_height(0)
        else:
            return

    def zoomFigureMove(self, event):
        if event.button == 1 and self.zoomClick == True and self.x1 \
            and self.y1 and event.xdata and event.ydata:

            self.rect.set_x(self.x1)
            self.rect.set_y(self.y1)
            self.rect.set_width(event.xdata - self.x1)
            self.rect.set_height(event.ydata - self.y1)

            # self.rect.set_xy((self.x0, self.y0))

            self.draw()
        else:
            return

    def zoomFigureRelease(self, event):
        self.zoomClick = False

        if event.button == 1 and self.x1 and self.y1 and event.xdata \
            and event.ydata:
            self.x2 = event.xdata
            self.y2 = event.ydata

            # self.rect.set_width(0)
            # self.rect.set_height(0)

            self.minX = min(self.x1, self.x2)
            self.maxX = max(self.x1, self.x2)
            if self.minX != self.maxX:
                self.ax.set_xlim(self.minX, self.maxX)
            self.minY = min(self.y1, self.y2)
            self.maxY = max(self.y1, self.y2)
            if self.minY != self.maxY:
                self.ax.set_ylim(self.minY, self.maxY)
            self.draw()
        else:
            return


class figure3DCanvas(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=3,
        height=3,
        dpi=150,
        plotColor='',
        title='',
        xlabel='',
        ylabel='',
        ):

        self.fig = Figure(
            figsize=(width, height),
            dpi=dpi,
            facecolor='white',
            edgecolor=None,
            linewidth=1.0,
            frameon=False,
            tight_layout=False,
            )

        self.fig.patch.set_alpha(0.1)
        self.ax = self.fig.add_subplot(111, projection='3d')  # axisbg='r'
        self.ax.tick_params(axis='both', which='major', labelsize=5)
        self.fig.subplots_adjust(left=0.12, bottom=0.25, right=0.95,
                                 top=0.95)

        self.xtitle = ''
        self.ytitle = ''

        self.ax.set_xlabel(xlabel, fontsize=5)
        self.ax.set_ylabel(ylabel, fontsize=5)

        self.plotColor = plotColor
        self.title = title
        self.grid_status = True

        # self.xaxis_style = 'linear'
        # self.yaxis_style = 'linear'
        # self.ax.hold(True)

        # self.ax.patch.set_alpha(0)

        FigureCanvasQTAgg.__init__(self, self.fig)

        # FigureCanvasQTAgg.setSizePolicy(self, QtGui.QSizePolicy.Expanding,
        #                           QtGui.QSizePolicy.Expanding)
        # FigureCanvasQTAgg.updateGeometry(self)

        self.draw()


class blankCanvas(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=3,
        height=2,
        dpi=150,
        ):

        self.fig = Figure(
            figsize=(width, height),
            dpi=dpi,
            facecolor=None,
            edgecolor=None,
            linewidth=0.0,
            frameon=False,
            tight_layout=False,
            )

        self.fig.patch.set_alpha(0.0)
        self.ax = self.fig.add_subplot(111, alpha=0.0, aspect=1.5)
        self.ax.get_xaxis().set_visible(False)
        self.ax.get_yaxis().set_visible(False)
        self.ax.set_axis_off()
        self.ax.set_frame_on(False)
        self.fig.subplots_adjust(left=0, bottom=0, right=1, top=1)

        self.ax.patch.set_alpha(0.0)
        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self,
                QtGui.QSizePolicy.Expanding,
                QtGui.QSizePolicy.Expanding)

        FigureCanvasQTAgg.updateGeometry(self)

        self.draw()


class xkcdFigure(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=1,
        height=1,
        dpi=150,
        ):

        self.fig = Figure(
            (width, height),
            dpi=150,
            facecolor='white',
            edgecolor=None,
            frameon=False,
            tight_layout=False,
            )

        self.ax = self.fig.add_subplot(111)

        # self.ax.set_axis_off()

        self.ax.get_xaxis().set_visible(False)
        self.ax.get_yaxis().set_visible(False)

        # self.line, =self.ax.plot([], [], color="g")

        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self,
                QtGui.QSizePolicy.Expanding,
                QtGui.QSizePolicy.Expanding)

        FigureCanvasQTAgg.updateGeometry(self)


