#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Monitor

'''

import numpy as np
from PyQt4 import QtCore, QtGui
import monitorDock


class CSNSMonitorPage(QtGui.QMainWindow):  # QTabWidget):

    def __init__(self, parent):
        super(CSNSMonitorPage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):  # QTabWidget):

        self.monitorDock = []
        self.monitorDock.append(monitorDock.monitorDock(
            self,
            '/BL01/BANK01/PATTERN',
            '/BL01/BANK01/IMAGE',
            9,
            0.8,
            'y',
            'rainbow',#'Accent',
            'Incident Monitor 1',
            ))
        self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
                           self.monitorDock[0])

        # self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
        #                   self.monitorDock[1])
        # self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
        #                   self.monitorDock[2])

        self.monitorDock[0].imageCanvas.ax.set_aspect('equal')
        self.pix1 = []
        self.pix2 = []
        for i in range(len(self.monitorDock)):
            self.pix1.append('')
            self.pix2.append('')
            #self.monitorDock[i].imageCanvas.ax.set_aspect('equal')

    def setStatus(self):
        return self.parent.setStatus()

    def getComboIndex(self):
        _index = []
        for i in range(len(self.monitorDock)):
            _index.append(self.monitorDock[i].getComboIndex())
        return _index

    def getMonitorData(self):
        self.parent.getMonitorData()

    def updateCanvas(
        self,
        value,
        started,
        _command,
        ):
        i = 0
        _pause = None
        for i in range(len(self.monitorDock)):
            can3D = self.monitorDock[i].imageCanvas
            can2D = self.monitorDock[i].patternCanvas
            if _command in ('configure', 'abort'):
                self.pix1[i] = None
                self.pix2[i] = None
            #elif not started:
            #    pass
            #else:
            _pause = self.monitorDock[i].pauseButton.text()
            if _pause == 'Pause':
                try:
                    if str(value[2][i]) == 'clear':
                        pass
                    elif len(value[2][i]) == 0:
                        pass
                    else:
                        if not self.pix1[i]:
                            can3D.ax.clear()
                            self.pix1[i] = \
can3D.ax.pcolormesh(value[0][i], value[1][i], value[2][i],
                cmap=can3D.plotColor)
                            can3D.ax.add_patch(can3D.rect)
                            can3D.ax.set_xlabel('X / mm')
                            can3D.ax.set_ylabel('Y / mm')
                        else:
                            self.pix1[i].set_array(value[2][i].ravel())
                        if can3D.zoomSelected and can3D.minX \
                            != can3D.maxX and can3D.minY \
                            != can3D.maxY:
                            can3D.ax.set_xlim(can3D.minX,
can3D.maxX)
                            can3D.ax.set_ylim(can3D.minY,
can3D.maxY)
                        #can3D.ax.relim()
                        can3D.ax.autoscale_view()
                        can3D.draw()
                except:
                    self.pix1[i] = None
                try:
                    if str(value[3][i]) == 'clear' or str(value[4][i]) == 'clear':
                        print 111
                        pass
                    elif len(value[3][i]) != len(value[4][i]) \
                        or len(value[4][i]) == 0:
                        print 222
                        pass
                    else:
                        #if not self.pix2[i]:
                        can2D.ax.clear()
                        (self.pix2[i], ) = can2D.ax.plot(value[3][i], value[4][i], color=can2D.plotColor)
                        can2D.ax.add_patch(can2D.rect)

                            # self.pix2[i].set_xdata(value[3][i])

                        can2D.ax.set_ylabel('Neutron Counts')
                        index = self.getComboIndex()    
                        if index[i] == 0:
                            can2D.ax.set_xlabel('TOF / us')
                        else:
                            can2D.ax.set_xlabel('Wavelength')
                        #else:
                        #    self.pix2[i].set_ydata(y)
                        if can2D.zoomSelected and can2D.minX \
                            != can2D.maxX and can2D.minY \
                            != can2D.maxY:
                            can2D.ax.set_xlim(can2D.minX,
    can2D.maxX)
                            can2D.ax.set_ylim(can2D.minY,
    can2D.maxY)
                        can2D.ax.relim()
                        can2D.ax.autoscale_view()
                        can2D.draw()
                except:
                    self.pix2[i] = None
