#!/usr/bin/python
# -*- coding: utf-8 -*-
'''
Created on 2015.6.4
@author: yll
'''

from conf.constants import *
from canvas import *

# from model.readData import *
# from model.readImage import *

class CSNSTransmissionPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSTransmissionPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

        # self.setTabPosition(QTabWidget.West)

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.mainGrid = QtGui.QGridLayout(self.first)
        self.checkBox = QtGui.QCheckBox('DirecetBeam Correction', self)
        self.checkBox.stateChanged.connect(self.checkBoxChanged)

        _xsize = 6
        _ysize = 3
        self.canvas1 = zoomCanvas(  # self.plotColor,
                                    # self.title,
            self,
            _xsize,
            _ysize,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'Wavelength / A',
            'Transmission',
            )

        self.canvas2 = zoomCanvas(  # self.plotColor,
                                    # self.title,
            self,
            _xsize,
            _ysize,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'TOF',
            'Neutron Counts',
            )
        self.canvas3 = zoomCanvas(  # self.plotColor,
                                    # self.title,
            self,
            _xsize,
            _ysize,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'TOF',
            'Neutron Counts',
            )
        self.comboBox = QtGui.QComboBox()
        self.comboBox.addItem('TOF')
        self.comboBox.addItem('Wavelength')
        self.comboBox.setMaximumWidth(150)
        self.comboBox.activated.connect(self.comboChange)

        _nline = 0
        self.mainGrid.addWidget(self.checkBox, _nline, 0, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.canvas1, _nline, 0, 1, 2)
        _nline += 1
        self.mainGrid.addWidget(self.comboBox, _nline, 0, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.canvas2, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.canvas3, _nline, 1, 1, 1)

        self.verticalLayout.addWidget(self.scrollArea)

        self.checkBoxIndex = 0
        self.pix1 = None
        self.pix2 = None
        self.pix3 = None

    def checkBoxChanged(self):
        if self.checkBox.isChecked():
            self.checkBoxIndex = 1
        else:
            self.checkBoxIndex = 0

        self.parent.tabChange()

    def getCheckBoxIndex(self):
        return self.checkBoxIndex

    def getComboIndex(self):
        index = self.comboBox.currentIndex()
        return index
    
    def comboChange(self):
        self.pix2 = None
        self.pix3 = None
        self.canvas2.zoomSelected = False
        self.canvas3.zoomSelected = False
        self.parent.tabChange()
        index = self.comboBox.currentIndex()
        if index == 0:
            self.canvas2.ax.set_xlabel('TOF / us')
            self.canvas3.ax.set_xlabel('TOF / us')
        else:
            self.canvas2.ax.set_xlabel('Wavelength')
            self.canvas3.ax.set_xlabel('Wavelength')

        self.canvas2.draw()
        self.canvas3.draw()

    def clearCanvas(self):
        self.canvas1.ax.clear()
        self.canvas1.draw()
        self.canvas2.ax.clear()
        self.canvas2.draw()
        self.canvas3.ax.clear()
        self.canvas3.draw()

    def updateCanvas(
        self,
        value,
        started,
        _command,
        ):
        if _command in ('configure', 'stop', 'abort'):
            self.pix1 = None
            self.pix2 = None
            self.pix3 = None
        #elif not started:
        #    pass
        #else:
        try:
            if str(value[0]) == 'clear' or str(value[1]) == 'clear':
                self.canvas1.ax.clear()
                self.canvas1.draw()
            elif len(value[0]) != len(value[1]) or len(value[1]) \
                == 0:
                pass
            else:
                #if not self.pix1:
                self.canvas1.ax.clear()
                (self.pix1, ) = \
                    self.canvas1.ax.plot(value[0],
                        value[1], color='r')
                self.canvas1.ax.add_patch(self.canvas1.rect)
                self.canvas1.ax.set_xlabel('Wavelength / A')
                self.canvas1.ax.set_ylabel('Transmission')
                if 0 not in value[1]:
                    self.canvas1.ax.set_yscale('log')
                #else:
                #    self.pix1.set_ydata(value[1])
                if self.canvas1.zoomSelected \
                    and self.canvas1.minX != self.canvas1.maxX \
                    and self.canvas1.minY != self.canvas1.maxY:
                    self.canvas1.ax.set_xlim(self.canvas1.minX,
                            self.canvas1.maxX)
                    self.canvas1.ax.set_ylim(self.canvas1.minY,
                            self.canvas1.maxY)
                self.canvas1.ax.relim()
                self.canvas1.ax.autoscale_view()
                self.canvas1.ax.tick_params(axis='both', which='major', labelsize=5)
                self.canvas1.draw()
        except:
            pass
            #self.pix1 = None
        index = self.comboBox.currentIndex()
        try:
            if str(value[2]) == 'clear' or str(value[3]) == 'clear':
                self.canvas2.ax.clear()
                self.canvas2.draw()
            elif len(value[2]) != len(value[3]) or len(value[3]) \
                == 0:
                pass
            else:
                #if not self.pix2:
                self.canvas2.ax.clear()
                (self.pix2, ) = \
                    self.canvas2.ax.plot(value[2],
                        value[3], color='b')
                self.canvas2.ax.add_patch(self.canvas2.rect)
                self.canvas2.ax.set_ylabel('Neutron Counts')
                self.canvas2.ax.set_title('Incident Monitor 2'
                        , fontsize=6)
                if index == 0:
                    self.canvas2.ax.set_xlabel('TOF / us')
                else:
                    self.canvas2.ax.set_xlabel('Wavelength')
                #else:
                #    self.pix2.set_ydata(value[3])
                if self.canvas2.zoomSelected \
                    and self.canvas2.minX != self.canvas2.maxX \
                    and self.canvas2.minY != self.canvas2.maxY:
                    self.canvas2.ax.set_xlim(self.canvas2.minX,
                            self.canvas2.maxX)
                    self.canvas2.ax.set_ylim(self.canvas2.minY,
                            self.canvas2.maxY)
                self.canvas2.ax.relim()
                self.canvas2.ax.autoscale_view()
                self.canvas2.draw()
        except:
            self.pix2 = None
        try:
            if str(value[4]) == 'clear' or str(value[5]) == 'clear':
                self.canvas3.ax.clear()
                self.canvas3.draw()
            elif len(value[4]) != len(value[5]) or len(value[5]) \
                == 0:
                pass
            else:
                #if not self.pix3:
                self.canvas3.ax.clear()
                (self.pix3, ) = \
                    self.canvas3.ax.plot(value[4],
                        value[5], color='b')
                self.canvas3.ax.add_patch(self.canvas3.rect)
                self.canvas3.ax.set_ylabel('Neutron Counts')
                self.canvas3.ax.set_title('Transmit Monitor 3'
                        , fontsize=6)
                if index == 0:
                    self.canvas3.ax.set_xlabel('TOF / us')
                else:
                    self.canvas3.ax.set_xlabel('Wavelength')
                #else:
                #    self.pix3.set_ydata(value[5])
                if self.canvas3.zoomSelected:
                    self.canvas3.ax.set_xlim(self.canvas3.minX,
                            self.canvas3.maxX)
                    self.canvas3.ax.set_ylim(self.canvas3.minY,
                            self.canvas3.maxY)
                self.canvas3.ax.relim()
                self.canvas3.ax.autoscale_view()
                self.canvas3.draw()
        except:
            pass
            #self.pix3 = None


