#!/usr/bin/python
# -*- coding: utf-8 -*-

# user defined

from canvas import *
from conf.constants import *


class CSNSScatteringPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSScatteringPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Horizontal)  # Vertical)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)

        self.splitter.setSizes([150, 150])  # , 150])

        # main Grid

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)

        _xsize = 16  # 6
        _ysize = 8  # 3
        self.canvas1 = zoomCanvas(  # _xsize,
                                    # _ysize,
                                    # self.plotColor,
                                    # self.title,
            self,
            5,
            5,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'x/mm',
            'y/mm',
            )
        #self.canvas1.ax.axis('equal',adjustable='box')
        self.canvas1.ax.set_aspect('equal')
        self.canvas1.x1 = self.canvas1.ax.axhline(0.0, color='black')
        self.canvas1.y1 = self.canvas1.ax.axvline(0.0, color='black')
        self.canvas1.ax.set_xlim(-504,496)
        self.canvas1.ax.set_ylim(-504,456)
        self.canvas1.draw()
        
        self.posLabel = QtGui.QLabel('', self.first)

        self.button = QtGui.QPushButton('Find Center', self.first)
        self.button.setMaximumWidth(100)
        self.button.setMaximumHeight(30)
        self.button.clicked.connect(self.buttonClicked)
        self.centerTextX = QtGui.QLabel('(x=', self.first)
        self.centerTextX.setMaximumHeight(30)
        self.centerTextX.setMaximumWidth(100)
        self.centerTextY = QtGui.QLabel('y= )', self.first)
        self.centerTextY.setMaximumHeight(30)
        self.centerTextY.setMaximumWidth(100)

        self.canvas2 = zoomCanvas(  # self.plotColor,
                                    # self.title,
            self,
            _xsize,
            _ysize,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'TOF',
            'Neutron Counts',
            )

        self.canvas3 = zoomCanvas(  # self.plotColor,
                                    # self.title,
            self,
            _xsize,
            _ysize,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'q (A-1)',
            'Scattering Intensity',
            )
        self.comboBox1 = QtGui.QComboBox()
        self.comboBox1.addItem('TOF')
        self.comboBox1.addItem('Wavelength')
        self.comboBox1.setMaximumWidth(150)
        self.comboBox1.activated.connect(self.comboChange)

        self.normLabel = QtGui.QLabel('Normalization by')
        self.comboBoxNorm = QtGui.QComboBox()
        self.comboBoxNorm.addItem('None')
        self.comboBoxNorm.addItem('Monitor')
        self.comboBoxNorm.addItem('Proton Charge')
        # self.comboBoxNorm.setCurrentIndex(1)
        self.comboBoxNorm.activated.connect(self.comboNormChange)
        
        self.comboBox2x = QtGui.QComboBox()
        self.comboBox2x.addItem('x:linear')
        self.comboBox2x.addItem('x:logarithmic')
        self.comboBox2x.setMaximumWidth(150)
        self.comboBox2x.activated.connect(self.comboBox2xChange)
        self.comboBox2y = QtGui.QComboBox()
        self.comboBox2y.addItem('y:linear')
        self.comboBox2y.addItem('y:logarithmic')
        self.comboBox2y.setMaximumWidth(150)
        self.comboBox2y.activated.connect(self.comboBox2yChange)

        _nline = 0
        self.firstGrid.addWidget(
            self.button,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )

        # self.firstGrid.addWidget(self.canvas2, _nline,2,7,1, QtCore.Qt.AlignTop)

        self.firstGrid.addWidget(
            self.centerTextX,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.firstGrid.addWidget(
            self.centerTextY,
            _nline,
            2,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.firstGrid.addWidget(
            self.canvas1,
            _nline,
            0,
            1,
            4,
            QtCore.Qt.AlignCenter,
            )
        _nline += 1
        self.firstGrid.addWidget(self.posLabel, _nline, 0, 1, 1)
        _nline = 0
        self.secondGrid.addWidget(self.comboBox1, _nline, 0, 1, 1)
        _nline += 1
        self.secondGrid.addWidget(self.canvas2, _nline, 0, 1, 7)
        _nline += 1
        self.secondGrid.addWidget(self.normLabel, _nline, 0, 1, 1)
        self.secondGrid.addWidget(self.comboBoxNorm, _nline, 1, 1, 1)
        self.secondGrid.addWidget(self.comboBox2x, _nline, 2, 1, 1)
        self.secondGrid.addWidget(self.comboBox2y, _nline, 3, 1, 1)
        _nline += 1
        self.secondGrid.addWidget(self.canvas3, _nline, 0, 1, 7)

        self.verticalLayout.addWidget(self.splitter)

        self.pix1 = None
        self.pix2 = None
        self.pix3 = None
        self.colorbar = None

    def buttonClicked(self):
        try:

            # x,y = self.fit2d(self.value[0], self.value[1], self.value[2])

            x = self.value[7][0]
            y = self.value[7][1]
            if x > -400 and x < 400 and y > -400 and y < 400:
                self.centerTextX.setText('(x=' + str(round(x, 5)) + ', ')
                self.centerTextY.setText('y=' + str(round(y, 5)) + ')')
                self.canvas1.x1 = self.canvas1.ax.axhline(y,
                        color='black')
                self.canvas1.y1 = self.canvas1.ax.axvline(x,
                        color='black')
                self.canvas1.draw()
        except:
            pass
        
    def comboNormChange(self):
        self.pix3 = None
        self.canvas3.zoomSelected = False
        self.parent.tabChange()

    def comboBox2xChange(self): 
        self.pix3 = None
        self.canvas3.zoomSelected = False
        xIndex = self.comboBox2x.currentIndex()
        if xIndex == 0:
            self.canvas3.ax.set_xscale('linear')
        else:
            self.canvas3.ax.set_xscale('log')
        self.canvas3.draw()

    def comboBox2yChange(self): 
        self.pix3 = None
        self.canvas3.zoomSelected = False
        yIndex = self.comboBox2y.currentIndex()
        if yIndex == 0:
            self.canvas3.ax.set_yscale('linear')
        else:
            self.canvas3.ax.set_yscale('log')
        self.canvas3.draw()

    def comboSelected(self):
        index = self.comboBox1.currentIndex()
        return index
    
    def comboChange(self):
        self.pix2 = None
        self.canvas2.zoomSelected = False
        self.parent.tabChange()
        index = self.comboBox1.currentIndex()
        if index == 0:
            self.canvas2.ax.set_xlabel('TOF')
        else:
            self.canvas2.ax.set_xlabel('Wavelength')
        self.canvas2.draw() 

    def normSelected(self):
        index = self.comboBoxNorm.currentIndex()
        return index

    def fit2d(
        self,
        x,
        y,
        z,
        ):
        import numpy as np
        import scipy.optimize as opt

        def gauss2d(
            xy,
            x0,
            y0,
            sigma,
            H,
            ):
            (x, y) = xy
            A = 1 / (2 * sigma ** 2)
            I = H * np.exp(-A * ((x - x0) ** 2 + (y - y0) ** 2))
            return I

        x = np.array(x)
        y = np.array(y)
        z = np.array(z)
        (xx, yy) = np.meshgrid(x, y)

        # nx=int(len(x)/2.0)
        # ny=int(len(y)/2.0)
        # amp=z[nx][ny]
        # x0=x[nx]
        # y0=y[ny]

        x0 = 0.0
        y0 = 0.0
        amp = np.max(z)
        guess = [x0, y0, 50.0, amp]

        (result, _tmp) = opt.curve_fit(gauss2d, (xx.ravel(),
                yy.ravel()), z.ravel(), p0=guess)
        print result[1], result[2]
        return (result[1], result[2])

    def clearCanvas(self):
        self.canvas1.ax.clear()
        self.canvas1.draw()
        self.canvas2.ax.clear()
        self.canvas2.draw()
        self.canvas3.ax.clear()
        self.canvas3.draw()

    def updateCanvas(
        self,
        value,
        started,
        _command,
        ):
        self.value = value
        # self.canvas2Axes.clear()
        if _command in ('configure', 'abort'):
            self.pix1 = None
            self.pix2 = None
            self.pix3 = None
        #elif not started:
        #    pass
        #else:
        color2D = 'r'
        color3D = 'rainbow'
        try:
            if str(value[2]) == 'clear':
                self.canvas1.ax.clear()
                self.canvas1.draw()
            elif len(value[2]) == 0:
                pass
            else:
                #if not self.pix1:
                self.canvas1.ax.clear()
                self.pix1 = \
                    self.canvas1.ax.pcolormesh(value[0],
                        value[1], value[2], cmap=color3D)
                self.canvas1.ax.add_patch(self.canvas1.rect)
                self.canvas1.ax.set_xlabel('X / mm')
                self.canvas1.ax.set_ylabel('Y / mm')
                #else:
                #    self.pix1.set_array(np.array(value[2]).ravel())
                if self.canvas1.zoomSelected \
                    and self.canvas1.minX != self.canvas1.maxX \
                    and self.canvas1.minY != self.canvas1.maxY:
                    self.canvas1.ax.set_xlim(self.canvas1.minX,
                            self.canvas1.maxX)
                    self.canvas1.ax.set_ylim(self.canvas1.minY,
                            self.canvas1.maxY)
                if not self.colorbar:
                    self.colorbar = \
                        self.canvas1.fig.colorbar(self.pix1,
                            ax=self.canvas1.ax,
                            extend='max')
                    self.colorbar.ax.tick_params(labelsize=4)
                else:
                    self.colorbar.on_mappable_changed(self.pix1)
                #self.canvas1.ax.relim()
                self.canvas1.ax.autoscale_view()
                #self.canvas1.ax.axis('equal', adjustable='box')
                self.canvas1.ax.set_aspect('equal')
                self.canvas1.draw()
        except:
            pass
            #self.pix1 = None
        try:
            if str(value[3]) == 'clear' or str(value[4]) == 'clear':
                self.canvas2.ax.clear()
                self.canvas2.draw()
            elif len(value[3]) != len(value[4]) or len(value[4]) \
                == 0:
                pass
            else:
                #if not self.pix2:
                self.canvas2.ax.clear()
                (self.pix2, ) = \
                    self.canvas2.ax.plot(value[3],
                        value[4], color='b')
                self.canvas2.ax.add_patch(self.canvas2.rect)
                self.canvas2.ax.set_ylabel('Neutron Counts')
                index = self.comboBox1.currentIndex()
                if index == 0:
                    self.canvas2.ax.set_xlabel('TOF')
                else:
                    self.canvas2.ax.set_xlabel('Wavelength')
                #else:
                    # self.pix2.set_xdata(value[6])
                #    self.pix2.set_ydata(value[4])
                if self.canvas2.zoomSelected \
                    and self.canvas2.minX != self.canvas2.maxX \
                    and self.canvas2.minY != self.canvas2.maxY:
                    self.canvas2.ax.set_xlim(self.canvas2.minX,
                            self.canvas2.maxX)
                    self.canvas2.ax.set_ylim(self.canvas2.minY,
                            self.canvas2.maxY)
                self.canvas2.ax.relim()
                self.canvas2.ax.autoscale_view()
                self.canvas2.draw()
        except:
            pass
            #self.pix2 = None
        try:
            if str(value[5]) == 'clear' or str(value[6]) == 'clear':
                self.canvas3.ax.clear()
                self.canvas3.draw()
            elif len(value[5]) != len(value[6]) or len(value[6]) \
                == 0:
                pass
            else:
                #if not self.pix3:
                self.canvas3.ax.clear()
                (self.pix3, ) = \
                    self.canvas3.ax.plot(value[5][:-1],
                        value[6][:-1], color='r')
                self.canvas3.ax.add_patch(self.canvas3.rect)
                self.canvas3.ax.set_xlabel('q (A-1)')
                self.canvas3.ax.set_ylabel('Scattering Intensity'
                        )
                self.canvas3.ax.set_title('I(q)',
                        fontsize=7)
                #else:
                    # self.pix3.set_xdata(value[8])
                #    self.pix3.set_ydata(value[6])
                if self.canvas3.zoomSelected \
                    and self.canvas3.minX != self.canvas3.maxX \
                    and self.canvas3.minY != self.canvas3.maxY:
                    self.canvas3.ax.set_xlim(self.canvas3.minX,
                            self.canvas3.maxX)
                    self.canvas3.ax.set_ylim(self.canvas3.minY,
                            self.canvas3.maxY)
                xIndex = self.comboBox2x.currentIndex()
                if xIndex == 0:
                    self.canvas3.ax.set_xscale('linear')
                else:
                    self.canvas3.ax.set_xscale('log')
                yIndex = self.comboBox2y.currentIndex()
                if yIndex == 0:
                    self.canvas3.ax.set_yscale('linear')
                else:
                    self.canvas3.ax.set_yscale('log')
                self.canvas3.ax.relim()
                self.canvas3.ax.autoscale_view()
                self.canvas3.draw()
        except:
            pass
