#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2016.12.12
'''

from conf.constants import *

from canvas import *

# from model.readData import *
# from model.readImage import *
# from presenter.updateStreaming import *

from model.neonReceiver import *


# from model import neonReceiver

class monitorDock(QtGui.QDockWidget):

    def __init__(
        self,
        parent,
        neon2DID,
        neon3DID,
        width,
        height,
        plotColor2D,
        plotColor3D,
        title,
        ):

        super(monitorDock, self).__init__(parent)
        self.parent = parent

        self.neon2DID = neon2DID
        self.neon3DID = neon3DID

        self.width = width
        self.height = height
        self.plotColor2D = plotColor2D
        self.plotColor3D = plotColor3D
        self.title = title

        self.setupUi(self)

    def setupUi(self, Widget):
        self.setFeatures(QtGui.QDockWidget.DockWidgetFloatable
                         | QtGui.QDockWidget.DockWidgetMovable)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        # main  grid

        self.mainGrid = QtGui.QGridLayout(self.first)

        # _xsize = 9
        # _ysize = 0.8

        # Backward TOF/d

        self.pauseButton = QtGui.QPushButton('Pause')

        # self.pauseButton.setEnabled(False)

        self.pauseButton.setFixedSize(QtCore.QSize(60, 20))
        self.pauseButton.clicked.connect(self.clickPauseBank)

        self.imageCanvas = zoomCanvas(
            self,
            self.width,
            self.height,
            150,
            self.plotColor3D,
            'Monitor 1',
            'X /mm',
            'Y /mm',
            )
        self.comboBox = QtGui.QComboBox()
        self.comboBox.addItem('TOF')
        self.comboBox.addItem('Wavelength')
        self.comboBox.activated.connect(self.comboChange)

        self.patternCanvas = zoomCanvas(
            self,
            self.width,
            self.height,
            150,
            self.plotColor2D,
            'Monitor 1',
            'TOF',
            'Neutron Counts',
            )

        self.label = QtGui.QLabel(self.title)

        _nline = 0
        self.mainGrid.addWidget(
            self.pauseButton,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.label, _nline, 1, 1, 1)
        self.mainGrid.addWidget(
            self.comboBox,
            _nline,
            2,
            1,
            1,
            QtCore.Qt.AlignRight,
            )
        _nline += 1
        self.mainGrid.addWidget(self.imageCanvas, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.patternCanvas, _nline, 1, 1, 1)

        self.setWidget(self.scrollArea)

         # self.setCentralWidget(self)

    def getComboIndex(self):
        index = self.comboBox.currentIndex()
        return index

    def comboChange(self):
        index = self.comboBox.currentIndex()
        if index == 0:
            self.patternCanvas.ax.set_xlabel('TOF / us')
        else:
            self.patternCanvas.ax.set_xlabel('Wavelength')
        self.parent.parent.tabChange()
        self.patternCanvas.draw()

    def getImageCanvas(self):
        return self.imageCanvas

    def getPatternCanvas(self):
        return self.patternCanvas

    def clickPauseBank(self):
        if self.pauseButton.text() == 'Pause':
            self.pauseButton.setText('Resume')
        elif self.pauseButton.text() == 'Resume':
            self.pauseButton.setText('Pause')
        self.parent.setStatus()

    def enablePauseBank(self, enable):
        self.pauseButton.setEnabled(enable)


