#!/usr/bin/python
# -*- coding: utf-8 -*-
from PyQt4 import QtGui, QtCore
import sys
import random
import time
import json
from model import jsonArray
import cStringIO
from PIL import Image
import base64
import numpy


class getCommand(QtCore.QObject):

    finished = QtCore.pyqtSignal()
    signalStatus = QtCore.pyqtSignal(str)
    signalLog = QtCore.pyqtSignal(str)

    def __init__(
        self,
        parent,
        neonServer,
        commandPath,
        refreshTime,
        ):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.commandPath = commandPath
        self.refreshTime = refreshTime
        self.command = True
        self.commandLog = 0

    def pause(self):
        self.command = False

    @QtCore.pyqtSlot()
    def process(self):
        while True:
            if not self.command:
                break
            try:
                _command = self.neonServer.get(self.commandPath)
                if _command is None:
                    if self.commandLog == 0:
                        self.signalLog.emit('Empty command Data from NEON!'
                                )
                        self.commandLog += 1
                else:
                    try:
                        _command = str(json.loads(_command))
                        self.signalStatus.emit(_command)
                        self.commandLog = 0
                    except:
                        pass
            except:
                pass
            try:
                time.sleep(self.refreshTime)
            except:
                pass
        self.finished.emit()

    def set(self, command):
        self.command = command

    def get(self):
        return self.command


class getNeonData(QtCore.QObject):

    finished = QtCore.pyqtSignal()
    signalProgress = QtCore.pyqtSignal(str)
    signalStatus = QtCore.pyqtSignal(object)
    signalMonitor = QtCore.pyqtSignal(object)
    signalExperiment = QtCore.pyqtSignal(object, object, object, object, object)
    signalTime = QtCore.pyqtSignal(object, object)
    signalTemp = QtCore.pyqtSignal(object)
    signalLog = QtCore.pyqtSignal(str)

    def __init__(
        self,
        parent,
        neonServer,
        progressPath,
        protonPath,
        detectorPath, 
        detectorRatePath, 
        monitorPath, 
        monitorRatePath,
        pulsePath,
        startPath,
        endPath,
        tempPath,
        refreshTime,
        ):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.progressPath = progressPath
        self.protonPath = protonPath
        self.detectorPath = detectorPath
        self.detectorRatePath = detectorRatePath
        self.monitorPath = monitorPath
        self.monitorRatePath = monitorRatePath

        self.pulsePath = pulsePath
        self.startPath = startPath
        self.endPath = endPath
        self.tempPath = tempPath
        self.refreshTime = refreshTime
        self.started = True
        self.imgpath = None
        self.kwargs = {}
        self.tabIndex = 0
        self.monitorTOFPath = '/SANS/workspace/MantidData/monitor2/tof'
        self.monitorCountsPath = \
            '/SANS/workspace/MantidData/monitor2/counts'
        self.monitorTOF = []

        self.scatteringx = []
        self.scatteringy = []
        self.pidXaxis = []
        self.xyXaxis = []
        self.xyYaxis = []
        for i in range(6):
            self.pidXaxis.append([])
            self.xyXaxis.append([])
            self.xyYaxis.append([])
        self.progressLog = 0
        self.monitorTOFLog = 0
        self.monitorCountsLog = 0
        self.scatteringLog = 0
        self.tubeLog = 0
        self.detectorLog = 0
        self.transmissionLog = 0
        self.monitorLog = 0
        self.expeLog = 0

    def __del__(self):
        self.wait()

    def pause(self):
        self.started = False

    def set(self, value):
        self.started = value

    def get(self):
        return self.started

    def resume(self):
        if not self.started:
            self.started = True

    @QtCore.pyqtSlot()
    def process(self):

        # progress setting in mainSet
        self.getProgressValue()

        while True:
            _data = []
            _started = self.get()
            if not _started:
                continue

            # Monitor TOF in User Panel 
            self.getMonitorTOFData()

            # Monitor Counts in User Panel
            self.getMonitorCountsData()

            # get Proton Charge and Neutron Counts in User
            _proton = None
            _detector = None
            _detectorRate = None
            _monitor = None
            _monitorRate = None

            try:
                _proton = self.getPathData(self.protonPath)
                _proton = json.loads(_proton)
                if _proton == [[],[]] or str(_proton) == 'clear' or _proton == None:
                    _proton = [[0],[0]]
            except:
                _proton = [[0],[0]]
            try:
                _detector = self.getPathData(self.detectorPath)
                _detector = json.loads(_detector)
                if _detector == [[],[]] or str(_detector) == 'clear' or _detector == None:
                    _detector = [[0],[0]]
            except:
                detector = [[0],[0]]
            try:
                _detectorRate = self.getPathData(self.detectorRatePath)
                _detectorRate = json.loads(_detectorRate)
                if str(_detectorRate) == 'clear' or _detectorRate == None:
                    _detectorRate = 0.0
            except:
                _detectorRate = 0.0
            try:
                _monitor = self.getPathData(self.monitorPath)
                _monitor = json.loads(_monitor)
                if _monitor == [[],[]] or str(_monitor) == 'clear' or _monitor == None:
                    _monitor = [[0],[0]]
            except:
                monitor = [[0],[0]]
            try:
                _monitorRate = self.getPathData(self.monitorRatePath)
                _monitorRate = json.loads(_monitorRate)
                if str(_monitorRate) == 'clear' or _monitorRate == None:
                    _monitorRate = 0.0
            except:
                _monitorRate = 0.0
            try:
                #print _proton[1][-1],_detector[1][-1],_detectorRate,_monitor[1][-1],_monitorRate
                self.signalExperiment.emit(format(_proton[1][-1], '.2f'), _detector[1][-1], _detectorRate, _monitor[1][-1], _monitorRate)
            except:
                pass

            # get start and end time for user

            _start = self.getPathData(self.startPath)
            _end = self.getPathData(self.endPath)
            try:
                _start = json.loads(_start)
                _end = json.loads(_end)
                self.signalTime.emit(_start, _end)
            except:
                pass

            try:
                _temp = self.getPathData(self.tempPath)
                _temp = json.loads(_temp)
                self.signalTemp.emit(_temp)
            except:
                pass

            # get Tab index

            try:
                self.tabIndex = self.kwargs['tabIndex']
            except:
                pass

            # Scattering page

            if self.tabIndex == 0:
                self.getScatteringData()

            # Tube page
            elif self.tabIndex == 1:
                self.getTubeData()

            # Detector page
            elif self.tabIndex == 2:
                self.getDetectorData()

            # Transmission page
            elif self.tabIndex == 3:
                self.getTransmissionData()

            # Monitor page
            elif self.tabIndex == 4:
                self.getMonitorData()

            # Experiment page
            elif self.tabIndex == 5:
                self.getExperimentData()

            try:
                time.sleep(self.refreshTime)
            except:
                pass
        self.finished.emit()

    def getProgressValue(self):
        # progress setting in mainSet
        try:
            # get json date after json.dumps from neon
            progress = self.neonServer.get(self.progressPath)
            if progress is None:
                if self.progressLog == 0:
                    self.signalLog.emit('Empty progressBar Setting Data!'
                            )
                    self.progressLog += 1
            else:
                self.signalProgress.emit(progress)
                self.progressLog = 0
        except:
            pass

    def getMonitorTOFData(self):
        _data = []
        try:
            _data = self.neonServer.get(self.monitorTOFPath)
        except:
            pass
        if _data is None:
            if self.monitorTOFLog == 0:
                self.signalLog.emit("Empty Monitor TOF Data!")
                self.monitorTOFLog += 1
        else:
            try:
                _data = jsonArray.jsonDecoder(_data)
                self.monitorTOF=_data
                self.monitorTOFLog = 0
            except:
                if self.monitorTOFLog < 2:
                    self.signalLog.emit("Incompleted Monitor TOF Data")
                    self.monitorTOFLog += 1
        return self.monitorTOF

    def getMonitorCountsData(self):
        _data = []
        try:
            _data = self.neonServer.get(self.monitorCountsPath)
        except:
            pass
        if _data is None :
            if self.monitorCountsLog == 0:
                self.signalLog.emit("Empty Monitor Counts Data!")
                self.monitorCountsLog += 1
        else:
            try:
                _data = jsonArray.jsonDecoder(_data)
                self.signalMonitor.emit(_data)
                self.monitorCountsLog = 0
            except:
                if self.monitorCountsLog < 2:
                    self.signalLog.emit("Incompleted Monitor Counts Data")
                    self.monitorCountsLog += 1

    def getScatteringData(self):
        _data = []
        value = []
        for i in range(len(self.kwargs) - 1):
            value.append([])
        for i in range(len(self.kwargs) - 1):
            try:
                _data = self.neonServer.get(self.kwargs['path'
                        + str(i + 1)])
                if _data is None:
                    if self.scatteringLog == 0:
                        self.signalLog.emit('Empty path'
                                + str(i + 1) + ' Data!')
                        self.scatteringLog += 1
                else:
                    try:
                        _data = jsonArray.jsonDecoder(_data)
                    except:
                        if self.scatteringLog < 2:
                            self.signalLog.emit('Incompleted path'
 + str(i + 1) + 'Data!')
                            self.scatteringLog += 1
                value[i] = _data
            except:
                pass
        try:
            self.signalStatus.emit(value)
        except:
            pass

    def getTubeData(self):
        _data = []
        value = []
        for i in range(len(self.kwargs) - 1):
            value.append([])
        for i in range(len(self.kwargs) - 1):
            try:
                _data = self.neonServer.get(self.kwargs['path'
                        + str(i + 1)])
            except:
                pass
            if _data is None:
                if self.tubeLog == 0:
                    self.signalLog.emit('Empty Tube Canvas Data!'
                            )
                    self.tubeLog += 1
            else:
                try:
                    _data = jsonArray.jsonDecoder(_data)
                except:
                    if self.tubeLog < 2:
                        self.signalLog.emit('Incompleted Tube Canvas data'
                                )
                        self.tubeLog += 1
            value[i] = _data
        try:
            self.signalStatus.emit(value)
        except:
            pass

    def getDetectorData(self):
        _data = []
        value = []
        for i in range(len(self.kwargs) - 1):
            value.append([])
        for i in range(len(self.kwargs) - 1):
            try:
                _data = self.neonServer.get(self.kwargs['path'
                        + str(i + 1)])
            except:
                pass
            if _data is None:
                if self.detectorLog == 0:
                    self.signalLog.emit('Empty Detector Canvas Data!'
                            )
                    self.detectorLog += 1
            else:
                try:
                    _data = jsonArray.jsonDecoder(_data)
                except:
                    if self.detectorLog < 2:
                        self.signalLog.emit('Incompleted Detector Canvas data'
                                )
                        self.detectorLog += 1
            value[i] = _data
        try:
            self.signalStatus.emit(value)
        except:
            pass

    def getTransmissionData(self):
        _data = []
        value = []
        try:
            for i in range(len(self.kwargs) - 1):
                _data = self.neonServer.get(self.kwargs['path'
                        + str(i + 1)])
                if _data is None:
                    if self.transmissionLog == 0:
                        self.signalLog.emit('Empty Canvas Data!'
                                )
                        self.transmissionLog += 1
                else:
                    try:
                        _data = jsonArray.jsonDecoder(_data)
                    except:
                        if self.transmissionLog < 2:
                            self.signalLog.emit('Incompleted Canvas data'
)
                            self.transmissionLog += 1
                value.append(_data)
        except:
            pass
        try:
            self.signalStatus.emit(value)
        except:
            pass

    def getMonitorData(self):
        _data = []
        value = []
        _pause = []
        try:
            _pause = self.kwargs['status']
        except:
            pass
        for _ini in range(len(self.kwargs) - 2):
            value.append([])
        for i in range(len(self.kwargs) - 2):
            _array = []
            for key in range(len(self.kwargs['path1'])):
                _array.append([])
            try:
                for j in range(len(self.kwargs['path1'])):
                    if _pause[j] == 'Pause':
                        _data = \
                            self.neonServer.get(self.kwargs['path'
                                 + str(i + 1)][j])
                        if _data is None:
                            if self.monitorLog == 0:
                                self.signalLog.emit('Empty Canvas Data!'
)
                                self.monitorLog += 1
                        else:
                            try:
                                _data = \
jsonArray.jsonDecoder(_data)
                                _array[j] = _data
                            except:
                                if self.monitorLog < 2:
                                    self.signalLog.emit('Incompleted Canvas data'
)
                                    self.monitorLog += 1
                    else:
                        pass
                value[i] = _array
            except:
                pass
        try:
            self.signalStatus.emit(value)
        except:
            pass

    def getExperimentData(self):
        _data = []
        value = []
        for _ini in range(len(self.kwargs) - 1):
            value.append([])
        try:
            for i in range(len(self.kwargs) - 1):
                _data = \
                    self.neonServer.get(self.kwargs['path'
                        + str(i + 1)])
                if _data is None:
                    if self.expeLog == 0:
                        self.signalLog.emit('Empty Canvas Data!'
)
                        self.expeLog += 1
                else:
                    try:
                        _data = jsonArray.jsonDecoder(_data)
                    except:
                        if self.expeLog < 2:
                            self.signalLog.emit('Incompleted Canvas data'
)
                            self.expeLog += 1
                value[i] = _data
        except:
            pass
        try:
            self.signalStatus.emit(value)
        except:
            pass

    def getPathData(self, path):
        _data = []
        try:
            _data = self.neonServer.get(path)
        except:
            pass
        if _data is None:
            pass#_data = json.dumps('--')
        elif _data == 'clear':
            pass#_data = json.dumps('--')
        else:
            try:
                _date = jsonArray.jsonDecoder(_data)
            except:
                pass#_data = json.dumps('--')
        return _data

    def setDataPath(self, kwargs):
        self.kwargs = kwargs

    def getTabIndex(self):
        return self.tabIndex

    def getMonitorTOF(self):
        return self.monitorTOF

    def getDetectorIndex(self):
        return self.parent.getDetectorIndex()


class workerThread(QtCore.QThread):

    def __init__(self, parent):
        super(workerThread, self).__init__(parent)

    def __del__(self):
        self.wait()


