#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2017.05.15

Detector
'''
from conf.constants import *

# user defined

from model.readData import *
from canvas import *
from model.readImage import *
from model.protonSimulator import *
from presenter.updateStreaming import *
from presenter.progressBarThread import *

class CSNSScatteringPage(QtGui.QTabWidget):#QMainWindow):

    def __init__(self, parent):
        super(CSNSScatteringPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        #main Grid
        self.mainGrid = QtGui.QGridLayout(self.first)

        _xsize = 16#6
        _ysize = 8#3
        self.BankCanvas = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'X',
            'Y',
            )

        self.canvas = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'X',
            'Y',
            )

        _nline = 0
        self.mainGrid.addWidget(self.BankCanvas, _nline,0,1,1)
        _nline += 1
        self.mainGrid.addWidget(self.canvas, _nline,0,1,1)
        self.verticalLayout.addWidget(self.scrollArea)       
 
    def updateCanvas(self, value, started):
        self.BankCanvas.ax.clear()
        self.canvas.ax.clear()
        if not started:
            pass
        else:
            color2D = 'r'
            color3D = 'hot'
            #self.BankCanvas.ax.pcolormesh(value[0], value[1], value[2], cmap=color3D)
            self.canvas.ax.plot(value[3], value[4], color=color2D)
            try:
                self.BankCanvas.ax.pcolormesh(value[0], value[1], value[2], cmap=color3D)
                self.canvas.ax.plot(value[3], value[4], color=color2D)
            except:
                pass
        plt.pause(0.0001)
        self.BankCanvas.draw()
        self.canvas.draw()
