#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for user defined

from scattering import *
from detector import *
from transmission import *
from monitor import *
from experiment import *
from model.chopperModel import *


class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSMainTab, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.scatteringPage = CSNSScatteringPage(self)
        self.detectorPage = CSNSDetectorPage(self)
        self.transmissionPage = CSNSTransmissionPage(self)
        self.monitorPage = CSNSMonitorPage(self)
        self.experimentPage = CSNSExperimentPage(self)

        self.addTab(self.scatteringPage, 'Scattering')
        self.addTab(self.detectorPage, 'Detector')
        self.addTab(self.transmissionPage, 'Transmission')
        self.addTab(self.monitorPage, 'Monitor')
        self.addTab(self.experimentPage, 'Progress')
    
        self.currentChanged.connect(self.tabChange)

    def updateDiffractionSimulator(self):
        self.histogramPage.startDiffractionSimulator()

    def updateDataStreaming(self):
        self.histogramPage.startDataStreaming()

    def updateProton(self, threadID):
        self.experimentPage.startProtonSimulator()

    def getScatteringPath(self):
        path1 = '/GPPD/workspace/MantidData/monitor01/axis_x'
        path2 = '/GPPD/workspace/MantidData/monitor01/axis_y'
        path3 = '/GPPD/workspace/MantidData/monitor01/value'
        path4 = '/GPPD/workspace/MantidData/group01/tof'
        path5 = '/GPPD/workspace/MantidData/group01/counts'
        return path1, path2, path3, path4, path5

    def getDetectorPath(self):
        pidXaxisPath = []
        pidValuePath = []
        xyXaxisPath = []        
        xyYaxisPath = []        
        xyValuePath = []        
        for i in range (bankIndex+1):
            pidXaxisPath.append("/GPPD/workspace/MantidData/bank"+str(bankIndex+1).zfill(2)+"/pid_image/x")
            pidValuePath.append("/GPPD/workspace/MantidData/bank"+str(bankIndex+1).zfill(2)+"/pid_image/value")
            xyXaxisPath.append("/GPPD/workspace/MantidData/bank"+str(bankIndex+1).zfill(2)+"/xy_image/x") 
            xyYaxisPath.append("/GPPD/workspace/MantidData/bank"+str(bankIndex+1).zfill(2)+"/xy_image/y") 
            xyValuePath.append("/GPPD/workspace/MantidData/bank"+str(bankIndex+1).zfill(2)+"/xy_image/value") 
        return pidXaxisPath, pidValuePath, xyXaxisPath, xyYaxisPath, xyValuePath

    def getTransmissionPath(self):
        path1 = '/GPPD/workspace/MantidData/group02/tof'
        path2 = '/GPPD/workspace/MantidData/group02/counts'
        return path1, path2

    def getMonitorPath(self):
        monitorStatus = []
        monitorAxisXPath = []
        monitorAxisYPath = []
        monitorValuePath = []
        monitorTOFPath = []
        monitorCountsPath = []
        for i in range(len(self.monitorPage.monitorDock)):
            monitorStatus.append(self.monitorPage.monitorDock[i].pauseButton.text())
            monitorAxisXPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/axis_x')
            monitorAxisYPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/axis_y')
            monitorValuePath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/value')
            monitorTOFPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/tof')
            monitorCountsPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/counts')
        return monitorStatus, monitorAxisXPath, monitorAxisYPath, monitorValuePath, monitorTOFPath, monitorCountsPath

    def getExperimentPath(self):
        protonPath = []
        neutronPath = []
        pulsePath = []
        protonPath='/GPPD/drone/proton_charge'
        neutronPath='/GPPD/workspace/MantidData/neutron_counts'
        pulsePath='/GPPD/drone/pulse_counts'
        return protonPath, neutronPath, pulsePath
    
    def setStatus(self):
        self.tabChange()

    def tabChange(self):
        groupStatus = []
        groupTOFPath = []
        groupCountsPath = []
        pidXaxisPath = []
        pidValuePath = []
        xyXaxisPath = []
        xyYaxisPath = []
        xyValuePath = []
        monitorStatus = []
        monitorAxisXPath = []
        monitorAxisYPath = []
        monitorValuePath = []
        monitorTOFPath = []
        monitorCountsPath = []
        protonPath = []
        neutronPath = []
        pulsePath = []
        tabIndex = self.currentIndex()

        if tabIndex == 0:
            path1, path2, path3, path4, path5 = self.getScatteringPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2, "path3": path3, "path4": path4, "path5": path5}
        elif tabIndex == 1:
            #pidXaxisPath, pidValuePath, xyXaxisPath, xyYaxisPath, xyValuePath = self.getDetectorPath()
            #kwargs = {'tabIndex': tabIndex, 'path1': pidXaxisPath, 'path2': pidValuePath, 'path3': xyXaxisPath, 'path4': xyYaxisPath, 'path5': xyValuePath}
            kwargs = {'tabIndex': tabIndex}
        elif tabIndex == 2:
            path1, path2 = self.getTransmissionPath()
            kwargs = {'tabIndex': tabIndex, 'path1': path1, 'path2': path2}
        elif tabIndex == 3:
            monitorStatus, monitorAxisXPath, monitorAxisYPath, monitorValuePath, monitorTOFPath, monitorCountsPath = self.getMonitorPath()
            kwargs = {"tabIndex": tabIndex, "path1": monitorValuePath, "path2": monitorAxisXPath, "path3": monitorAxisYPath, "path4": monitorTOFPath,"path5": monitorCountsPath, "status": monitorStatus}

        elif tabIndex == 4:
            protonPath, neutronPath, pulsePath = self.getExperimentPath()
            kwargs = {"tabIndex": tabIndex, "path1": pulsePath, "path2": protonPath, "path3": neutronPath}
       
        self.parent.setDataPath(kwargs)
