'''
Created on 2015.6.2
@author: yll
'''
# configure
from conf.constants import *

# user defined
from model.readData import *
from model.slitModel import *
from presenter.slitSignal import *
from viewer.canvas import *

class CSNSDetectorPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,Widget):
#        self.horizontalLayoutWidget = QtGui.QWidget(self.tab_slit)
        self.horizontalLayout = QtGui.QVBoxLayout(self)

        #slit tab control
        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        #for main  grid
        self.mainGrid = QtGui.QGridLayout(self.first)
        
        _width=3.5
        # canvas for slitImage
        #self.slitImageCanvas= CSNSCanvas(self)
        self.slitImageCanvas = figureCanvas(
            self,
            _width,
            _width,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'X / mm',
            'Y / mm',
            )

        self.dataX, self.dataY, self.dataZ = CSNSRead3DData("./dat/3d1.dat")
        cset = self.slitImageCanvas.ax.contourf(self.dataY, self.dataX, self.dataZ, zdir='z', offset=0, cmap=cm.coolwarm)
        self.slitImageCanvas.x1 = self.slitImageCanvas.ax.axhline(52,color='gray')
        #self.slitImageCanvas.x2 = self.slitImageCanvas.ax.axhline(48,color='gray')
        self.slitImageCanvas.y1 = self.slitImageCanvas.ax.axvline(48,color='gray')
        #self.slitImageCanvas.y2 = self.slitImageCanvas.ax.axvline(52,color='gray')
        self.slitImageCanvas.draw()

        self.slitImageEvents()

        # canvas for slit x
        #self.slitXCanvas = CSNSCanvas(self, 3, 2)
        self.slitXCanvas = figureCanvas(
            self,
            _width,
            1,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'Y / mm',
            'Neutron Counts',
            )

        self.slitXCanvas.ax.yaxis.tick_right()
        nx, dataX = CSNSRead2DData("./dat/2d-x.dat")
        _tmp=self.slitXCanvas.ax.plot(dataX[0],dataX[1],color='red')
        self.slitXCanvas.slitXFigure=_tmp[0]
        self.slitXCanvas.draw()

        # canvas for slit y
        #self.slitYCanvas = CSNSCanvas(self, 3, 2)
        self.slitYCanvas = figureCanvas(
            self,
            1,
            _width,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'X / mm',
            'Neutron Counts',
            )

        ny, dataY = CSNSRead2DData("./dat/2d-y.dat")
        _tmp=self.slitYCanvas.ax.plot(dataY[1],dataY[0],color='green')
        self.slitYCanvas.slitYFigure=_tmp[0]
        #self.slitYCanvas.draw()

        self.sliderY=QtGui.QSlider(QtCore.Qt.Horizontal)
        self.sliderX=QtGui.QSlider(QtCore.Qt.Vertical)

        # parameter grid
        self.directBeamLabel =  QtGui.QLabel("<font color=red>Direct Beam:</font>")
        self.directBeamText=QtGui.QLabel("(25,50) ")

        self.reflectedBeamLabel =  QtGui.QLabel("<font color=red>Reflected Beam:</font>")
        self.reflectedBeamText=QtGui.QLabel("(64,50)")

        self.parameterWidget= QtGui.QWidget(self.first)
        self.parameterGrid = QtGui.QGridLayout(self.parameterWidget)
        
        _nline = 0
        self.mainGrid.addWidget(self.slitXCanvas,_nline,1,1,1)
        _nline += 1
        self.mainGrid.addWidget(self.slitYCanvas,_nline,0,1,1,QtCore.Qt.AlignRight)
        self.mainGrid.addWidget(self.slitImageCanvas,_nline,1,1,1)
        self.mainGrid.addWidget(self.sliderX,_nline,2,1,1, QtCore.Qt.AlignLeft)
        _nline += 1
        self.mainGrid.addWidget(self.sliderY,_nline,1,1,1, QtCore.Qt.AlignTop)
        _nline += 1
        self.mainGrid.addWidget(self.parameterWidget,_nline,0,1,1, QtCore.Qt.AlignTop)

        self.mainGrid.columnStretch(1)
        
        _nline += 1
        self.parameterGrid.addWidget(self.directBeamLabel,_nline,0,1,1)
        self.parameterGrid.addWidget(self.directBeamText,_nline,1,1,1)
        _nline += 1
        self.parameterGrid.addWidget(self.reflectedBeamLabel,_nline,0,1,1)
        self.parameterGrid.addWidget(self.reflectedBeamText,_nline,1,1,1)
        
        self.horizontalLayout.addWidget(self.scrollArea)

    def slitImageEvents(self):
        self.slitImageCanvas.mpl_connect('button_press_event', self.changeRegion)
        #self.slitImageCanvas.mpl_connect('motion_notify_event', self.changeRegion)
        #self.slitImageCanvas.mpl_connect('button_release_event', self.changeXYFigure)
        self.slitImageCanvas.mpl_connect('button_press_event', self.changeXYFigure)

    def changeRegion(self,event):
        _canvas = self.slitImageCanvas

        if event.button == 1:
            _canvas.x1.set_ydata([event.ydata,event.ydata])
            _canvas.draw()
            self.slitXCanvas.draw()
        elif event.button == 3:
            _canvas.y1.set_xdata([event.xdata,event.xdata])
            _canvas.draw()
        else:
            pass

    def changeXYFigure(self,event):

        if event.button == 1:
            dataYZ, dataXZ = getXYdata(event.ydata, event.xdata, self.dataX, self.dataY, self.dataZ)
            self.slitXCanvas.slitXFigure.set_xdata(dataYZ[0])
            self.slitXCanvas.slitXFigure.set_ydata(dataYZ[1])
            self.slitXCanvas.draw()
        elif event.button == 3:
            dataYZ, dataXZ = getXYdata(event.ydata, event.xdata, self.dataX, self.dataY, self.dataZ)
            self.slitYCanvas.slitYFigure.set_xdata(dataXZ[1])
            self.slitYCanvas.slitYFigure.set_ydata(dataXZ[0])
            self.slitYCanvas.draw()
        else:
            pass
