#!/usr/bin/python
# -*- coding: utf-8 -*-

# user defined
from canvas import *
from conf.constants import *

class CSNSScatteringPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSScatteringPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)
        
        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.third = QtGui.QFrame(self)
        self.third.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea3 = QtGui.QScrollArea()
        self.scrollArea3.setWidgetResizable(True)
        self.scrollArea3.setWidget(self.third)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)
        #self.splitter.addWidget(self.scrollArea3)
        self.splitter.setSizes([300, 150])#, 150])

        #main Grid
        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
        self.thirdGrid = QtGui.QGridLayout(self.third)

        _xsize = 16#6
        _ysize = 8#3
        self.canvas1 = figureCanvas(
            self,
            5,#_xsize,
            5,#_ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'x/mm',
            'y/mm',
            )
        '''
        self.canvas2 = figure3DCanvas(
            self,
            2,#_xsize,
            2,#_ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'X',
            'Y',
            )
        '''
        self.canvas2Fig = Figure((5,5), dpi=150, facecolor="white", edgecolor=None, linewidth=1.0, frameon=False, tight_layout=True)
        self.canvas2Fig.subplots_adjust(left=0.0, bottom=0.05, right=0.95, top=0.95)
        self.canvas2 = FigureCanvas(self.canvas2Fig)
        self.canvas2.setParent(self)
        self.canvas2Axes = self.canvas2Fig.add_subplot(111,projection='3d')
        self.canvas2Axes.tick_params(axis='both', which='major', labelsize=0.1)
        self.canvas2Axes.axis('off')
        self.canvas2Axes.set_xlabel('qx')
        self.canvas2Axes.set_ylabel('qy')
        #self.canvas2Fig.colorbar(self.canvas2Fig, shrink=0.5, aspect=5)
        #self.canvas2Axes.set_visible(False)
        #self.canvas2Axes.get_xaxis().set_visible(False)
        #self.canvas2Axes.get_yaxis().set_visible(False)
    
        self.canvas1.x1 = self.canvas1.ax.axhline(0.5,color='white')
        self.canvas1.y1 = self.canvas1.ax.axvline(0.5,color='white')
        self.canvas1.draw()

        self.button = QtGui.QPushButton('Find Center',self.first)
        self.button.setMaximumWidth(150)
        self.button.setMaximumHeight(30)
        self.button.clicked.connect(self.buttonClicked)
        self.centerTextX = QtGui.QLabel('x=',self.first)
        self.centerTextX.setMaximumHeight(30)
        self.centerTextY = QtGui.QLabel('y=',self.first)
        self.centerTextY.setMaximumHeight(30)

        self.canvas3 = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'q (A-1)',
            'Neutron Counts',
            )

        self.canvas4 = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'q (A-1)',
            'Scattering Intensity',
            )
        self.comboBox1 = QtGui.QComboBox()
        self.comboBox1.addItem('linear')
        self.comboBox1.addItem('logarithmic')
        self.comboBox1.setMaximumWidth(150)
        #self.comboBox1.activated.connect(self.comboSelected)

        self.normLabel = QtGui.QLabel('Normalization by')
        self.comboBoxNorm = QtGui.QComboBox()
        self.comboBoxNorm.addItem('Monitor')
        self.comboBoxNorm.addItem('Proton Charge')
        self.comboBoxNorm.activated.connect(self.parent.tabChange)
        self.comboBox2 = QtGui.QComboBox()
        self.comboBox2.addItem('linear')
        self.comboBox2.addItem('logarithmic')
        self.comboBox2.setMaximumWidth(150)

        _nline = 0
        self.firstGrid.addWidget(self.button, _nline,0,1,1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.canvas1, _nline,1,7,1, QtCore.Qt.AlignCenter)
        self.firstGrid.addWidget(self.canvas2, _nline,2,7,1, QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.comboBox1, _nline,0,1,1)
        self.secondGrid.addWidget(self.normLabel, _nline,7,1,1)
        self.secondGrid.addWidget(self.comboBoxNorm, _nline,8,1,1)
        self.secondGrid.addWidget(self.comboBox2, _nline,9,1,1)
        #self.thirdGrid.addWidget(self.comboBox2, _nline,0,1,1)
        _nline += 1
        self.firstGrid.addWidget(self.centerTextX, _nline,0,1,1, QtCore.Qt.AlignLeft)
        self.secondGrid.addWidget(self.canvas3, _nline,0, 1, 7)
        self.secondGrid.addWidget(self.canvas4, _nline,7, 1, 7)
        #self.thirdGrid.addWidget(self.canvas4, _nline,0, 1, 7)
        _nline += 1
        self.firstGrid.addWidget(self.centerTextY, _nline,0,1,1, QtCore.Qt.AlignLeft)
        
        self.verticalLayout.addWidget(self.splitter)       
        
        self.centerLine = False

    def buttonClicked(self):
        self.centerLine = True
    
    def comboSelected(self):
        index = self.comboBox.currentIndex()
        return index 

    def normSelected(self):
        index = self.comboBoxNorm.currentIndex()
        #self.parent.tabChange()
        return index

    def updateCanvas(self, value, started, _command):
        self.canvas2Axes.clear()
        self.canvas3.ax.clear()
        self.canvas4.ax.clear()
        if _command in ('configure', 'stop', 'abort'):
            self.canvas1.ax.clear()
        else:
            if not started:
                pass
            else:
                color2D = 'r'
                color3D = 'hot'
                try:
                    self.canvas1.ax.pcolormesh(value[0], value[1], value[2], cmap=color3D)
                    self.canvas1.x1.set_xdata([[0,0],[100,100]])#value[7],value[7]])
                    self.canvas1.y1.set_ydata([[0,0],[10,20]])#value[7],value[7]])
                    self.canvas1.ax.axis('equal', adjustable='box')
                except:
                    pass
                try:
                    if self.centerLine:
                        self.canvas1.x1 = self.canvas1.ax.axhline(value[10][0],color='white')
                        self.canvas1.y1 = self.canvas1.ax.axvline(value[10][1],color='white')
                        if self.centerLine:
                            self.centerLine = False
                        self.centerTextX.setText('x='+str(round(value[10][0],5)))
                        self.centerTextY.setText('y='+str(round(value[10][1],5)))
                        #self.canvas1.x1.set_xdata([[0,0],[100,100]])#value[7],value[7]])
                        #self.canvas1.y1.set_xdata([[0,0],[100,200]])#value[7],value[7]])
                except:
                    pass
                try: 
                    (_x, _y)=np.meshgrid(value[3],value[4])
                    self.canvas2Axes.plot_surface(_x, _y, value[5], cmap=cm.coolwarm,linewidth=0, antialiased=False)
                    self.canvas2Axes.axis('off')
                except:
                    pass
                try:
                    index = self.comboBox1.currentIndex()
                    self.canvas3.ax.plot(value[6], value[7], color='b')
                    if index == 0:
                        self.canvas3.ax.set_yscale('linear')
                    else:
                        self.canvas3.ax.set_yscale('log')
                except:
                    pass
                try:
                    index = self.comboBox2.currentIndex()
                    self.canvas4.ax.plot(value[8], value[9], color='g')
                    if index == 0:
                        self.canvas4.ax.set_yscale('linear')
                    else:
                        self.canvas4.ax.set_yscale('log')
                except:
                    pass
                #self.canvas1.ax.relim()
                #self.canvas1.ax.autoscale_view(True, True, True)
                self.canvas1.draw()
                self.canvas2.draw()
                self.canvas3.draw()
                self.canvas4.draw()
