#!/usr/bin/python
# -*- coding: utf-8 -*-

import json
import time
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg
from matplotlib.figure import Figure
from redis.sentinel import Sentinel

from conf.constants import *
from model import neonReceiver
from viewer import canvas

class CSNSUserInfo(QtGui.QWidget):

    def __init__(self, parent=None):
        super(CSNSUserInfo, self).__init__(parent)
        self.setupUi(self)

        self.parent = parent
        self.controlThread = None

    def setupUi(self, QWidget):
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreafirst = QtGui.QScrollArea()
        self.scrollAreafirst.setWidgetResizable(True)
        self.scrollAreafirst.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreasecond = QtGui.QScrollArea()
        self.scrollAreasecond.setWidgetResizable(True)
        self.scrollAreasecond.setWidget(self.second)

        self.timeF = QtGui.QFrame(self)
        self.timeF.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaTime = QtGui.QScrollArea()
        self.scrollAreaTime.setWidgetResizable(True)
        self.scrollAreaTime.setWidget(self.timeF)

        self.envirF = QtGui.QFrame(self)
        self.envirF.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaEnvir = QtGui.QScrollArea()
        self.scrollAreaEnvir.setWidgetResizable(True)
        self.scrollAreaEnvir.setWidget(self.envirF)

        self.third = QtGui.QFrame(self)
        self.third.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreathird = QtGui.QScrollArea()
        self.scrollAreathird.setWidgetResizable(True)
        self.scrollAreathird.setWidget(self.third)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollAreafirst)
        self.splitter.addWidget(self.scrollAreasecond)
        self.splitter.addWidget(self.scrollAreaTime)
        self.splitter.addWidget(self.scrollAreaEnvir)
        self.splitter.addWidget(self.scrollAreathird)
        self.splitter.setSizes([100, 160, 100, 30, 320])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
        self.timeGrid = QtGui.QGridLayout(self.timeF)
        self.envirGrid = QtGui.QGridLayout(self.envirF)
        self.thirdGrid = QtGui.QGridLayout(self.third)

        # main verticalLayout

        self.SANSLabel = QtGui.QLabel('<font size=20 color=red>SANS </font><font size=1 color=black>20190328</font>')
        self.SANSLabel.setFont(QtGui.QFont('Roman times', 15, QtGui.QFont.Bold))
        self.spectLabel = \
            QtGui.QLabel('<font color=black>Instrument Scientist: Juzhou Tao</font>'
                         )
        self.developLabel = \
            QtGui.QLabel('<font size=2 color=black>Software Engineer: Lili Yan(347)</font>'
                         )

        self.verticalLayout.addWidget(self.SANSLabel)
        self.verticalLayout.addWidget(self.spectLabel)
        self.verticalLayout.addWidget(self.developLabel)
        self.verticalLayout.addWidget(self.splitter)

        # first Grid

        self.userIDLabel = QtGui.QLabel('UserID: ', self.first)
        self.userIDText = QtGui.QLabel('--------', self.first)

        self.runNoLabel = QtGui.QLabel('RunNo: ', self.first)
        self.runNoText = QtGui.QLabel('--------', self.first)

        self.proposalLabel = QtGui.QLabel('ProposalID: ', self.first)
        self.proposalText = QtGui.QLabel('--------', self.first)

        _nline = 0
        self.firstGrid.addWidget(self.userIDLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.userIDText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline += 1
        self.firstGrid.addWidget(self.runNoLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.runNoText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft,)

        _nline += 1
        self.firstGrid.addWidget(self.proposalLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.proposalText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        # second Grid

        self.neonLabel = QtGui.QLabel('NEON:', self.second)
        self.neonConnectLabel = QtGui.QLabel('', self.second)
        self.neonConnectLabel.setFixedSize(QtCore.QSize(80, 30))

        self.commandLabel = QtGui.QLabel('Command: ', self.second)

        self.commandTimeLabel = QtGui.QLabel('', self.second)
        self.commandValueLabel = QtGui.QLabel('', self.second)
        self.commandValueLabel.setStyleSheet('color:green')

        self.statusLabel = QtGui.QLabel('State: ', self.second)
        self.statusTimeLabel = QtGui.QLabel('', self.second)
        if len(sys.argv) == 1:
            self.statusValueLabel = QtGui.QLabel('None', self.second)
        else:
            self.statusValueLabel = QtGui.QLabel('Read only', self.second)
        self.statusValueLabel.setStyleSheet('color:blue')

        _nline = 0
        self.secondGrid.addWidget(self.neonLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.neonConnectLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)

        _nline += 1
        self.secondGrid.addWidget(self.commandLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.commandValueLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)

        _nline += 1
        self.secondGrid.addWidget(self.commandTimeLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)

        _nline += 1
        self.secondGrid.addWidget(self.statusLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.statusValueLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)

        _nline += 1
        self.secondGrid.addWidget(self.statusTimeLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)

        # time Grid

        with plt.xkcd():
            self.runCanvas = canvas.xkcdFigure(self)

        self.currentTimeLabel = \
            QtGui.QLabel('<font color=red>Current Time:</font>')
        self.currentTimeText = QtGui.QLabel('------')
        self.currentTimeText.setStyleSheet('color:red')
        self.currentTimer = QtCore.QTimer(self)
        self.labelConstant = True
        self.currentTimer.timeout.connect(self.changeTime)
        self.currentTimer.start(1000)

        self.startTimeLabel = \
            QtGui.QLabel('<font color=red>Start Time:</font>')
        self.startTimeText = QtGui.QLabel('------')
        self.startTimeText.setStyleSheet('color:red')
        self.endTimeLabel = \
            QtGui.QLabel('<font color=red>End Time:</font>')
        self.endTimeText = QtGui.QLabel('------')
        self.endTimeText.setStyleSheet('color:red')
        
        _nline = 0
        self.timeGrid.addWidget(self.currentTimeLabel,_nline,0,1,1)
        self.timeGrid.addWidget(self.currentTimeText,_nline,1,1,1)

        _nline += 1
        self.timeGrid.addWidget(self.startTimeLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.timeGrid.addWidget(self.startTimeText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline += 1
        self.timeGrid.addWidget(self.endTimeLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.timeGrid.addWidget(self.endTimeText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)
        
        '''
        self.separator = QtGui.QFrame(self)
        self.separator.setFixedHeight(1)
        self.separator.setFixedWidth(self.proposalLabel.geometry().width()
                + self.commandTimeLabel.geometry().width())
        self.separator.setStyleSheet('background-color:black')
        self.separator.setFrameShape(QtGui.QFrame.HLine)
        '''
        
        # environment Grid
        self.tempLabel = QtGui.QLabel('Temperature:')
        self.tempText = QtGui.QLabel('------')

        _nline = 0
        self.envirGrid.addWidget(self.tempLabel,_nline,0,1,1)
        self.envirGrid.addWidget(self.tempText, _nline,1,1,1)

        # third Grid
        self.protonLabel = QtGui.QLabel('Proton Charge: ')
        self.protonText = QtGui.QLabel('-----')

        self.detectorLabel = QtGui.QLabel('Detector Counts: ')
        self.detectorText = QtGui.QLabel('------')
        self.detectorRateLabel = QtGui.QLabel('    Counting Rates: ')
        self.detectorRateText = QtGui.QLabel('------')
        self.monitorLabel = QtGui.QLabel('Monitor Counts: ')
        self.monitorText = QtGui.QLabel('------')
        self.monitorRateLabel = QtGui.QLabel('     Counting Rates: ')
        self.monitorRateText = QtGui.QLabel('------')

        '''
        _nline += 1
        self.thirdGrid.addWidget(
            self.separator,
            _nline,
            0,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        '''
        _nline = 0
        self.thirdGrid.addWidget(
            self.protonLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.protonText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.detectorLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.detectorText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.detectorRateLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.detectorRateText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.monitorLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.monitorText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.monitorRateLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.monitorRateText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.runCanvas,
            _nline,
            0,
            1,
            2,
            QtCore.Qt.AlignCenter,
            )

        # self.thirdGrid.addItem(QtGui.QSpacerItem(-1, -1,
        #                       QtGui.QSizePolicy.Ignored,
        #                       QtGui.QSizePolicy.Expanding), 2, 0)

        

        self.dataThread = False
        self.pix = None
       
    def changeTime(self):
        timenow = time.strftime('%Y-%m-%d %H:%M:%S')
        self.currentTimeText.setText(timenow)

    def setNeonStatus(self, value):
        if value:
            self.neonConnectLabel.setText('connected')
        else:
            self.neonConnectLabel.setText('disconnected')

    def getIP_PORT(self):
        _ip = '10.1.34.116'
        _ip_port = [(_ip, 9001), (_ip, 9011)]
        return _ip_port

    def getNeon(self):
        status = False
        writeServer = None
        readServer = None

        _timeout = 10
        _ip_port = self.getIP_PORT()
        _passwd = 'sanlie;123'
        _r = neonReceiver.connectNeon(_ip_port, _passwd, _timeout)
        status = _r.getStatus()
        writeServer = _r.getRedisWrite()
        readServer = _r.getRedisRead()

        return (status, writeServer, readServer)

    def setUserInfo(self, value):
        #_value = json.loads(value)
        self.userIDText.setText(str(value['userID']))
        self.runNoText.setText(str(value['runNo']))
        self.proposalText.setText(str(value['proposalID']))

    # get from neon

    def setCommandLabel(self, value):
        _timen = str(time.strftime('%Y-%m-%d  %H:%M:%S'))
        self.setCommandTimeLabel(_timen)
        self.setCommandValueLabel(value)

    def setCommandTimeLabel(self, time):
        self.commandTimeLabel.setText(time)

    def setCommandValueLabel(self, value):
        self.commandValueLabel.setText(value)

    # get from neon

    def setStatusLabel(self, value):
        myStatus = self.statusValueLabel.text()
        _timen = str(time.strftime('%Y-%m-%d  %H:%M:%S'))
        if myStatus != value:
            self.setStatusTimeLabel(_timen)
            self.setStatusValueLabel(value)
            logging.info(str('status is ' + value + ' now'))

    def setStatusTimeLabel(self, time):
        self.statusTimeLabel.setText(time)

    def setStatusValueLabel(self, value):
        if len(sys.argv) == 1:        
            self.statusValueLabel.setText(value)
        else:
            pass

    def setProtonNeutron(self, _proton, _detector, _detectorRate, _monitor, _monitorRate):
        try:
            self.protonText.setText(str(_proton))
            self.detectorText.setText(str(_detector))
            self.detectorRateText.setText(str(_detectorRate))
            self.monitorText.setText(str(_monitor))
            self.monitorRateText.setText(str(_monitorRate))
        except:
            self.protonText.setText('------')
            self.detectorText.setText('------')
            self.detectorRateText.setText('------')
            self.monitorText.setText('------')
            self.monitorRateText.setText('------')

    def setStartEndTime(self, _start, _end):
        try:
            self.startTimeText.setText(str(_start))
            self.endTimeText.setText(str(_end))
        except:
            self.startTimeText.setText('------')
            self.endTimeText.setText('------')

    def setTemp(self, _temp):
        try:
            self.tempText.setText(str(_temp))
        except:
            self.tempText.setText('-----')

    def clearCanvas(self):
        self.runCanvas.ax.clear()
        self.runCanvas.draw()

    def updateMonitorCanvas(
        self,
        xdata,
        ydata,
        started,
        _command,
        ):
        try:
            #if _command in ('configure', 'abort'):
            #    self.pix = None
            #elif not started:
            #    pass
            #else:
            if str(xdata) == 'clear' or str(ydata) == 'clear':
                self.runCanvas.ax.clear()
                self.runCanvas.draw()
            elif len(xdata) != len(ydata) or len(ydata) == 0:
                pass
            else:
                #if not self.pix:
                self.runCanvas.ax.clear()
                (self.pix, ) = self.runCanvas.ax.plot(xdata, ydata,
                        color='g')
                #else:
                #    self.pix.set_ydata(ydata)
                self.runCanvas.ax.relim()
                self.runCanvas.ax.autoscale_view()
                self.runCanvas.draw()
                #self.runCanvas.flush_events()
        except:
            pass
