#!/usr/bin/python
# -*- coding: utf-8 -*-

# main

'''
Created on 2015.9.25
'''

# warning filter for python
import warnings
with warnings.catch_warnings():
    #warnings.filterwarnings("ignore")
    warnings.filterwarnings("ignore", category=UserWarning)
    warnings.filterwarnings("ignore", category=DeprecationWarning)
#import the_module_that_warns

# constants and import model file
from conf.constants import *

# decoder and encoder from json file 
import json
from json import *

# for save configure when exit
import atexit

# for transfer data
import redis

# viewer defined

# for user info at left window
from viewer.user import *

# for menuBar at top window
from viewer.menuBar import *

# for statusBar at bottom window
from viewer.statusBar import *

# for tab page at right up window
from viewer.mainSet import *

# for log info at right bottom window
from viewer import logWindow

# model defined

# for command/heartBeat and data
from model import neonReceiver
from model import jsonArray

# main window class
# The top app
class mywindow(QtGui.QMainWindow):

    def __init__(self, parent):
        super(mywindow, self).__init__()
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, MainWindow):

        # creat menubar
        #self.myMenuBar = menuBar(self)

        # set menubar to main window
        #self.setMenuBar(self.myMenuBar)

        # creat statusbar
        self.myStatusBar = statusBar(self)

        # set statusbar to main window
        self.setStatusBar(self.myStatusBar)

        # seperate left and right for main window
        self.mainSplitter = QtGui.QSplitter(QtCore.Qt.Horizontal, self)

        # creat user information model 
        self.userWidget = CSNSUserInfo(self)

        # creat tab page and log window
        self.mainSetWidget = CSNSMainSetInfo(self)

        # add user panel to main window
        self.mainSplitter.addWidget(self.userWidget)

        # add main panel to main window
        self.mainSplitter.addWidget(self.mainSetWidget)

        # neon server status
        self.neonStatus = None
        # write neon server 
        self.writeServer = None
        # read neon server
        self.readServer = None
        # my app's initial state 
        self.myStatus = 'waiting'
        # show info in log window
        logging.info('Status is waiting')

        # initial ip and port
        self.ip_port = ''
        # the size for user panel
        self.mainSplitterLeft = 100
        # the size for main set panel
        self.mainSplitterRight = 900
        # initial command constant
        self.myCommand = None
        # all command list
        self.commandList = [
            'configure',
            'unconfigure',
            'start',
            'pause',
            'resume',
            'stop',
            'abort',
            ]
        # all state list
        self.statusList = [
            'waiting',
            'unconfigured',
            'configuring',
            'ready',
            'running',
            'paused',
            'error',
            ]
        # initial data thread constant
        self.dataThread = None

        # it is true when running
        self.started = True

        # data update time

        self.refreshtime = 1.0

        # progress value

        self.progressName = ''
        self.progressValue = 0
        self.protonValue = 0
        self.neutronValue = 0
        self.pulseValue = 0

        self.runNo = None
        self.userInfo = None

        # set central window
        self.setCentralWidget(self.mainSplitter)

        # load setting from json file
        self.loadConfigure()
        # set configure when the app exit
        self.setConfigure()
    
        # init stetus show at user panel
        self.userWidget.setStatusLabel(self.myStatus)

        # creat heartbeat/data/command thread
        self.createThread()

    # update canvas data from diffraction simulator data
    # for test
    def updateDiffractionSimulator(self):
        self.upRightTab.updateDiffractionSimulator()

    # update canvas data from data streaming 
    # for test
    def updateDataStreaming(self):
        self.upRightTab.updateDataStreaming()

    # update proton data
    # for test
    def updateProton(self, threadID):
        self.upRightTab.updateProton(threadID)

    # get desktop size
    def getDisplay(self):
        screen_resolution = self.parent.desktop().screenGeometry()
        return (screen_resolution.width(), screen_resolution.height())

    # load initial configure
    def loadConfigure(self):
        # save initial configure json file
        _confFile = './conf/configure.json'
        (_mainWidth, _mainHeight) = self.getDisplay()

        if not os.path.exists(_confFile):
            self.mainWidth = _mainWidth
            self.mainHeight = _mainHeight
            self.ip_port = self.userWidget.getIP_PORT()
            # get main splitter size
            self.mainSplitterLeft = (self.mainWidth + 50) / 11.0
            self.mainSplitterRight = self.mainWidth / 11.0 * 10
        else:
            try:
                # get initial configure from json file
                layoutParameter = json.loads(open(_confFile, 'r'
                        ).read())
                self.mainWidth = layoutParameter['mainWidth']
                self.mainHeight = layoutParameter['mainHeight']
                self.ip_port = layoutParameter['ip_port']
                self.mainSplitterLeft = \
                    layoutParameter['mainSplitterLeft']
                self.mainSplitterRight = \
                    layoutParameter['mainSplitterRight']
            except:
                self.mainWidth = _mainWidth
                self.mainHeight = _mainHeight
                _ip = '10.1.34.116'
                self.ip_port = [(ip, 9001), (ip, 9011), (ip, 9021)]

    # set initial configure
    def setConfigure(self):
        self.resize(self.mainWidth, self.mainHeight)
        self.mainSplitter.setSizes([self.mainSplitterLeft,
                                   self.mainSplitterRight])

    # save configure when exit the app
    def saveConfigure(self):
        _mainWidth = self.mainSplitter.geometry().width()
        _mainHeight = self.mainSplitter.geometry().height()
        _ip_port = self.userWidget.getIP_PORT()
        _mainSplitterLeft = self.mainSplitter.sizes()[0]
        _mainSplitterRight = self.mainSplitter.sizes()[1]

        _data = {
            'mainWidth': _mainWidth,
            'mainHeight': _mainHeight,
            'mainSplitterLeft': _mainSplitterLeft,
            'mainSplitterRight': _mainSplitterRight,
            'ip_port': _ip_port,
            }

        _confFile = './conf/configure.json'
        if not os.path.exists(_confFile):
            with open(_confFile, 'w') as _f:
                json.dump(_data, _f)
        else:
            with open(_confFile, 'w') as _f:
                json.dump(_data, _f)

    # set connected neon status at user info
    def setNeonStatus(self, value):
        self.userWidget.setNeonStatus(value)

    # connect to redis
    def getNeon(self):
        (self.neonStatus, self.writeServer, self.readServer) = \
            self.userWidget.getNeon()
        return (self.neonStatus, self.writeServer, self.readServer)

    # get the number of myStatus
    def getStatus(self):
        return self.statusList.index(self.myStatus)

    # create the heartBeat Thread
    def setHeartBeat(self):
        # set the heartbeat path
        if len(sys.argv) == 1:
            neonpath = '/SANS/heartbeat/pilot2'
        else:
            neonpath = '/SANS/heartbeat/pilot1'
            
        # create log info
        logging.info('Creating heartbeat thread')
        # create the heartbeat thread
        self.heartbeatThread = neonReceiver.setHeartbeat(self,
                self.writeServer, 1.0, neonpath, self.getStatus())
        self.heartbeatThread.setDaemon(True)

    # get the top parent
    def getApp(self):
        return self.parent

    # create the command thread
    def getCommand(self, parent, gui):
        # create log info
        logging.info('Creating Command Thread...')
        # get command from the path
        commandPath = '/SANS/control/command/pilot1'
        # create the command thread
        self.commandThread = neonReceiver.commandThread(parent, gui,
                self.readServer, commandPath, 1.0)

    # set myCommand slot
    @QtCore.pyqtSlot(str)
    def setCommand(self, value):
        try:
            # load the command from redis
            value = json.loads(value)
            # get the number of the command from commandList
            _command = self.commandList[int(value)]
            # trigger below function if the command different
            if self.myCommand != _command:
                logging.info(str('Received command: ' + _command))

                # start stateMachine

                self.stateMachine(_command)
                self.userWidget.setCommandLabel(_command)

                self.myCommand = _command
                print self.myCommand
 
                # set receive command to wechat
                path = '/SANS/wechat/command'
                if self.writeServer == None:
                    (neonStatus, self.writeServer) = self.getNeon()
                _command_json = jsonArray.jsonEncoder(self.myCommand)
                self.writeServer.set(path, _command_json)
        except:
            pass

    @QtCore.pyqtSlot(str)
    def setLog(self, value):
        logging.debug(value)

    def getCanvasData(self, parent, gui):
        logging.info('Creating Canvas data Thread...')

        progressPath = '/SANS/cockpit/progress'

        protonPath = '/SANS/drone/proton_charge'
        detectorPath = '/SANS/drone/detector_counts'
        detectorRatePath = '/SANS/drone/detector_rates'
        monitorPath = '/SANS/drone/monitor_counts'
        monitorRatePath = '/SANS/drone/monitor_rates'
        pulsePath = '/SANS/drone/pulse_counts'
        startPath = '/SANS/drone/startTime'
        endPath = '/SANS/drone/endTime'
        tempPath='/SANS/drone/temperature'

        self.dataThread = neonReceiver.dataThread(
            parent,
            gui,
            self.readServer,
            progressPath,
            protonPath,
            detectorPath,
            detectorRatePath, 
            monitorPath, 
            monitorRatePath,
            pulsePath,
            startPath,
            endPath,
            tempPath,
            self.refreshtime,
            )

    def setDataPath(self, kwargs):
        if not self.dataThread:
            logging.info('No data availabel')
        else:
            self.dataThread.setDataPath(kwargs)

    def getDetectorIndex(self):
        return self.mainSetWidget.upRightTab.detectorPage.getDetectorIndex()

    @QtCore.pyqtSlot(object)
    def setCanvasData(self, value):
        tabIndex = self.dataThread.getTabIndex()
        _started = self.started
        _command = self.myCommand
        if tabIndex == 0:
            self.mainSetWidget.upRightTab.scatteringPage.updateCanvas(value,
                    _started, _command)
        elif tabIndex == 1:
            self.mainSetWidget.upRightTab.tubePage.updateCanvas(value,
                    _started, _command)
        elif tabIndex == 2:
            self.mainSetWidget.upRightTab.detectorPage.updateCanvas(value,
                    _started, _command)
        elif tabIndex == 3:
            self.mainSetWidget.upRightTab.transmissionPage.updateCanvas(value,
                    _started, _command)
        elif tabIndex == 4:
            self.mainSetWidget.upRightTab.monitorPage.updateCanvas(value,
                    _started, _command)
        elif tabIndex == 5:
            self.mainSetWidget.upRightTab.experimentPage.updateCanvas(value,
                    _started, _command)

    @QtCore.pyqtSlot(object)
    def setMonitorCanvas(self, value):
        xdata = self.dataThread.getMonitorTOFData()
        #xdata = self.dataThread.getMonitorTOF()
        self.userWidget.updateMonitorCanvas(xdata, value, self.started,
                self.myCommand)

    @QtCore.pyqtSlot(object, object, object, object, object)
    def setUserData(self, _proton, _detector, _detectorRate, _monitor, _monitorRate):
        try:
            self.userWidget.setProtonNeutron(_proton, _detector, _detectorRate, _monitor, _monitorRate)
            if _proton != None:
                self.protonValue = int(_proton)
            if _detector != None:
                self.neutronValue = int(_detector)
        except:

            # self.pulseValue = int(_pulse)

            pass

    @QtCore.pyqtSlot(object, object)
    def setUserTime(self, _start, _end):
        try:
            self.userWidget.setStartEndTime(_start, _end)
        except:
            pass

    @QtCore.pyqtSlot(object)
    def setUserTemp(self, _temp):
        try:
            self.userWidget.setTemp(_temp)
        except:
            pass

    @QtCore.pyqtSlot(str)
    def setProgressData(self, value):
        self.progressValue = json.loads(str(value))

    # set max and min value for progressBar
    def setProgressBar(self, mini, maxi):
        self.mainSetWidget.createProgressBar(mini, maxi)

    # get current value for progressBar

    def getProgressValue(self):
        return self.progressValue

    def getUserInfo(self):
        try:
            userPath = '/SANS/control/configure'
            (_neonStatus, _writeServer, _readServer) = self.getNeon()
            if _neonStatus:

                # get json date after json.dumps from neon

                _userInfo = _readServer.get(userPath)
                if _userInfo is None:
                    logging.info('Empty User Information Data!')
                else:
                    self.userInfo = _userInfo
                    _userInfo=json.loads(_userInfo)
                    self.userWidget.setUserInfo(_userInfo)
                    self.setWechatConf()

                    _progressMin = float(_userInfo['progressMin'])
                    _progressMax = float(_userInfo['progressMax'])
                    self.setProgressBar(_progressMin, _progressMax)
        except:
            pass

    def setWechatConf(self):
        # set run no to wechat
        path = '/SANS/wechat/configure'
        if self.writeServer == None:
            (neonStatus, self.writeServer) = self.getNeon()
        #_userInfo = self.userInfo
        #_userInfo_json = jsonArray.jsonEncoder(self.userInfo)
        self.writeServer.set(path, self.userInfo)

    def saveScreen(self):
        try:
            import pyscreenshot as ImageGrab
        except:
            pass
        #_cmd = "mkdir -p " + path
        #subprocess.check_output(_cmd, shell=True)

        im=ImageGrab.grab()
        im.save('sans.jpg', format="jpeg")
        _cmd = "mv sans.jpg ./history/RUN"+str(self.runNo).zfill(7)+".jpg"
        subprocess.Popen(_cmd, shell=True)
        _cmd = "scp ./history/RUN"+str(self.runNo).zfill(7)+".jpg tangm@202.38.129.18:/home/tangm/instrument/BL01/history"
        subprocess.Popen(_cmd, shell=True)
        #_cmd = "mv pattern.jpg " + path
        #subprocess.Popen(_cmd, shell=True) 

    def createThread(self):
        # connect neon
        (_neonStatus, _writeServer, _readServer) = self.getNeon()
        self.setNeonStatus(_neonStatus)
        if _neonStatus:
            # set heartbeat
            self.setHeartBeat()
            # get command
            self.getCommand(self.parent, self)
            # get canvas data
            self.getCanvasData(self.parent, self)
            self.myStatus = 'unconfigured'
            logging.info('Status change to unconfigured')
            self.userWidget.setStatusLabel(self.myStatus)

    def startThread(self):
        self.heartbeatThread.start()
        logging.info('Start heartbeat successfully')
        self.commandThread.start()
        logging.info('Start Command Thread successfully')
    
    def clearCanvas(self):
        self.mainSetWidget.clearCanvas()
        self.userWidget.clearCanvas()

    def setIndex(self,index):
        self.mainSetWidget.setIndex(index)

    def stateMachine(self, command):
        _command = command
        _index = self.getStatus()
        _status = self.statusList[_index]
        try:
            if _command == 'configure':
                if _status == 'unconfigured':
                    _status = 'configuring'
                    logging.info('status change to configuring')
                    self.getUserInfo()
                    _status = 'ready'
                    logging.info('status change to ready')
                elif _status == 'ready':
                    logging.info('ready now')
                else:
                    # waiting/configuring/running/paused
                    logging.info(_status
                                 + ' status cannot receive abort command'
                                 )
            elif _command == 'unconfigure':
                if _status == 'unconfigured':
                    logging.info('unconfigured now')
                elif _status == 'ready':
                    self.started = False
                    # self.dataThread.pause()
                    _status = 'unconfigured'
                    logging.info('status change to unconfigured')
                else:
                    # waiting/configuring/running/paused
                    logging.info(_status
                                 + ' status cannot receive abort command'
                                 )
            elif _command == 'start':
                if len(sys.argv) == 1:
                    if _status == 'ready':
                        # clear canvas
                        self.clearCanvas()
                        # start get data from neon
                        self.started = True
                        self.dataThread.start()
                        logging.info('Start Canvas Data Thread successfully'
                                     )

                        # set canvas data path
                        self.mainSetWidget.upRightTab.tabChange()
                        _status = 'running'
                        logging.info('status change to running')
                    elif _status == 'running':
                        logging.info('running now')
                    else:

                         # waiting/unconfigured/configuring/paused

                        logging.info(_status
                                     + ' status cannot receive abort command'
                                     )
                else:
                    if _status != 'ready':
                        _status = 'configuring'
                        logging.info("status change to configuring")
                        self.getUserInfo()
                        _status = 'ready'
                        logging.info("status change to ready")

                    #clear canvas
                    self.clearCanvas()
                    # start get data from neon
                    self.started = True
                    self.dataThread.start()
                    logging.info("Start Canvas Data Thread successfully")
                    # set canvas data path
                    self.mainSetWidget.upRightTab.tabChange()

                    self.userWidget.startTime=time.time()
                    _status = 'running'
                    logging.info("status change to running")
            elif _command == 'pause':
                if _status == 'running':

                    # pause get date from neon

                    self.dataThread.pause()
                    _status = 'paused'
                    logging.info('status change to paused')
                else:

                     # waiting/unconfigured/configuring/ready/paused

                    logging.info(_status
                                 + ' status cannot receive abort command'
                                 )
            elif _command == 'resume':
                if _status == 'paused':
                    self.dataThread.resume()
                    _status = 'running'
                    logging.info('status change to runninig')
                else:

                     # waiting/unconfigured/configuring/ready/running

                    logging.info(_status
                                 + ' status cannot receive abort command'
                                 )
            elif _command == 'stop':
                if _status == 'ready':
                    logging.info('ready now')
                elif _status == 'running':
                    #self.setIndex(0)
                    #self.mainSetWidget.upRightTab.setCurrentIndex(0)

                    self.started = False

                    # time.sleep(self.refreshtime)
                    # self.dataThread.pause()

                    _status = 'ready'
                    logging.info('status change to ready')
                else:

                     # waiting/unconfigured/configuring/paused

                    logging.info(_status
                                 + ' status cannot receive abort command'
                                 )
            elif _command == 'abort':
                _status = 'unconfigured'
                logging.info('status change to unconfigured')

            self.userWidget.setStatusLabel(_status)
            self.myStatus = _status
            #_index = self.mainSetWidget.upRightTab.currentIndex()
            #if _index == 0 and _command == 'stop' and self.myStatus == 'ready':
            #   self.saveScreen()
        except:
            pass


def exit_handler(top):
    top.saveConfigure()


if __name__ == '__main__':

    myapp = QtGui.QApplication(sys.argv)

    mytop = mywindow(myapp)
    icon = QtGui.QIcon('img/logo.jpg')
    mytop.setWindowIcon(icon)
    mytop.setWindowTitle('SANS')
    mytop.show()
    time.sleep(0.1)
    mytop.startThread()

    atexit.register(exit_handler, mytop)
    sys.exit(myapp.exec_())
