#!/usr/bin/python
# -*- coding: utf-8 -*-
'''
Created on 2015.6.2
@author: yll
'''

from conf.constants import *

# user defined
# from model.readData import *
# from model.slitModel import *
# from presenter.slitSignal import *

from viewer.canvas import *


class CSNSDetectorPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.setupUi(self)
        self.parent = parent

    def setupUi(self, Widget):
        self.horizontalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        # for main  grid

        self.mainGrid = QtGui.QGridLayout(self.first)

        self.comboBoxWave = QtGui.QComboBox()
        self.comboBoxWave.addItem('2(AA)')
        self.comboBoxWave.addItem('3(AA)')
        self.comboBoxWave.addItem('4(AA)')
        self.comboBoxWave.addItem('5(AA)')
        self.comboBoxWave.addItem('6(AA)')
        self.comboBoxWave.addItem('7(AA)')
        self.comboBoxWave.addItem('8(AA)')
        self.comboBoxWave.setMinimumWidth(100)
        self.comboBoxWave.activated.connect(self.comboWaveChange)

        _width = 3.5
        self.canvas1 = figureCanvas(  # self.plotColor,
                                         # self.title,
            self,
            _width,
            _width,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'qx (A-1)',
            'qy (A-1)',
            )
        self.canvas1.ax.set_aspect('equal')

        self.canvas1.x1 = self.canvas1.ax.axhline(0, color='gray'
                , zorder=2)
        self.canvas1.y1 = self.canvas1.ax.axvline(0, color='gray'
                , zorder=2)
        self.canvas1.draw()
        self.mouseClickedEvents()

        # canvas for y

        self.canvas3 = zoomCanvas(  # self.plotColor,
                                     # self.title,
            self,
            _width,
            1,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'Qx',
            'Neutron Counts',
            )
        self.canvas3.setMinimumHeight(50)

        # canvas for x

        self.canvas2 = zoomCanvas(  # self.plotColor,
                                       # self.title,
            self,
            1,
            _width,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'Qy',
            'Neutron Counts',
            )
        self.canvas2.setMinimumWidth(50)

        # self.sliderX=QtGui.QSlider(QtCore.Qt.Vertical)

        _nline = 0
        self.mainGrid.addWidget(self.canvas3, 0, 0, 1, 2,QtCore.Qt.AlignCenter)
        self.mainGrid.addWidget(self.comboBoxWave, 0, 2, 1, 1,QtCore.Qt.AlignLeft)
        _nline += 1
        self.mainGrid.addWidget(
            self.canvas2,
            1,
            2,
            3,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.canvas1, 1, 0, 1, 2,QtCore.Qt.AlignVCenter)

        # self.mainGrid.addWidget(self.sliderX,_nline,2,1,1, QtCore.Qt.AlignLeft)
        # _nline += 1
        # self.mainGrid.addWidget(self.sliderY,_nline,1,1,1, QtCore.Qt.AlignTop)

        self.mainGrid.columnStretch(1)

        self.horizontalLayout.addWidget(self.scrollArea)

        self.value = None
        self.xdata = 0
        self.ydata = 0
        self.mouseClicked = False

        self.pix1 = None
        self.pix2 = None
        self.pix3 = None

    def comboWaveChange(self):
        self.pix3 = None
        self.canvas3.zoomSelected = False
        self.parent.tabChange()

    def waveSelected(self):
        index = self.comboBoxWave.currentIndex()
        return index

    def mouseClickedEvents(self):
        self.canvas1.mpl_connect('button_press_event',
                                    self.changeRegion)

        # self.slitImageCanvas.mpl_connect('motion_notify_event', self.changeRegion)
        # self.slitImageCanvas.mpl_connect('button_release_event', self.changeXYFigure)

        self.canvas1.mpl_connect('button_press_event',
                                    self.changeXYFigure)

    def changeRegion(self, event):
        try:
            self.xdata = event.xdata
            self.ydata = event.ydata
            _canvas = self.canvas1
            _canvas.ax.clear()
            _canvas.ax.contourf(self.value[0], self.value[1],
                                self.value[2], cmap='hot', zorder=1)
            (_xdata, _ydata, _xindex, _yindex) = \
                self.getXYData(event.xdata, event.ydata, self.value)
            if event.button == 1:

                # _canvas.x1.set_xdata([event.ydata,event.ydata])
                # _canvas.y1.set_ydata([event.xdata,event.xdata])

                _canvas.x1 = _canvas.ax.axhline(event.ydata, color='gray',
                        zorder=2)
                _canvas.y1 = _canvas.ax.axvline(event.xdata, color='gray',
                        zorder=2)
            elif event.button == 3:

                # _canvas.x1.set_xdata([event.ydata,event.ydata])
                # _canvas.y1.set_ydata([event.xdata,event.xdata])

                _canvas.x1 = _canvas.ax.axhline(event.ydata, color='gray',
                        zorder=2)
                _canvas.y1 = _canvas.ax.axvline(event.xdata, color='gray',
                        zorder=2)
            else:
                pass
            _canvas.draw()
        except:
            pass

    def changeXYFigure(self, event):
        color2D = 'r'
        try:
            (_datax, _datay) = self.getCountsData(self.value)
        except:
            pass
        if event.button == 1:
            self.mouseClicked = True
            try:
                self.canvas2.ax.clear()
                self.canvas2.ax.plot(_datax, self.value[1],
                        color=color2D)

                # self.canvas2.fig.set_xdata(_datax, color=color2D)

                self.canvas2.draw()
            except:
                pass
            try:
                self.canvas3.ax.clear()
                self.canvas3.ax.plot(self.value[0], _datay,
                        color=color2D)
                self.canvas3.draw()
            except:
                pass
        elif event.button == 3:
            self.mouseClicked = True
            try:
                self.canvas3.ax.clear()
                self.canvas3.ax.plot(self.value[0], _datay,
                        color=color2D)

                # self.canvas3.fig.set_ydata(_datay, color=color2D)

                self.canvas3.draw()
            except:
                pass
            try:
                self.canvas2.ax.clear()
                self.canvas2.ax.plot(_datax, self.value[1],
                        color=color2D)
                self.canvas2.draw()
            except:
                pass

    def getXYData(
        self,
        xdata,
        ydata,
        value,
        ):
        _xdata = 0
        _ydata = 0
        xlist = []
        ylist = []
        _minx = 0
        _miny = 0
        xindex = 0
        yindex = 0

        for i in range(len(value[0])):
            xlist.append(abs(value[0][i] - xdata))
        _minx = min(xlist)
        xindex = xlist.index(_minx)
        _xdata = value[0][xindex]

        for i in range(len(value[1])):
            ylist.append(abs(value[1][i] - ydata))
        _miny = min(ylist)
        yindex = ylist.index(_miny)
        _ydata = value[1][yindex]

        # self.xEventData = _xdata
        # self.yEventData = _ydata

        return (_xdata, _ydata, xindex, yindex)

    def getCountsData(self, value):
        xcounts = []
        ycounts = []
        (_xdata, _ydata, xindex, yindex) = self.getXYData(self.xdata,
                self.ydata, self.value)
        ytmp = value[2][yindex]
        for j in ytmp:
            ycounts.append(j)

        for i in range(len(value[1])):
            xcounts.append(value[2][i][xindex])
        return (xcounts, ycounts)

    def clearCanvas(self):
        self.canvas1.ax.clear()
        self.canvas1.draw()
        self.canvas3.ax.clear()
        self.canvas3.draw()
        self.canvas2.ax.clear()
        self.canvas2.draw()

    def updateCanvas(
        self,
        value,
        started,
        _command,
        ):
        self.value = value
        if _command in ('configure', 'abort'):
            self.pix1 = None
            self.pix2 = None
            self.pix3 = None
        #elif not started:
        #    pass
        #else:
        color2D = 'r'
        color3D = 'hot'
        try:
            if str(value[2]) == 'clear':
                self.canvas1.ax.clear()
                self.canvas1.draw()
            elif len(value[2]) == 0:
                pass
            else:
                #if not self.pix1:
                self.canvas1.ax.clear()
                self.pix1 = \
                    self.canvas1.ax.contourf(value[0],
                        value[1], value[2], cmap=color3D,
                        zorder=1)
                self.canvas1.ax.set_xlabel('QX')
                self.canvas1.ax.set_ylabel('Qy')
                #else:
                #    self.pix1.set_array(np.array(value[2]).ravel())
                self.canvas1.x1 = \
                    self.canvas1.ax.axhline(self.ydata,
                        color='gray', zorder=2)
                self.canvas1.y1 = \
                    self.canvas1.ax.axvline(self.xdata,
                        color='gray', zorder=2)
                if self.canvas1.scale_factor != 1.0:
                    self.canvas1.ax.set_xlim([self.canvas1.xdata - self.canvas1.new_width * (1-self.canvas1.relx), self.canvas1.xdata + self.canvas1.new_width * (self.canvas1.relx)])
                    self.canvas1.ax.set_ylim([self.canvas1.ydata - self.canvas1.new_height * (1-self.canvas1.rely), self.canvas1.ydata + self.canvas1.new_height * (self.canvas1.rely)])
                else:
                    self.pix1 = None

                # self.canvas1.ax.relim()
                # self.canvas1.ax.autoscale_view(True, True, True)

                self.canvas1.draw()
        except:
            pass
            #self.pix1 = None
        try:
            if not self.mouseClicked:
                (_datax, _datay) = \
                    self.getCountsData(self.value)
                if str(self.value[1]) == 'clear' or str(_datax) == 'clear':
                    self.canvas2.ax.clear()
                    self.canvas2.draw()
                    pass
                elif len(self.value[1]) != len(_datax) \
                    or len(_datax) == 0:
                    pass
                else:
                    #if not self.pix2:
                    self.canvas2.ax.clear()
                    (self.pix2, ) = \
                        self.canvas2.ax.plot(_datax,
                            self.value[1], color=color2D)
                    self.canvas2.ax.add_patch(self.canvas2.rect)
                    self.canvas2.ax.set_xlabel('Neutron Counts'
                            )
                    self.canvas2.ax.set_ylabel('Qy')
                    #else:
                    #    self.pix2.set_xdata(_datax)
                    #    self.pix2.set_ydata(self.value[1])
                    if self.canvas2.zoomSelected \
                        and self.letfCanvas.minX \
                        != self.canvas2.maxX \
                        and self.canvas2.minY \
                        != self.canvas2.maxY:
                        self.canvas2.ax.set_xlim(self.canvas2.minX,
                                self.canvas2.maxX)
                        self.canvas2.ax.set_ylim(self.canvas2.minY,
                                self.canvas2.maxY)
                    elif self.canvas2.scale_factor != 1.0:
                        self.canvas2.ax.set_xlim([self.canvas2.xdata - self.canvas2.new_width * (1-self.canvas2.relx), self.canvas2.xdata + self.canvas2.new_width * (self.canvas2.relx)])
                        self.canvas2.ax.set_ylim([self.canvas2.ydata - self.canvas2.new_height * (1-self.canvas2.rely), self.canvas2.ydata + self.canvas2.new_height * (self.canvas2.rely)])
                    # self.canvas2.fig.set_xdata(_datax, color=color2D)

                    self.canvas2.ax.relim()
                    self.canvas2.ax.autoscale_view()
                    self.canvas2.draw()
        except:
            pass
            #self.pix2 = None
        try:
            if str(self.value[0]) == 'clear' or str(_datay) == 'clear':
                self.canvas3.ax.clear()
                self.canvas3.draw()
            elif len(self.value[0]) != len(_datay) or len(_datay) \
                == 0:
                pass
            else:
                #if not self.pix3:
                self.canvas3.ax.clear()
                (self.pix3, ) = \
                    self.canvas3.ax.plot(self.value[0],
                        _datay, color=color2D)
                self.canvas3.ax.add_patch(self.canvas3.rect)
                self.canvas3.ax.set_ylabel('Neutron Counts'
                        )
                self.canvas3.ax.set_xlabel('Qx')
                #else:
                #    self.pix3.set_xdata(self.value[0])
                #    self.pix3.set_ydata(_datay)
                if self.canvas3.zoomSelected \
                    and self.canvas3.minX \
                    != self.canvas3.maxX \
                    and self.canvas3.minY \
                    != self.canvas3.maxY:
                    self.canvas3.ax.set_xlim(self.canvas3.minX,
                            self.canvas3.maxX)
                    self.canvas3.ax.set_ylim(self.canvas3.minY,
                            self.canvas3.maxY)
                elif self.canvas3.scale_factor != 1.0:
                    self.canvas3.ax.set_xlim([self.canvas3.xdata - self.canvas3.new_width * (1-self.canvas3.relx), self.canvas3.xdata + self.canvas3.new_width * (self.canvas3.relx)])
                    self.canvas3.ax.set_ylim([self.canvas3.ydata - self.canvas3.new_height * (1-self.canvas3.rely), self.canvas3.ydata + self.canvas3.new_height * (self.canvas3.rely)])

                self.canvas3.ax.relim()
                self.canvas3.ax.autoscale_view()
                self.canvas3.draw()
        except:
            pass
            #self.pix3 = None
