#!/usr/bin/python
# -*- coding: utf-8 -*-
'''
Created on 2015.6.2
@author: yll
'''

from conf.constants import *

# user defined
# from model.readData import *
# from model.slitModel import *
# from presenter.slitSignal import *

from viewer.canvas import *


class CSNSTubePage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSTubePage, self).__init__(parent=None)
        self.setupUi(self)
        self.parent = parent

    def setupUi(self, Widget):
        self.horizontalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        # for main  grid

        self.mainGrid = QtGui.QGridLayout(self.first)

        self.tubeWidget = QtGui.QWidget(self.first)
        self.tubeWidget.setMaximumHeight(60)
        self.tubeGrid = QtGui.QGridLayout(self.tubeWidget)

        self.tubeSlider = QtGui.QSlider(QtCore.Qt.Horizontal)
        self.tubeSlider.setMinimumWidth(70)
        self.tubeSlider.setMinimum(1)
        self.tubeSlider.setMaximum(120)
        self.tubeSlider.setTickInterval(1)
        self.tubeSlider.setTickPosition(QtGui.QSlider.TicksBelow)
        self.tubeSlider.valueChanged.connect(self.valueChanged)
        self.tubeTextEdit = QtGui.QTextEdit('1')
        self.tubeTextEdit.setMaximumWidth(50)
        self.tubeTextEdit.setMaximumHeight(31)
        self.okButton = QtGui.QPushButton('Ok')
        self.okButton.setMaximumWidth(50)
        self.okButton.setMaximumHeight(32)
        self.okButton.clicked.connect(self.buttonClicked)

        _nline = 0
        self.tubeGrid.addWidget(self.tubeSlider, _nline, 0, 2, 1)
        self.tubeGrid.addWidget(
            self.tubeTextEdit,
            _nline,
            2,
            1,
            1,
            QtCore.Qt.AlignRight,
            )
        self.tubeGrid.addWidget(
            self.okButton,
            _nline,
            3,
            1,
            1,
            QtCore.Qt.AlignRight,
            )

        _width = 3.5
        self.canvas1 = zoomCanvas(  # self.plotColor,
                                    # self.title,
                                    # 'Neutron Counts',
            self,
            _width,
            _width,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'X / mm',
            'Y / mm',
            )
        self.canvas1.ax.tick_params(axis='y', left='off',
                                    labelleft='off')
        self.canvas2 = zoomCanvas(  # self.plotColor,
                                    # self.title,
            self,
            _width+2,
            _width+2,
            150,
            'rNeutron Distribution',
            'SpecNo',
            'TOF / us',
            'Neutron Counts',
            )
        self.canvas1.setMinimumHeight(32)
        self.canvas2.setMinimumHeight(32)
        _nline = 0
        self.mainGrid.addWidget(self.tubeWidget, _nline, 0, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.canvas1, _nline, 0, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.canvas2, _nline, 0, 1, 1)

        # self.mainGrid.addWidget(self.sliderX,_nline,2,1,1, QtCore.Qt.AlignLeft)
        # _nline += 1
        # self.mainGrid.addWidget(self.sliderY,_nline,1,1,1, QtCore.Qt.AlignTop)

        self.mainGrid.columnStretch(1)

        self.horizontalLayout.addWidget(self.scrollArea)

        self.pix1 = None
        self.pix2 = None

    def valueChanged(self):
        self.tubeTextEdit.setText(str(self.tubeSlider.value()))

    def buttonClicked(self):
        _tube = int(self.tubeTextEdit.toPlainText())
        if _tube in range(1, 121):
            self.tubeSlider.setValue(_tube)
            self.pix1 = None
            self.pix2 = None
            self.parent.tabChange()
        else:
            logging.error('It is out of range, please choose from 1 to 120'
                          )

    def getTubeNum(self):
        return int(self.tubeTextEdit.toPlainText())

    def updateCanvas(
        self,
        value,
        started,
        _command,
        ):
        if _command in ('configure', 'abort'):
            self.pix1 = None
            self.pix2 = None
        #elif not started:
        #    pass
        #else:
        color2D = 'r'
        color3D = 'hot'
        try:
            if str(value[2]) == 'clear':
                pass
            elif len(value[2]) == 0:
                pass
            else:
                if not self.pix1:
                    self.canvas1.ax.clear()

                    # self.pix1 = self.canvas1.ax.contourf(value[0], value[1], value[2], cmap=color3D, zorder=1)

                    self.pix1 = \
                        self.canvas1.ax.pcolormesh(value[0],
                            value[1], value[2], cmap=color3D,
                            zorder=1)
                    self.canvas1.ax.add_patch(self.canvas1.rect)
                    self.canvas1.ax.set_xlabel('X / mm')
                    self.canvas1.ax.set_ylabel('Y / mm')
                else:
                    self.pix1.set_array(np.array(value[2]).ravel())
                    # self.pix1.set_array(np.array(value[2])[:-1,:-1].ravel())
                if self.canvas1.zoomSelected \
                    and self.canvas1.minX != self.canvas1.maxX \
                    and self.canvas1.minY != self.canvas1.maxY:
                    self.canvas1.ax.set_xlim(self.canvas1.minX,
                            self.canvas1.maxX)
                    self.canvas1.ax.set_ylim(self.canvas1.minY,
                            self.canvas1.maxY)
                self.canvas1.draw()
        except:
            self.pix1 = None
        try:
            if str(value[3]) == 'clear' or str(value[4]) == 'clear':
                pass
            elif len(value[3]) != len(value[4]) or len(value[4]) \
                == 0:
                pass
            else:
                if not self.pix2:
                    self.canvas2.ax.clear()
                    (self.pix2, ) = \
                        self.canvas2.ax.plot(value[3],
                            value[4], color=color2D, zorder=1)
                    self.canvas2.ax.add_patch(self.canvas2.rect)
                    self.canvas2.ax.set_xlabel('TOF / us')
                    self.canvas2.ax.set_ylabel('Neutron Counts')
                else:
                    # self.pix2.set_xdata(value[3])
                    self.pix2.set_ydata(value[4])
                if self.canvas2.zoomSelected \
                    and self.canvas2.minX != self.canvas2.maxX \
                    and self.canvas2.minY != self.canvas2.maxY:
                    self.canvas2.ax.set_xlim(self.canvas2.minX,
                            self.canvas2.maxX)
                    self.canvas2.ax.set_ylim(self.canvas2.minY,
                            self.canvas2.maxY)
                self.canvas2.ax.relim()
                self.canvas2.ax.autoscale_view()
                self.canvas2.draw()
        except:
            self.pix2 = None
