#!/usr/bin/python
# -*- coding: utf-8 -*-
'''
Created on 2015.6.2
@author: yll
'''

from conf.constants import *

# user defined
# from model.readData import *
# from model.slitModel import *
# from presenter.slitSignal import *

from viewer.canvas import *


class CSNSDetectorPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.setupUi(self)
        self.parent = parent

    def setupUi(self, Widget):
        self.horizontalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        # for main  grid

        self.mainGrid = QtGui.QGridLayout(self.first)

        _width = 3.5
        self.mainCanvas = figureCanvas(  # self.plotColor,
                                         # self.title,
            self,
            _width,
            _width,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'qx (A-1)',
            'qy (A-1)',
            )
        self.mainCanvas.x1 = self.mainCanvas.ax.axhline(0, color='gray'
                , zorder=2)
        self.mainCanvas.y1 = self.mainCanvas.ax.axvline(0, color='gray'
                , zorder=2)
        self.mainCanvas.draw()
        self.mouseClickedEvents()

        # canvas for y

        self.upCanvas = zoomCanvas(  # self.plotColor,
                                     # self.title,
            self,
            _width,
            1,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'Qx',
            'Neutron Counts',
            )
        self.upCanvas.setMinimumHeight(50)

        # canvas for x

        self.leftCanvas = zoomCanvas(  # self.plotColor,
                                       # self.title,
            self,
            1,
            _width,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'Qy',
            'Neutron Counts',
            )
        self.leftCanvas.setMinimumWidth(50)

        # self.sliderX=QtGui.QSlider(QtCore.Qt.Vertical)

        _nline = 0
        self.mainGrid.addWidget(self.upCanvas, _nline, 1, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.leftCanvas,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignRight,
            )
        self.mainGrid.addWidget(self.mainCanvas, _nline, 1, 1, 1)

        # self.mainGrid.addWidget(self.sliderX,_nline,2,1,1, QtCore.Qt.AlignLeft)
        # _nline += 1
        # self.mainGrid.addWidget(self.sliderY,_nline,1,1,1, QtCore.Qt.AlignTop)

        self.mainGrid.columnStretch(1)

        self.horizontalLayout.addWidget(self.scrollArea)

        self.value = None
        self.xdata = 0
        self.ydata = 0
        self.mouseClicked = False

        self.pix1 = None
        self.pix2 = None
        self.pix3 = None

    def mouseClickedEvents(self):
        self.mainCanvas.mpl_connect('button_press_event',
                                    self.changeRegion)

        # self.slitImageCanvas.mpl_connect('motion_notify_event', self.changeRegion)
        # self.slitImageCanvas.mpl_connect('button_release_event', self.changeXYFigure)

        self.mainCanvas.mpl_connect('button_press_event',
                                    self.changeXYFigure)

    def changeRegion(self, event):
        self.xdata = event.xdata
        self.ydata = event.ydata
        _canvas = self.mainCanvas
        _canvas.ax.clear()
        _canvas.ax.contourf(self.value[0], self.value[1],
                            self.value[2], cmap='hot', zorder=1)
        (_xdata, _ydata, _xindex, _yindex) = \
            self.getXYData(event.xdata, event.ydata, self.value)
        if event.button == 1:

            # _canvas.x1.set_xdata([event.ydata,event.ydata])
            # _canvas.y1.set_ydata([event.xdata,event.xdata])

            _canvas.x1 = _canvas.ax.axhline(event.ydata, color='gray',
                    zorder=2)
            _canvas.y1 = _canvas.ax.axvline(event.xdata, color='gray',
                    zorder=2)
        elif event.button == 3:

            # _canvas.x1.set_xdata([event.ydata,event.ydata])
            # _canvas.y1.set_ydata([event.xdata,event.xdata])

            _canvas.x1 = _canvas.ax.axhline(event.ydata, color='gray',
                    zorder=2)
            _canvas.y1 = _canvas.ax.axvline(event.xdata, color='gray',
                    zorder=2)
        else:
            pass
        _canvas.draw()

    def changeXYFigure(self, event):
        color2D = 'r'
        (_datax, _datay) = self.getCountsData(self.value)
        if event.button == 1:
            self.mouseClicked = True
            try:
                self.leftCanvas.ax.clear()
                self.leftCanvas.ax.plot(_datax, self.value[1],
                        color=color2D)

                # self.leftCanvas.fig.set_xdata(_datax, color=color2D)

                self.leftCanvas.draw()
            except:
                pass
            try:
                self.upCanvas.ax.clear()
                self.upCanvas.ax.plot(self.value[0], _datay,
                        color=color2D)
                self.upCanvas.draw()
            except:
                pass
        elif event.button == 3:
            self.mouseClicked = True
            try:
                self.upCanvas.ax.clear()
                self.upCanvas.ax.plot(self.value[0], _datay,
                        color=color2D)

                # self.upCanvas.fig.set_ydata(_datay, color=color2D)

                self.upCanvas.draw()
            except:
                pass
            try:
                self.leftCanvas.ax.clear()
                self.leftCanvas.ax.plot(_datax, self.value[1],
                        color=color2D)
                self.leftCanvas.draw()
            except:
                pass

    def getXYData(
        self,
        xdata,
        ydata,
        value,
        ):
        _xdata = 0
        _ydata = 0
        xlist = []
        ylist = []
        _minx = 0
        _miny = 0
        xindex = 0
        yindex = 0

        for i in range(len(value[0])):
            xlist.append(abs(value[0][i] - xdata))
        _minx = min(xlist)
        xindex = xlist.index(_minx)
        _xdata = value[0][xindex]

        for i in range(len(value[1])):
            ylist.append(abs(value[1][i] - ydata))
        _miny = min(ylist)
        yindex = ylist.index(_miny)
        _ydata = value[1][yindex]

        # self.xEventData = _xdata
        # self.yEventData = _ydata

        return (_xdata, _ydata, xindex, yindex)

    def getCountsData(self, value):
        xcounts = []
        ycounts = []
        (_xdata, _ydata, xindex, yindex) = self.getXYData(self.xdata,
                self.ydata, self.value)
        ytmp = value[2][yindex]
        for j in ytmp:
            ycounts.append(j)

        for i in range(len(value[1])):
            xcounts.append(value[2][i][xindex])
        return (xcounts, ycounts)

    def updateCanvas(
        self,
        value,
        started,
        _command,
        ):
        self.value = value
        if _command in ('configure', 'abort'):
            self.pix1 = None
            self.pix2 = None
            self.pix3 = None
        #elif not started:
        #    pass
        #else:
        color2D = 'r'
        color3D = 'hot'
        try:
            if str(value[2]) == 'clear':
                pass
            elif len(value[2]) == 0:
                pass
            else:
                if not self.pix1:
                    self.mainCanvas.ax.clear()
                    self.pix1 = \
                        self.mainCanvas.ax.contourf(value[0],
                            value[1], value[2], cmap=color3D,
                            zorder=1)
                    self.mainCanvas.ax.set_xlabel('QX')
                    self.mainCanvas.ax.set_ylabel('Qy')
                else:
                    self.pix1.set_array(np.array(value[2]).ravel())
                self.mainCanvas.x1 = \
                    self.mainCanvas.ax.axhline(self.ydata,
                        color='gray', zorder=2)
                self.mainCanvas.y1 = \
                    self.mainCanvas.ax.axvline(self.xdata,
                        color='gray', zorder=2)

                # self.mainCanvas.ax.relim()
                # self.mainCanvas.ax.autoscale_view(True, True, True)

                self.mainCanvas.draw()
        except:
            self.pix1 = None
        try:
            if not self.mouseClicked:
                (_datax, _datay) = \
                    self.getCountsData(self.value)
                if str(self.value[1]) == 'clear' or str(_datax) == 'clear':
                    pass
                elif len(self.value[1]) != len(_datax) \
                    or len(_datax) == 0:
                    pass
                else:
                    if not self.pix2:
                        self.leftCanvas.ax.clear()
                        (self.pix2, ) = \
                            self.leftCanvas.ax.plot(_datax,
                                self.value[1], color=color2D)
                        self.leftCanvas.ax.add_patch(self.leftCanvas.rect)
                        self.leftCanvas.ax.set_xlabel('Neutron Counts'
                                )
                        self.leftCanvas.ax.set_ylabel('Qy')
                    else:
                        self.pix2.set_xdata(_datax)
                        self.pix2.set_ydata(self.value[1])
                    if self.leftCanvas.zoomSelected \
                        and self.letfCanvas.minX \
                        != self.leftCanvas.maxX \
                        and self.leftCanvas.minY \
                        != self.leftCanvas.maxY:
                        self.leftCanvas.ax.set_xlim(self.leftCanvas.minX,
                                self.leftCanvas.maxX)
                        self.leftCanvas.ax.set_ylim(self.leftCanvas.minY,
                                self.leftCanvas.maxY)

                    # self.leftCanvas.fig.set_xdata(_datax, color=color2D)

                    self.leftCanvas.ax.relim()
                    self.leftCanvas.ax.autoscale_view()
                    self.leftCanvas.draw()
        except:
            self.pix2 = None
        try:
            if str(self.value[0]) == 'clear' or str(_datay) == 'clear':
                pass
            if len(self.value[0]) != len(_datay) or len(_datay) \
                == 0:
                pass
            else:
                if not self.pix3:
                    self.upCanvas.ax.clear()
                    (self.pix3, ) = \
                        self.upCanvas.ax.plot(self.value[0],
                            _datay, color=color2D)
                    self.upCanvas.ax.add_patch(self.upCanvas.rect)
                    self.upCanvas.ax.set_ylabel('Neutron Counts'
                            )
                    self.upCanvas.ax.set_xlabel('Qx')
                else:
                    self.pix3.set_xdata(self.value[0])
                    self.pix3.set_ydata(_datay)
                if self.upCanvas.zoomSelected \
                    and self.upCanvas.minX \
                    != self.upCanvas.maxX \
                    and self.upCanvas.minY \
                    != self.upCanvas.maxY:
                    self.upCanvas.ax.set_xlim(self.upCanvas.minX,
                            self.upCanvas.maxX)
                    self.upCanvas.ax.set_ylim(self.upCanvas.minY,
                            self.upCanvas.maxY)
                self.upCanvas.ax.relim()
                self.upCanvas.ax.autoscale_view()
                self.upCanvas.draw()
        except:
            self.pix3 = None
