#!/usr/bin/python
# -*- coding: utf-8 -*-
from model import jsonArray
import threading
from Queue import Queue
import time
import matplotlib
import numpy as np
import cStringIO
from PIL import Image
import logging
import redis
import datetime
from PyQt4 import QtCore
from PyQt4.QtCore import QThread
import random
import sys
from model import thread

from model import getNeonData

class setHeartbeat(threading.Thread):

    def __init__(
        self,
        parent,
        neonRedis,
        refreshtime,
        neonpath,
        status,
        ):
        #super(setHeartbeat, self).__init__()
        #QThread.__init__(self)
        threading.Thread.__init__(self)
        self.paused = False
        self.pause_cond = threading.Condition(threading.Lock())
        self.thread_stop = False

        self.parent=parent
        self.neonRedis=neonRedis
        self.refreshtime=refreshtime
        self.neonpath=neonpath
        self.status=status

    def process(self):
        try:
            _status = self.getStatus()
            _data={'timestamp':time.strftime('%Y-%m-%dT%H:%M:%S.%03d+08:00'),'status':_status}
            self.neonRedis.set(self.neonpath, _data)
        except:
            pass

    def run(self):
        while True:
            self.process()
            time.sleep(self.refreshtime)

    def getStatus(self):
        return self.parent.getStatus()

class dataThread(QtCore.QObject):
    def __init__(self, parent,  gui, neonServer=None, progressPath=None, protonPath=None, neutronPath=None, pulsePath=None, refreshTime=1.0):
        super(self.__class__, self).__init__()
        self.gui=gui
        self.worker = getNeonData.getNeonData(self, neonServer, progressPath, protonPath, neutronPath, pulsePath, refreshTime)
        self.worker_thread = getNeonData.workerThread(gui)
        self.worker.moveToThread(self.worker_thread)
        self.worker_thread.started.connect(self.worker.process)
        self.worker.finished.connect(self.worker_thread.quit)
         
        self.worker.signalLog.connect(self.gui.setLog)
        self.worker.signalProgress.connect(self.gui.setProgressData) 
        self.worker.signalStatus.connect(self.gui.setCanvasData) 
        self.worker.signalMonitor.connect(self.gui.setMonitorCanvas)
        self.worker.signalExperiment.connect(self.gui.setUserData)
        
    def pause(self):
        self.worker.set(False)

    def resume(self):
        self.worker.resume()

    def clear(self):
        if self.worker_thread.isRunning():
            self.worker_thread.terminate()
            self.worker_thread.wait()
            #self.signalProgress.emit('')
            #self.signalStatus.emit()
            #self.signalMonitor.emit()
            #self.signalExperiment.emit()
            #self.worker_thread.start()

    def start(self):
        self.worker_thread.start()

    def stop(self):
        if self.worker_thread.isRunning():
            self.worker_thread.terminate()
    
    def exit(self):
        self.worker.exit()

    def setDataPath(self, kwargs):
        self.worker.setDataPath(kwargs)

    def getTabIndex(self):
        return self.worker.getTabIndex()

    def getMonitorTOF(self):
        return self.worker.getMonitorTOF()

    def getDetectorIndex(self):
        return self.gui.getDetectorIndex()

class commandThread(QtCore.QObject):
    def __init__(self, parent,  gui, neonServer=None, commandPath=None, refreshTime=1.0):
        super(self.__class__, self).__init__()

        self.gui=gui
        self.worker = getNeonData.getNeonCommand(self, neonServer, commandPath, refreshTime)
        self.worker_thread = getNeonData.workerThread(self.gui)
        self.worker.moveToThread(self.worker_thread)       
        self.worker_thread.started.connect(self.worker.process)
        self.worker.finished.connect(self.worker_thread.quit)
        #self.gui.getCommandButton().clicked.connect(self.pause)
        #self.gui.getCommandButton().clicked.connect(self.resume)
 
        self.worker.signalLog.connect(self.gui.setLog)
        self.worker.signalStatus.connect(self.gui.setCommand)

    def pause(self):
        if self.worker_thread.isRunning():
            #self.worker_thread.terminate()
            #self.worker_thread.wait()
            self.worker.set(False)

    def resume(self):
        if not self.worker_thread.isRunning():
            self.worker.set(True)
            self.worker_thread.start()

    def clear(self):
        if self.worker_thread.isRunning():
            self.worker_thread.terminate()
            self.worker_thread.wait()

            self.signalStatus.emit('')
            self.worker_thread.start()

    def start(self):
        self.worker_thread.start()

    def stop(self):
        if self.worker_thread.isRunning():
            self.worker_thread.terminate()

class connectNeon():
    
    def __init__(
        self,
        ip_port,
        passwd,
        timeout,
        ):

        self.status=False
        self.server=None
        begin=time.time()
        while True:
            if not self.server:
                #self.server = redis.Redis(host=ip, port=port, password=passwd, db=0, socket_connect_timeout=1.0)
                sentinel = redis.sentinel.Sentinel([('10.1.53.240', 9001), ('10.1.53.240',9011), ('10.1.53.240',9021)], socket_timeout=0.1)
                try:
                    #client=self.server.client_list()
                    self.server=sentinel.master_for('neonmaster', socket_timeout=0.1, password=passwd)
                except (redis.exceptions.ConnectionError):
                    logging.warning("Attempt to connect NEON again!")
                if self.server:
                    self.status = True
                    logging.info("NEON connected")
                    break
                else:
                    #logging.exception("NEON not available")
                    logging.error("NEON not available")
                if time.time()-begin>timeout:
                    logging.info("NEON connect timeout")
                    break
    
    def getStatus(self):
        return self.status

    def getServer(self):
        return self.server
      
