from PyQt4 import QtGui, QtCore
import sys
import random
import time
import json
from model import jsonArray
import cStringIO
from PIL import Image
import base64
import numpy

class getNeonCommand(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalStatus = QtCore.pyqtSignal(str)
    signalLog = QtCore.pyqtSignal(str)
 
    def __init__(self, parent, neonServer, commandPath, refreshTime):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.commandPath = commandPath
        self.refreshTime = refreshTime
        self.command=True

    def pause(self):
        self.command=False
    
    @QtCore.pyqtSlot()
    def process(self):
        while True:
            if not self.command: break
            try:
                #i=random.randint(0,4)
                _command = self.neonServer.get(self.commandPath)
                if _command is None:
                    self.signalLog.emit("Empty command Data from NEON!")
                else:
                    try:
                        self.signalStatus.emit(_command)
                        #self.signalStatus.emit(self.mylist[i])#str(_command))
                    except:
                        pass
            except:
                pass
            
            time.sleep(self.refreshTime) 
        self.finished.emit()            

    def set(self, command):
        self.command=command
    
    def get(self):
        return self.command

class getNeonData(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalProgress = QtCore.pyqtSignal(str)
    signalStatus = QtCore.pyqtSignal(object)
    signalMonitor = QtCore.pyqtSignal(object)
    signalExperiment = QtCore.pyqtSignal(object,object)
    signalLog = QtCore.pyqtSignal(str)

    def __init__(self, parent, neonServer, progressPath, protonPath, neutronPath, pulsePath, refreshTime):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.progressPath = progressPath
        self.protonPath = protonPath
        self.neutronPath = neutronPath
        self.pulsePath = pulsePath
        self.refreshTime = refreshTime
        self.started = True
        self.imgpath = None
        self.kwargs = {}
        self.tabIndex = 0
        self.monitorTOFPath = '/SANS/workspace/MantidData/monitor02/tof'
        self.monitorCountsPath = '/SANS/workspace/MantidData/monitor02/counts'
        self.monitorTOF=[]

        self.scatteringx = []
        self.scatteringy = []
        self.pidXaxis=[]
        self.xyXaxis=[]
        self.xyYaxis=[]
        for i in range(6):
            self.pidXaxis.append([])
            self.xyXaxis.append([])
            self.xyYaxis.append([])
    
    def __del__(self):
        self.wait()

    def pause(self):
        self.started=False

    def set(self, value):
        self.started=value

    def get(self):
        return self.started

    def resume(self):
        if not self.started:
            self.started = True

    @QtCore.pyqtSlot()
    def process(self):
        # progress setting in mainSet
        try:
            #get json date after json.dumps from neon
            progress = self.neonServer.get(self.progressPath)
            if progress is None:
                self.signalLog.emit("Empty progressBar Setting Data!")
            else:
                try:
                    self.signalProgress.emit(progress)
                except:
                    pass
        except:
            pass 

        # Monitor TOF in User Panel 
        try:
            _data = self.neonServer.get(self.monitorTOFPath)
            if _data is None:
                self.signalLog.emit("Empty Monitor TOF Data!")
            else:
                try:
                    _data = jsonArray.jsonDecoder(_data)
                    self.monitorTOF=_data
                except:
                    self.signalLog.emit("Incompleted Monitor TOF Data")
        except:
            pass

        while True:
            _started = self.get()
            if not _started:
                continue 
            # Monitor Counts in User Panel 
            try:
                _data = self.neonServer.get(self.monitorCountsPath)
            except:
                pass
            if _data is None :
                self.signalLog.emit("Empty Monitor Counts Data!")
            else:
                try:
                    _data = jsonArray.jsonDecoder(_data)
                    self.signalMonitor.emit(_data)
                except:
                    self.signalLog.emit("Incompleted Monitor Counts Data")
            
            # get Proton Charge and Neutron Counts in User
            try:
                _proton = self.neonServer.get(self.protonPath)
                _neutron = self.neonServer.get(self.neutronPath)
            except:
                pass
            if _proton is None:
                self.signalLog.emit("Empty Proton Charge Data!")
            else:
                try:
                    _proton = jsonArray.jsonDecoder(_proton)
                except:
                    self.signalLog.emit("Incompleted Proton Charge  data")
            if _neutron is None:
                self.signalLog.emit("Empty Neutron Counts Data!")
            else:
                try:
                    _neutron = jsonArray.jsonDecoder(_neutron)
                except:
                    self.signalLog.emit("Incompleted Neutron Counts data")
            try:
                self.signalExperiment.emit(_proton[-1][-1],  _neutron[-1][-1])
            except:
                pass

            # get Tab index
            try:
                self.tabIndex = self.kwargs['tabIndex']
            except:
                pass
            # Scattering page
            if self.tabIndex == 0:
                value = []
                for i in range(len(self.kwargs)-1):
                    value.append([])
                value[0]=self.scatteringx
                value[1]=self.scatteringy
                for i in range(len(self.kwargs)-1):
                    if i == 0:
                        if self.scatteringx != []:
                            continue
                        else:
                            try:
                                _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                                if _data is None:
                                    self.signalLog.emit("Empty path"+str(i+1)+" Data!")
                                else:
                                    try:
                                        _data = jsonArray.jsonDecoder(_data)
                                        self.scatteringx = _data
                                    except:
                                        self.signalLog.emit("Incompleted path"+str(i+1)+"Data!")
                            except:
                                pass             
                    elif i == 1:
                        if self.scatteringy != []:
                            continue
                        else:
                            try:
                                _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                                if _data is None:
                                    self.signalLog.emit("Empty path"+str(i+1)+" Data!")
                                else:
                                    try:
                                        _data = jsonArray.jsonDecoder(_data)
                                        self.scatteringy = _data
                                    except:
                                        self.signalLog.emit("Incompleted path"+str(i+1)+"Data!")
                            except:
                                pass
                    else:
                        _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                        try:
                            _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                            if _data is None:
                                self.signalLog.emit("Empty path"+str(i+1)+" Data!")
                            else:
                                try:
                                    _data = jsonArray.jsonDecoder(_data)
                                except:
                                    self.signalLog.emit("Incompleted path"+str(i+1)+"Data!")
                            value[i]=_data
                        except:
                            pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Detector page
            elif self.tabIndex == 1:
                value = []
                for i in range(len(self.kwargs)-1):
                    value.append([])
                for i in range(len(self.kwargs)-1):
                    try:
                        _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                    except:
                        pass
                    if _data is None:
                        self.signalLog.emit("Empty Canvas Data!")
                    else:
                        try:
                            _data = jsonArray.jsonDecoder(_data)
                        except:
                            self.signalLog.emit("Incompleted Canvas data")
                    value[i] = _data
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Transmission page
            elif self.tabIndex == 2:
                value = []
                try:
                    for i in range(len(self.kwargs)-1):
                        _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                        if _data is None:
                            self.signalLog.emit("Empty Canvas Data!")
                        else:
                            try:
                                _data = jsonArray.jsonDecoder(_data)
                            except:
                                self.signalLog.emit("Incompleted Canvas data")
                        value.append(_data)
                except:
                    pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Monitor page
            elif self.tabIndex == 3:
                value = []
                for key in self.kwargs: 
                    _array = [[],[],[]]
                    _pause = self.kwargs['status']
                    if key=='tabIndex':
                        pass
                    elif key == 'status':
                        pass
                    else:
                        try:
                            for j in range(len(self.kwargs[key])):
                                if _pause[j]=='Pause':
                                    _data = self.neonServer.get(self.kwargs[key][j])
                                    if _data is None:
                                        self.signalLog.emit("Empty Canvas Data!")
                                    else:
                                        try:
                                            _data = jsonArray.jsonDecoder(_data)
                                            _array[j] = _data
                                        except:
                                            self.signalLog.emit("Incompleted Canvas data")
                                else:
                                    pass
                            value.append(_array)
                        except:
                            pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
                '''
                value = []
                _array = []
                _pause = []
                _pause = self.kwargs['status']
                #for i in range(len(self.kwargs)-2):
                #    value.append([])
                #for j in range(len(self.kwargs['path1'])):
                #    _array.append([])
                try:
                    i = 0
                    for i in range(len(self.kwargs)-2):
                        j = 0
                        for j in range(len(self.kwargs['path1'])):
                            if _pause[j]=='Pause':
                                _data = self.neonServer.get(self.kwargs['path'+str(i+1)][j])
                                if _data is None:
                                    self.signalLog.emit("Empty Canvas Data!")
                                else:
                                    try:
                                        _data = jsonArray.jsonDecoder(_data)
                                        _array[j] = _data
                                    except:
                                        self.signalLog.emit("Incompleted Canvas data")
                            else:
                                pass
                        value[i] = _array
                except:
                    pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
                '''
            # Experiment page
            elif self.tabIndex == 4:
                value = []
                _array = []
                for i in range(len(self.kwargs)-1):
                    value.append([])
                for i in range(len(self.kwargs['path1'])):
                    _array.append([])
                try:
                    for i in range(len(self.kwargs)-1):
                        for j in range(len(self.kwargs['path'+str(i+1)])):
                            _data = self.neonServer.get(self.kwargs['path'+str(i+1)][j])
                            if _data is None:
                                self.signalLog.emit("Empty Canvas Data!")
                            else:
                                try:
                                    _data = jsonArray.jsonDecoder(_data)
                                    _array[j] = _data
                                except:
                                    self.signalLog.emit("Incompleted Canvas data")
                        value[i] = _array
                except:
                    pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            
            time.sleep(self.refreshTime)
        self.finished.emit()

    def setDataPath(self, kwargs):
        self.kwargs = kwargs

    def getTabIndex(self):
        return self.tabIndex

    def getMonitorTOF(self):
        return self.monitorTOF

    def getDetectorIndex(self):
        return self.parent.getDetectorIndex()

class workerThread(QtCore.QThread):
    def __init__(self, parent):
        super(workerThread, self).__init__(parent)

    def __del__(self):
        self.wait()

