#!/usr/bin/python
# -*- coding: utf-8 -*-

# user defined
from canvas import *
from conf.constants import *

class CSNSScatteringPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSScatteringPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)
        
        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.third = QtGui.QFrame(self)
        self.third.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea3 = QtGui.QScrollArea()
        self.scrollArea3.setWidgetResizable(True)
        self.scrollArea3.setWidget(self.third)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)
        self.splitter.addWidget(self.scrollArea3)
        self.splitter.setSizes([300, 150, 150])

        #main Grid
        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
        self.thirdGrid = QtGui.QGridLayout(self.third)

        _xsize = 16#6
        _ysize = 8#3
        self.canvas1 = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'X',
            'Y',
            )
        self.x1 = self.canvas1.ax.axhline(0.5,color='gray')
        self.y1 = self.canvas1.ax.axvline(0.5,color='gray')
        self.canvas1.draw()

        self.button = QtGui.QPushButton('Find Center',self.first)
        self.button.clicked.connect(self.buttonClicked)

        self.canvas2 = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'X',
            'Y',
            )

        self.canvas3 = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'X',
            'Y',
            )

        _nline = 0
        self.firstGrid.addWidget(self.canvas1, _nline,0,1,7)
        self.secondGrid.addWidget(self.canvas2, _nline,0,1,7)
        self.thirdGrid.addWidget(self.canvas3, _nline,0,1,7)
        _nline += 1
        self.firstGrid.addWidget(self.button, _nline,4,1,1)
        
        self.verticalLayout.addWidget(self.splitter)       
        
        self.centerLine = False

    def buttonClicked(self):
        self.centerLine = True

    def updateCanvas(self, value, started, _command):
        self.canvas1.ax.clear()
        self.canvas2.ax.clear()
        self.canvas3.ax.clear()
        if _command in ('configure', 'stop', 'abort'):
            pass
        else:
            if not started:
                pass
            else:
                color2D = 'r'
                color3D = 'hot'
                try:
                    self.canvas1.ax.pcolormesh(value[0], value[1], value[2], cmap=color3D)
                    self.canvas2.ax.plot(value[3], value[4], color=color2D)
                    self.canvas3.ax.plot(value[5], value[6], color=color2D)
                except:
                    pass
                if self.centerLine:
                    self.x1.set_ydata([value[7],value[7]])
                    self.y1.set_xdata([value[7],value[7]])
                self.canvas1.draw()
                self.canvas2.draw()
                self.canvas3.draw()

            
