'''
Created on 2015.6.2
@author: yll
'''
from conf.constants import *

# user defined
#from model.readData import *
#from model.slitModel import *
#from presenter.slitSignal import *
from viewer.canvas import *

class CSNSDetectorPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,Widget):
        self.horizontalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        #for main  grid
        self.mainGrid = QtGui.QGridLayout(self.first)
        
        _width=3.5
        self.mainCanvas = figureCanvas(
            self,
            _width,
            _width,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'X / mm',
            'Y / mm',
            )
        #self.dataX, self.dataY, self.dataZ = CSNSRead3DData("./dat/3d1.dat")
        #cset = self.slitImageCanvas.ax.contourf(self.dataY, self.dataX, self.dataZ, zdir='z', offset=0, cmap=cm.coolwarm)
        self.mainCanvas.x1 = self.mainCanvas.ax.axhline(52,color='gray')
        self.mainCanvas.y1 = self.mainCanvas.ax.axvline(48,color='gray')
        self.mainCanvas.draw()
        
        self.mouseClickedEvents()

        # canvas for y
        self.upCanvas = figureCanvas(
            self,
            _width,
            1,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'Y / mm',
            'Neutron Counts',
            )
        '''
        self.slitXCanvas.ax.yaxis.tick_right()
        nx, dataX = CSNSRead2DData("./dat/2d-x.dat")
        _tmp=self.slitXCanvas.ax.plot(dataX[0],dataX[1],color='red')
        self.slitXCanvas.slitXFigure=_tmp[0]
        self.slitXCanvas.draw()
        '''

        # canvas for x
        self.leftCanvas = figureCanvas(
            self,
            1,
            _width,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'X / mm',
            'Neutron Counts',
            )
        '''
        ny, dataY = CSNSRead2DData("./dat/2d-y.dat")
        _tmp=self.slitYCanvas.ax.plot(dataY[1],dataY[0],color='green')
        self.slitYCanvas.slitYFigure=_tmp[0]
        #self.slitYCanvas.draw()
        '''

        self.sliderY=QtGui.QSlider(QtCore.Qt.Horizontal)
        self.sliderX=QtGui.QSlider(QtCore.Qt.Vertical)

        # parameter grid
        self.directBeamLabel =  QtGui.QLabel("<font color=red>Direct Beam:</font>")
        self.directBeamText=QtGui.QLabel("(25,50) ")

        self.reflectedBeamLabel =  QtGui.QLabel("<font color=red>Reflected Beam:</font>")
        self.reflectedBeamText=QtGui.QLabel("(64,50)")

        self.parameterWidget= QtGui.QWidget(self.first)
        self.parameterGrid = QtGui.QGridLayout(self.parameterWidget)
        
        _nline = 0
        self.mainGrid.addWidget(self.upCanvas,_nline,1,1,1)
        _nline += 1
        self.mainGrid.addWidget(self.leftCanvas,_nline,0,1,1,QtCore.Qt.AlignRight)
        self.mainGrid.addWidget(self.mainCanvas,_nline,1,1,1)
        self.mainGrid.addWidget(self.sliderX,_nline,2,1,1, QtCore.Qt.AlignLeft)
        _nline += 1
        self.mainGrid.addWidget(self.sliderY,_nline,1,1,1, QtCore.Qt.AlignTop)
        _nline += 1
        self.mainGrid.addWidget(self.parameterWidget,_nline,0,1,1, QtCore.Qt.AlignTop)

        self.mainGrid.columnStretch(1)
        
        _nline += 1
        self.parameterGrid.addWidget(self.directBeamLabel,_nline,0,1,1)
        self.parameterGrid.addWidget(self.directBeamText,_nline,1,1,1)
        _nline += 1
        self.parameterGrid.addWidget(self.reflectedBeamLabel,_nline,0,1,1)
        self.parameterGrid.addWidget(self.reflectedBeamText,_nline,1,1,1)
        
        self.horizontalLayout.addWidget(self.scrollArea)
    
        self.value = None

    def mouseClickedEvents(self):
        self.mainCanvas.mpl_connect('button_press_event', self.changeRegion)
        #self.slitImageCanvas.mpl_connect('motion_notify_event', self.changeRegion)
        #self.slitImageCanvas.mpl_connect('button_release_event', self.changeXYFigure)
        self.mainCanvas.mpl_connect('button_press_event', self.changeXYFigure)

    def changeRegion(self,event):
        _canvas = self.mainCanvas

        if event.button == 1:
            _canvas.x1.set_ydata([event.ydata,event.ydata])
            _canvas.draw()
            #self.xCanvas.draw()
        elif event.button == 3:
            _canvas.y1.set_xdata([event.xdata,event.xdata])
            _canvas.draw()
        else:
            pass

    def changeXYFigure(self,event):
        _datax, _datay = getXYData(event.ydata, event.xdata, self.value)
        if event.button == 1:
            self.upCanvas.fig.set_xdata(_datay[1])
            self.upCanvas.fig.set_ydata(_datay[0])
        elif event.button == 3:
            self.leftCanvas.fig.set_xdata(_datax[1])
            self.leftCanvas.fig.set_ydata(_datax[0])
        else:
            pass
        '''
        if event.button == 1:
            dataYZ, dataXZ = getXYdata(event.ydata, event.xdata, self.dataX, self.dataY, self.dataZ)
            self.slitXCanvas.slitXFigure.set_xdata(dataYZ[0])
            self.slitXCanvas.slitXFigure.set_ydata(dataYZ[1])
            self.slitXCanvas.draw()
        elif event.button == 3:
            dataYZ, dataXZ = getXYdata(event.ydata, event.xdata, self.dataX, self.dataY, self.dataZ)
            self.slitYCanvas.slitYFigure.set_xdata(dataXZ[1])
            self.slitYCanvas.slitYFigure.set_ydata(dataXZ[0])
            self.slitYCanvas.draw()
        else:
            pass
        '''
    def getXYData(xdata, ydata, value):
        pass

    def updateCanvas(self, value, started, _command):
        self.value = value
        self.mainCanvas.ax.clear()
        self.xCanvas.ax.clear()
        self.yCanvas.ax.clear()
        _datax, _datay = getXYData(event.ydata, event.xdata, self.value)
        if _command in ('configure', 'stop', 'abort'):
            pass
        else:
            if not started:
                pass
            else:
                color2D = 'r'
                color3D = 'hot'
                try:
                    self.mainCanvas.ax.mainCanvas.ax.pcolormesh(value[0], value[1], value[2], cmap=color3D)
                    self.xCanvas.ax.plot(_datax[0], _datay[0], color=color2D)
                    self.yCanvas.ax.plot(_datax[1], _datay[1], color=color2D)
                except:
                    pass
                self.mainCanvas.draw()
                self.xCanvas.draw()
                self.yCanvas.draw()
