'''
Created on 2015.6.4
@author: yll
'''
from conf.constants import *
from canvas import *
#from model.readData import *
#from model.readImage import *

class CSNSTransmissionPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSTransmissionPage, self).__init__(parent=None)
        self.setupUi(self)
        self.parent = parent

    def setupUi(self,Widget):
    	#self.setTabPosition(QTabWidget.West)
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.mainGrid = QtGui.QGridLayout(self.first)
        self.checkBox = QtGui.QCheckBox("DirecetBeam Correction", self)
        self.checkBox.stateChanged.connect(self.checkBoxChanged)

        '''
        self.gisansFigure = Figure((6,3), dpi=150, facecolor="white", edgecolor=None, linewidth=1.0, frameon=False, tight_layout=False)

        self.gisansFigure.subplots_adjust(left=0.0, bottom=0.05, right=0.95, top=0.95)
        self.gisansCanvas = FigureCanvas(self.gisansFigure)
        self.gisansCanvas.setParent(self)

        self.gisansnAxes = self.gisansFigure.add_subplot(122,projection='3d')
        X, Y, Z, C = CSNSReadImageSurface("./img/XY ++.png")
        self.gisansnAxes.plot_surface(X, Y, Z, rstride=1, cstride=1, facecolors=cm.jet(C), linewidth=0, antialiased=False, shade=False)
        self.gisansnAxes.tick_params(axis='both', which='major', labelsize=5)
        '''
        _xsize = 6
        _ysize = 3
        self.canvas1 = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'Wavelength / A',
            'Neutron Counts',
            )
        self.canvas2 = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'Wavelength /A',
            'Transmission',
            )
        
        _nline = 0
        self.mainGrid.addWidget(self.canvas1,_nline,0,1,5)
        _nline += 1
        self.mainGrid.addWidget(self.canvas2,_nline,0,1,5)
        _nline += 1
        self.mainGrid.addWidget(self.checkBox,_nline,2,1,1)

        self.verticalLayout.addWidget(self.scrollArea)
            
        self.checkBoxIndex = 0
        self.pix2 = None

    def checkBoxChanged(self):
        if self.checkBox.isChecked():
            self.checkBoxIndex = 1
        else:
            self.checkBoxIndex = 0
        
        self.parent.tabChange()        

    def getCheckBoxIndex(self):
        return self.checkBoxIndex

    def updateCanvas(self, value, started, _command):
        if _command in ('configure', 'stop', 'abort'):
            self.canvas1.draw()
            self.canvas2.draw()
            self.pix2 = None
        else:
            if not started:
                pass
            else:
                try:
                    if len(value[0]) != len(value[1]):
                        pass
                    elif len(value[1]) == 0:
                        pass
                    elif len(value[2]) != len(value[3]):
                        pass
                    elif len(value[3]) == 0:
                        pass
                    else:
                        self.canvas1.ax.clear()
                        self.canvas1.ax.plot(value[0], value[1], color='r')
                        self.canvas1.ax.plot(value[2], value[3], color='b')
                        self.canvas1.draw()
                except:
                    pass
                try:
                    if len(value[4]) != len(value[5]):
                        pass
                    elif len(value[5]) == 0:
                        pass
                    else:
                        if not self.pix2:
                            self.canvas2.ax.clear()
                            self.pix2 = self.canvas2.ax.plot(value[4], value[5], color='g')
                        else:
                            self.pix2.set_ydata(value[5])
                        self.canvas2.draw()
                except:
                    pass
