#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Monitor

'''
import numpy as np
from PyQt4 import QtCore, QtGui
import monitorDock

class CSNSMonitorPage(QtGui.QMainWindow):  # QTabWidget):

    def __init__(self, parent):
        super(CSNSMonitorPage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):  # QTabWidget):

        self.monitorDock = []
        self.monitorDock.append(monitorDock.monitorDock(
            self,
            '/BL01/BANK01/PATTERN',
            '/BL01/BANK01/IMAGE',
            9,
            0.8,
            'y',
            'Accent',
            'Incident Monitor 1',
            ))
        self.monitorDock.append(monitorDock.monitorDock(
            self,
            '/BL01/BANK03/PATTERN',
            '/BL01/BANK03/IMAGE',
            9,
            0.8,
            'c',
            'Spectral',
            'Incident Monitor 2',
            ))
        self.monitorDock.append(monitorDock.monitorDock(
            self,
            '/BL01/BANK05/PATTERN',
            '/BL01/BANK05/IMAGE',
            9,
            0.8,
            'm',
            'cool',
            'Transmit Monitor',
            ))
        self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
                           self.monitorDock[0])
        self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
                           self.monitorDock[1])
        self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
                           self.monitorDock[2])

        self.pix1 = []
        self.pix2 = []
        for i in range(len(self.monitorDock)):
            self.pix1.append('')
            self.pix2.append('')

    def setStatus(self):
        return self.parent.setStatus()

    def updateCanvas(self, value, started, _command):
        i = 0
        _pause = None
        for i in range(len(self.monitorDock)):
            can3D = self.monitorDock[i].imageCanvas
            can2D = self.monitorDock[i].patternCanvas
            if _command in ('configure', 'stop', 'abort'):
                can3D.ax.clear()
                can2D.ax.clear()
                can3D.draw()
                can2D.draw()
                self.pix1[i] = None
                self.pix2[i] = None
            else:
                if not started:
                    pass
                else:
                    _pause = self.monitorDock[i].pauseButton.text()
                    if _pause == 'Pause':
                        try:
                            if len(value[2][i]) == 0:
                                pass
                            else:
                                if not self.pix1[i]:
                                    can3D.ax.clear()
                                    self.pix1[i] = can3D.ax.pcolormesh(value[0][i], value[1][i], value[2][i], cmap=can3D.plotColor)
                                else:
                                    self.pix1[i].set_array((value[2][i]).ravel())
                                can3D.ax.set_xlabel('X / mm')
                                can3D.ax.set_ylabel('Y / mm')
                                can3D.ax.set_aspect('equal')
                                can3D.draw()
                        except:
                            pass
                        try:
                            if len(value[3][i]) != len(value[4][i]):
                                pass
                            elif len(value[4][i]) == 0:
                                pass
                            else:
                                for j in range(len(value[3][i])):
                                    value[3][i][j] = value[3][i][j]*10
                                if not self.pix2[i]:
                                    can2D.ax.clear()
                                    self.pix2[i], = can2D.ax.plot(np.array(value[3][i])*0.1, value[4][i], color=can2D.plotColor)
                                else:
                                    self.pix2[i].set_xdata(value[3][i])
                                    self.pix2[i].set_ydata(value[4][i])
                                can2D.ax.set_xlabel('TOF / us')
                                can2D.ax.set_ylabel('Neutron Counts')
                                can2D.draw()
                        except:
                            pass
