#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for user defined

from scattering import *
from tube import *
from detector import *
from transmission import *
from monitor import *
from experiment import *
from model.chopperModel import *


class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSMainTab, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.scatteringPage = CSNSScatteringPage(self)
        self.tubePage = CSNSTubePage(self)
        self.detectorPage = CSNSDetectorPage(self)
        self.transmissionPage = CSNSTransmissionPage(self)
        self.monitorPage = CSNSMonitorPage(self)
        self.experimentPage = CSNSExperimentPage(self)

        self.addTab(self.scatteringPage, 'Scattering')
        self.addTab(self.tubePage, 'Tube')
        self.addTab(self.detectorPage, 'Detector')
        self.addTab(self.transmissionPage, 'Transmission')
        self.addTab(self.monitorPage, 'Monitor')
        self.addTab(self.experimentPage, 'Progress')
    
        self.currentChanged.connect(self.tabChange)

    def updateDiffractionSimulator(self):
        self.histogramPage.startDiffractionSimulator()

    def updateDataStreaming(self):
        self.histogramPage.startDataStreaming()

    def updateProton(self, threadID):
        self.experimentPage.startProtonSimulator()

    def getScatteringPath(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        path6 = []
        path7 = []
        path8 = []
        path9 = []
        path10 = []
        path11 = []
        path1 = '/SANS/workspace/MantidData/bank1/xy_image/x'
        path2 = '/SANS/workspace/MantidData/bank1/xy_image/y'
        path3 = '/SANS/workspace/MantidData/bank1/xy_image/value'
        path4 = '/SANS/workspace/MantidData/IQxy/x'
        path5 = '/SANS/workspace/MantidData/IQxy/y'
        path6 = '/SANS/workspace/MantidData/IQxy/counts'
        path7 = '/SANS/workspace/MantidData/IQ_raw/q'
        path8 = '/SANS/workspace/MantidData/IQ_raw/counts'
        _index = self.scatteringPage.normSelected()
        if _index == 0:
            path9 = '/SANS/workspace/MantidData/reduction/monitor/IQ/q'
            path10 = '/SANS/workspace/MantidData/reduction/monitor/IQ/counts'
        else:
            path9 = '/SANS/workspace/MantidData/reduction/PC/IQ/q'
            path10 = '/SANS/workspace/MantidData/reduction/PC/IQ/counts'
        path11 = '/SANS/workspace/MantidData/BeamCenter'
        return path1, path2, path3, path4, path5, path6, path7, path8, path9, path10, path11

    def getTubePath(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        _tube = self.tubePage.getTubeNum() 
        path1 = '/SANS/workspace/MantidData/xy_image/tube'+str(_tube)+'/x'
        path2 = '/SANS/workspace/MantidData/xy_image/tube'+str(_tube)+'/y'
        path3 = '/SANS/workspace/MantidData/xy_image/tube'+str(_tube)+'/z'
        path4 = '/SANS/workspace/MantidData/xy_image/tube'+str(_tube)+'/tof'
        path5 = '/SANS/workspace/MantidData/xy_image/tube'+str(_tube)+'/counts'
        return path1, path2, path3, path4, path5

    def getDetectorPath(self):
        path1 = []
        path2 = []
        path3 = []
        path1 = '/SANS/workspace/MantidData/IQxy/x'
        path2 = '/SANS/workspace/MantidData/IQxy/y'
        path3 = '/SANS/workspace/MantidData/IQxy/counts'
        return path1, path2, path3

    def getTransmissionPath(self):
        _index = self.transmissionPage.getCheckBoxIndex()
        path1 = '/SANS/workspace/MantidData/monitor2/wavelength'
        path2 = '/SANS/workspace/MantidData/monitor2/intensity'
        path3 = '/SANS/workspace/MantidData/monitor3/wavelength'
        path4 = '/SANS/workspace/MantidData/monitor3/intensity'
        if _index == 0:
            path5 = '/SANS/workspace/MantidData/raw/wavelength'
            path6 = '/SANS/workspace/MantidData/raw/transmission'
        else:
            path5 = '/SANS/workspace/MantidData/reduction/wavelength'
            path6 = '/SANS/workspace/MantidData/reduction/transmission'
        return path1, path2, path3, path4, path5, path6

    def getMonitorPath(self):
        monitorStatus = []
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        for i in range(len(self.monitorPage.monitorDock)):
            monitorStatus.append(self.monitorPage.monitorDock[i].pauseButton.text())
            path1.append('/SANS/workspace/MantidData/monitor'+str(i+1)+'/axis_x')
            path2.append('/SANS/workspace/MantidData/monitor'+str(i+1)+'/axis_y')
            path3.append('/SANS/workspace/MantidData/monitor'+str(i+1)+'/value')
            path4.append('/SANS/workspace/MantidData/monitor'+str(i+1)+'/tof')
            path5.append('/SANS/workspace/MantidData/monitor'+str(i+1)+'/counts')
        return monitorStatus, path1, path2, path3, path4, path5

    def getExperimentPath(self):
        path1 = []
        path2 = []
        path3 = []
        path1 = '/SANS/drone/proton_charge'
        path2.append('/SANS/workspace/MantidData/neutron_counts/time')
        path2.append('/SANS/workspace/MantidData/neutron_counts/value')
        path3.append('/SANS/workspace/MantidData/pulse_charge/time')
        path3.append('/SANS/workspace/MantidData/pulse_charge/value')        
        return path1, path2, path3
    
    def setStatus(self):
        self.tabChange()

    def tabChange(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        path6 = []
        path7 = []
        path8 = []
        path9 = []
        path10 = []
        path11 = []
        monitorStatus = []
        
        tabIndex = self.currentIndex()
        if tabIndex == 0:
            path1, path2, path3, path4, path5, path6, path7, path8, path9, path10, path11 = self.getScatteringPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2, 
                        "path3": path3, "path4": path4, "path5": path5, 
                        "path6": path6, "path7": path7, "path8":path8,
                        "path9": path9, "path10": path10, "path11": path11}
        elif tabIndex == 1:
            path1, path2, path3, path4, path5 = self.getTubePath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2, 
                        "path3": path3, 'path4': path4, 'path5': path5}
        elif tabIndex == 2:
            path1, path2, path3 = self.getDetectorPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2, "path3": path3}
        elif tabIndex == 3:
            path1, path2, path3, path4, path5, path6 = self.getTransmissionPath()
            kwargs = {'tabIndex': tabIndex, 'path1': path1, 'path2': path2,
                         'path3': path3, 'path4': path4, 'path5': path5, 'path6': path6}
        elif tabIndex == 4:
            monitorStatus, path1, path2, path3, path4, path5 = self.getMonitorPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2,
                        "path3": path3, "path4": path4, "path5": path5, "status": monitorStatus}
        elif tabIndex == 5:
            path1, path2, path3 = self.getExperimentPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2, "path3": path3}
       
        self.parent.setDataPath(kwargs)
