#!/usr/bin/python
# -*- coding: utf-8 -*-
from conf.constants import *
import time
import logging
import os.path
import io
import sys
from PyQt4 import QtCore, QtGui
from PyQt4.QtGui import QTextBlock, QTextCursor

'''
class logGUI():
    def __init__(self, parent, logwindow, loglevel):
        #super(logGUI, self).__init__(parent, logwindow, loglevel)
        self.logwindow=logwindow
        self.loglevel=loglevel
    
    def setLevel(self, loglevel):
        self.loglevel=loglevel

    def logWrite(self, message, loglevel=None):
        _d=time.strftime('%Y-%m-%d %H:%M:%S,%03d')
        if loglevel is None:
            _m=_d+" - "+self.loglevel+" - "+message
        else:
            _m=_d+" - "+loglevel+" - "+message
        self.logwindow.appendPlainText(_m)
'''
class logHandler(logging.Handler):

    def __init__(self, parent):
        super(logHandler, self).__init__()
        self.widget = QtGui.QPlainTextEdit(parent)
        self.widget.setReadOnly(True)

    def emit(self, record):
        msg = self.format(record)
        self.widget.appendPlainText(msg)
        
class LogWindow(QtGui.QDialog, logHandler):

    def __init__(self, parent=None):
        super(LogWindow, self).__init__(parent)

        self.logTextBox = logHandler(self)

        # You can format what is printed to text box

        formatter = \
            logging.Formatter('%(asctime)s - %(levelname)s - %(message)s'
                              )
        self.logTextBox.setFormatter(formatter)
        logging.getLogger().addHandler(self.logTextBox)

        # You can control the logging level
        logging.getLogger().setLevel(logging.INFO)

        layout = QtGui.QVBoxLayout(self)
        layout.addWidget(self.logTextBox.widget)
        self.setLayout(layout)

        '''
        if os.path.exists('./log/SANS.log'):
            with open("./log/SANS.log","w"):
                os.remove("./log/GPPD.log")
        _f=open("./log/SANS.log", "w")
        _f.close()
        '''

        logFileHandler = logging.FileHandler('./log/SANS.log')
        logFileHandler.setFormatter(formatter)
        logging.getLogger().addHandler(logFileHandler)
