from PyQt4 import QtGui, QtCore
import sys
import random
import time
import json
from model import jsonArray
import cStringIO
from PIL import Image
import base64
import numpy

class getCommand(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalStatus = QtCore.pyqtSignal(str)
    signalLog = QtCore.pyqtSignal(str)
 
    def __init__(self, parent, neonServer, commandPath, refreshTime):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.commandPath = commandPath
        self.refreshTime = refreshTime
        self.command=True
        self.commandLog = 0

    def pause(self):
        self.command=False
    
    @QtCore.pyqtSlot()
    def process(self):
        while True:
            if not self.command: break
            try:
                #i=random.randint(0,4)
                _command = self.neonServer.get(self.commandPath)
                if _command is None:
                    if self.commandLog == 0:
                        self.signalLog.emit("Empty command Data from NEON!")
                        self.commandLog += 1
                else:
                    try:
                        self.signalStatus.emit(_command)
                        #self.signalStatus.emit(self.mylist[i])#str(_command))
                    except:
                        pass
            except:
                pass
            try:
                time.sleep(self.refreshTime)
            except:
                pass
        self.finished.emit()            

    def set(self, command):
        self.command=command
    
    def get(self):
        return self.command

class getNeonData(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalProgress = QtCore.pyqtSignal(str)
    signalStatus = QtCore.pyqtSignal(object)
    signalMonitor = QtCore.pyqtSignal(object)
    signalExperiment = QtCore.pyqtSignal(object,object)
    signalLog = QtCore.pyqtSignal(str)

    def __init__(self, parent, neonServer, progressPath, protonPath, neutronPath, pulsePath, refreshTime):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.progressPath = progressPath
        self.protonPath = protonPath
        self.neutronPath = neutronPath
        self.pulsePath = pulsePath
        self.refreshTime = refreshTime
        self.started = True
        self.imgpath = None
        self.kwargs = {}
        self.tabIndex = 0
        self.monitorTOFPath = '/SANS/workspace/MantidData/monitor1/tof'
        self.monitorCountsPath = '/SANS/workspace/MantidData/monitor1/counts'
        self.monitorTOF=[]

        self.scatteringx = []
        self.scatteringy = []
        self.pidXaxis=[]
        self.xyXaxis=[]
        self.xyYaxis=[]
        for i in range(6):
            self.pidXaxis.append([])
            self.xyXaxis.append([])
            self.xyYaxis.append([])
        self.progressLog = 0
        self.monitorTOFLog = 0 
        self.monitorCountsLog = 0
        self.protonLog = 0
        self.neutronLog = 0
        self.scatteringLog = 0
        self.tubeLog = 0
        self.detectorLog = 0
        self.transmissionLog = 0
        self.monitorLog = 0
        self.expeLog = 0

    def __del__(self):
        self.wait()

    def pause(self):
        self.started=False

    def set(self, value):
        self.started=value

    def get(self):
        return self.started

    def resume(self):
        if not self.started:
            self.started = True

    @QtCore.pyqtSlot()
    def process(self):
        # progress setting in mainSet
        try:
            #get json date after json.dumps from neon
            progress = self.neonServer.get(self.progressPath)
            if progress is None:
                if self.progressLog == 0:
                    self.signalLog.emit("Empty progressBar Setting Data!")
                    self.progressLog += 1
            else:
                try:
                    self.signalProgress.emit(progress)
                except:
                    pass
        except:
            pass 

        # Monitor TOF in User Panel 
        try:
            _data = self.neonServer.get(self.monitorTOFPath)
            if _data is None:
                if self.monitorTOFLog == 0:
                    self.signalLog.emit("Empty Monitor TOF Data!")
                    self.monitorTOFLog += 1
            else:
                try:
                    _data = jsonArray.jsonDecoder(_data)
                    self.monitorTOF=_data
                except:
                    if self.monitorTOFLog < 2:
                        self.signalLog.emit("Incompleted Monitor TOF Data")
                        self.monitorTOFLog += 1
        except:
            pass

        while True:
            _data = None
            _started = self.get()
            if not _started:
                continue 
            # Monitor Counts in User Panel 
            try:
                _data = self.neonServer.get(self.monitorCountsPath)
            except:
                pass
            if _data is None:
                if self.monitorCountsLog == 0:
                    self.signalLog.emit("Empty Monitor Counts Data!")
                    self.monitorCountsLog += 1
            else:
                try:
                    _data = jsonArray.jsonDecoder(_data)
                    self.signalMonitor.emit(_data)
                except:
                    if self.monitorCountsLog < 2:
                        self.signalLog.emit("Incompleted Monitor Counts Data")
                        self.monitorCountsLog += 1
            
            # get Proton Charge and Neutron Counts in User
            _proton = None
            _neutron = None
            try:
                _proton = self.neonServer.get(self.protonPath)
                _neutron = self.neonServer.get(self.neutronPath)
            except:
                pass
            if _proton is None:
                if self.protonLog == 0:
                    self.signalLog.emit("Empty Proton Charge Data!")
                    self.protonLog += 1
            else:
                try:
                    _proton = jsonArray.jsonDecoder(_proton)
                except:
                    if self.protonLog < 2:
                        self.signalLog.emit("Incompleted Proton Charge  data")
                        self.protonLog += 1
            if _neutron is None:
                if self.neutronLog == 0:
                    self.signalLog.emit("Empty Neutron Counts Data!")
                    self.neutronLog += 1
            else:
                try:
                    _neutron = jsonArray.jsonDecoder(_neutron)
                except:
                    if self.neutronLog < 2:
                        self.signalLog.emit("Incompleted Neutron Counts data")
                        self.neutronLog+= 1
            try:
                self.signalExperiment.emit(_proton[-1][-1], _neutron)
            except:
                pass

            # get Tab index
            try:
                self.tabIndex = self.kwargs['tabIndex']
            except:
                pass
            # Scattering page
            if self.tabIndex == 0:
                value = []
                for i in range(len(self.kwargs)-1):
                    value.append([])
                for i in range(len(self.kwargs)-1):
                    if i == 0:
                        if self.scatteringx != []:
                            continue
                        else:
                            try:
                                _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                                if _data is None:
                                    if self.scatteringLog == 0:
                                        self.signalLog.emit("Empty path"+str(i+1)+" Data!")
                                        self.scatteringLog += 1
                                else:
                                    try:
                                        _data = jsonArray.jsonDecoder(_data)
                                        self.scatteringx = _data
                                    except:
                                        if self.scatteringLog < 2:
                                            self.signalLog.emit("Incompleted path"+str(i+1)+"Data!")
                                            self.scatteringLog += 1
                            except:
                                pass             
                            value[0]=self.scatteringx
                    elif i == 1:
                        if self.scatteringy != []:
                            continue
                        else:
                            try:
                                _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                                if _data is None:
                                    if self.scatteringLog == 0:
                                        self.signalLog.emit("Empty path"+str(i+1)+" Data!")
                                        self.scatteringLog += 1
                                else:
                                    try:
                                        _data = jsonArray.jsonDecoder(_data)
                                        self.scatteringy = _data
                                    except:
                                        if self.scatteringLog < 2:
                                            self.signalLog.emit("Incompleted path"+str(i+1)+"Data!")
                                            self.scatteringLog += 1
                            except:
                                pass
                            value[1]=self.scatteringy
                    else:
                        try:
                            _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                            if _data is None:
                                if self.scatteringLog == 0:
                                    self.signalLog.emit("Empty path"+str(i+1)+" Data!")
                                    self.scatteringLog += 1
                            else:
                                try:
                                    _data = jsonArray.jsonDecoder(_data)
                                except:
                                    if self.scatteringLog < 2:
                                        self.signalLog.emit("Incompleted path"+str(i+1)+"Data!")
                                        self.scatteringLog += 1
                            value[i]=_data
                        except:
                            pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Tube page
            elif self.tabIndex == 1:
                value = []
                for i in range(len(self.kwargs)-1):
                    value.append([])
                for i in range(len(self.kwargs)-1):
                    try:
                        _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                    except:
                        pass
                    if _data is None:
                        if self.tubeLog == 0:
                            self.signalLog.emit("Empty Tube Canvas Data!")
                            self.tubeLog += 1
                    else:
                        try:
                            _data = jsonArray.jsonDecoder(_data)
                        except:
                            if self.tubeLog < 2:
                                self.signalLog.emit("Incompleted Tube Canvas data")
                                self.tubeLog += 1
                    value[i] = _data
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Detector page
            elif self.tabIndex == 2:
                value = []
                for i in range(len(self.kwargs)-1):
                    value.append([])
                for i in range(len(self.kwargs)-1):
                    try:
                        _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                    except:
                        pass
                    if _data is None:
                        if self.detectorLog == 0:
                            self.signalLog.emit("Empty Detector Canvas Data!")
                            self.detectorLog += 1
                    else:
                        try:
                            _data = jsonArray.jsonDecoder(_data)
                        except:
                            if self.detectorLog < 2:
                                self.signalLog.emit("Incompleted Detector Canvas data")
                                self.detectorLog += 1
                    value[i] = _data
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Transmission page
            elif self.tabIndex == 3:
                value = []
                try:
                    for i in range(len(self.kwargs)-1):
                        _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                        if _data is None:
                            if self.transmissionLog == 0:
                                self.signalLog.emit("Empty Canvas Data!")
                                self.transmissionLog += 1
                        else:
                            try:
                                _data = jsonArray.jsonDecoder(_data)
                            except:
                                if self.transmissionLog < 2:
                                    self.signalLog.emit("Incompleted Canvas data")
                                    self.transmissionLog += 1
                        value.append(_data)
                except:
                    pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Monitor page
            elif self.tabIndex == 4:
                value = []
                _pause = []
                try:
                    _pause = self.kwargs['status']
                except:
                    pass
                for _ini in range(len(self.kwargs)-2):
                    value.append([])
                for i in range(len(self.kwargs)-2):
                    _array = []
                    for key in range(len(self.kwargs['path1'])):
                        _array.append([])
                    try:
                        for j in range(len(self.kwargs['path1'])):
                            if _pause[j]=='Pause':
                                _data = self.neonServer.get(self.kwargs['path'+str(i+1)][j])
                                if _data is None:
                                    if self.monitorLog == 0:
                                        self.signalLog.emit("Empty Canvas Data!")
                                        self.monitorLog += 1
                                else:
                                    try:
                                        _data = jsonArray.jsonDecoder(_data)
                                        _array[j] = _data
                                    except:
                                        if self.monitorLog < 2:
                                            self.signalLog.emit("Incompleted Canvas data")
                                            self.monitorLog += 1
                            else:
                                pass
                        value[i]=_array
                    except:
                        pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Experiment page
            elif self.tabIndex == 5:
                value = []
                for _ini in range(len(self.kwargs)-1):
                    value.append([])
                try:
                    for i in range(len(self.kwargs)-1):
                        _array = []
                        for key in range(len(self.kwargs['path1'])):
                            _array.append([])
                        for j in range(len(self.kwargs['path'+str(i+1)])):
                            _data = self.neonServer.get(self.kwargs['path'+str(i+1)][j])
                            if _data is None:
                                if self.expeLog == 0:
                                    self.signalLog.emit("Empty Canvas Data!")
                                    self.expeLog += 1
                            else:
                                try:
                                    _data = jsonArray.jsonDecoder(_data)
                                    _array[j] = _data
                                except:
                                    if self.expeLog < 2:
                                        self.signalLog.emit("Incompleted Canvas data")
                                        self.expeLog += 1
                        value[i] = _array
                except:
                    pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            try: 
                time.sleep(self.refreshTime)
            except:
                pass
        self.finished.emit()

    def setDataPath(self, kwargs):
        self.kwargs = kwargs

    def getTabIndex(self):
        return self.tabIndex

    def getMonitorTOF(self):
        return self.monitorTOF

    def getDetectorIndex(self):
        return self.parent.getDetectorIndex()

class workerThread(QtCore.QThread):
    def __init__(self, parent):
        super(workerThread, self).__init__(parent)

    def __del__(self):
        self.wait()

