# reduction without sensitivity and efficiency
#from mantid.simpleapi import *
import math
import numpy as np

#Spheres with uniform scattering length density
#scale (source intensity)  units: 1
#background  (source background)  units:cm-1
#sld  (scattering length density of layer)  units: 1e-6*AA-2
#sld_solvent  (scattering length density of solvent)  units: 1e-6*AA-2
#radius  (Sphere radius) units:AA

def Sphere_sphere(q,scale,sld,sld_solvent,radius):
    
    V=4.0/3.0*3.14*(radius**3) #Volume
    
    sld=sld*1e-6
    sld_solvent=sld_solvent*1e-6
    
    Delta_sld=sld-sld_solvent #contrast
    
    F1=scale/V
    F2=3*V*Delta_sld
    F3=math.sin(q*radius)-q*radius*math.cos(q*radius)
    F4=((q*radius)**3)
    #F5=background
    
    Iq=F1*((F2*F3/F4)**2)
    
    return Iq


#Right circular cylinder with uniform scattering length density
#scale (source intensity)  units: 1
#background  (source background)  units:cm-1
#sld  (scattering length density of layer)  units: 1e-6*AA-2
#sld_solvent  (scattering length density of solvent)  units: 1e-6*AA-2
#radius  (Cylinder radius) units:AA
#length  (Cylinder length) units:AA
#theta  (cylinder axis to beam angle) units:degree
#phi  (rotation about beam) units:degree
#only 1D model is considered
def Cylinder_cylinder_1D(q,scale,sld,sld_solvent,radius,length):
    V=3.14*(radius**2)*length
    
    sld=sld*1e-6
    sld_solvent=sld_solvent*1e-6
    
    Delta_sld=sld-sld_solvent #contrast
    
    dalpha=1/200*3.14
    Iq=0
    for alpha in np.arange(dalpha,3.14,dalpha):
        F1=scale*4*(Delta_sld**2)*V
        F2=math.sin(0.5*q*length*math.cos(alpha))/(0.5*q*length*math.cos(alpha))
        F31=math.sin(q*radius*math.sin(alpha))/((q*radius*math.sin(alpha))**2)
        F32=math.cos(q*radius*math.sin(alpha))/(q*radius*math.sin(alpha))
        F3=F31-F32
        F4=math.sin(alpha)*dalpha
        
        Iq=Iq+F1*F2*F3*F4
        
    
    return Iq



#Sphere_sphere default parameters
scale=1
sld=1
sld_solvent=6
radius=50


#Cylinder_cylinder default parameters
scale=1
sld=1
sld_solvent=6
radius=20
length=400
'''
theta=60
phi=60
'''


q=0.05

Iq_sphere=Sphere_sphere(q,scale,sld,sld_solvent,radius)
Iq_cylinder=Cylinder_cylinder_1D(q,scale,sld,sld_solvent,radius,length)

print ("%f\n" %Iq_sphere)  
print ("%f\n" %Iq_cylinder) 

