#!/usr/bin/env python
# -*- coding: utf-8 -*-

from sqlalchemy import Column, String, create_engine
from sqlalchemy.orm import sessionmaker
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy import create_engine, Table, Column, Integer, String, MetaData, ForeignKey
from config import config

Base = declarative_base()
class Record(Base):

    __tablename__ = 'BL01'

    id = Column(Integer, primary_key=True)
    beamline = Column(String(64), nullable=False)
    run = Column(String(64), nullable=False, index=True)
    ctrl = Column(Integer, nullable=False)
    daq = Column(Integer, nullable=False)
    monhis1 = Column(Integer, nullable=False)
    monhis2 = Column(Integer, nullable=False)
    monhis3 = Column(Integer, nullable=False)
    monevt1 = Column(Integer, nullable=False)
    monevt2 = Column(Integer, nullable=False)
    monevt3 = Column(Integer, nullable=False)
    nexus = Column(Integer, nullable=False)
    begin = Column(String(64), nullable=True)
    end = Column(String(64), nullable=True)
    stat = Column(Integer, nullable=False, index=True)

    def __repr__(self):
        return '%s(%r)' % (self.__class__.__name__, self.run)

def getDBsession():
    host = config.get('mysqldb','server')
    db = config.get('mysqldb','database')
    user = config.get('mysqldb','user')
    passwd = config.get('mysqldb','password')

    engine = create_engine('mysql+mysqlconnector://' + user + ':' + passwd + '@' + host + '/' + db)
    return sessionmaker(bind=engine)()

