#!/usr/bin/env python
# -*- coding: utf-8 -*-

import ConfigParser, os

class ConfigSingleton(object):
    __instance = None
    def __new__(cls, configFile):
        if ConfigSingleton.__instance is None:
            ConfigSingleton.__instance = object.__new__(cls)
        ConfigSingleton.__instance.config = ConfigParser.RawConfigParser()
        ConfigSingleton.__instance.config.readfp(open(configFile))
        return ConfigSingleton.__instance

# Load configuration file: ~/conf.ini
config = ConfigSingleton('conf/conf.ini').config
