#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import time
import logging
import logging.config
import logging.handlers
import json

DEFAULT_DATETIME_FORMAT = '%Y-%m-%dT%H:%M:%S.000+08:00'

def getFileCreationDate(_file, dt_format = DEFAULT_DATETIME_FORMAT):
    stat = os.stat(_file)
    try:
        _tmp = stat.st_birthtime
    except AttributeError:
        _tmp = stat.st_mtime

    return time.strftime(dt_format, time.localtime(int(_tmp)))

# Size in byte
def getFileSize(_file):
    return int(os.stat(_file).st_size)

def getFileName(_file):
    return os.path.basename(_file)

def getLogger(_configFile):
    configDict=None
    with open(_configFile, 'r') as fp:
        configDict = json.load(fp)
    logging.config.dictConfig(configDict)
    return logging.getLogger()

logger = getLogger('conf/logging.json')
