#!/usr/bin/python
# -*- coding: utf-8 -*-

# author: H.L. TIAN 2017

# import Sniper

import DroNECore
import DroNECore.PyIncident as PI
import CtrlSvc.PushMatrixIncident as PMI
import CtrlSvc.PushHistIncident as PHI
import CtrlSvc.HeartBeatIncident as HBI
import CtrlSvc.NeonRPCIncident as NRI
import CtrlSvc.NeonRPCTask as NRT
import CtrlSvc.NeonUpdateDataTask as NUT
import NEON
import json
import redis
import os

SANSgroup = {}
SANSgroup['module1'] = 'module10'
SANSgroup['module2'] = 'module9'
SANSgroup['module3'] = 'module8'
SANSgroup['module4'] = 'module7'
SANSgroup['module5'] = 'module6'
SANSgroup['module6'] = 'module5'
SANSgroup['module7'] = 'module4'
SANSgroup['module8'] = 'module3'
SANSgroup['module9'] = 'module2'
SANSgroup['module10'] = 'module1'


class RedisRemoteData:

    def __init__(self, ip, path):
        from redis.sentinel import Sentinel
        sentinel = Sentinel(ip, socket_timeout=10)
        self.server = sentinel.master_for('neonmaster',
                socket_timeout=200, password='sanlie;123', db=0)
        self.path = path

    def setData(self, data):
        self.data = data

    def dump(self):
        self.server.set(self.path, self.data)

    def getData(self):
        return self.data

    def load(self):
        self.data = self.server.get(self.path)


def App(in_module='', in_redisip='', in_cron=1):
    m_modulename = in_module  # 'module131'
    m_redisip = in_redisip  # '10.1.33.141'
    m_cron = in_cron  # 15

    from xml.etree import ElementTree as ET
    root = ET.parse('configure.xml')
    tof = root.find('tofInformation')
    factor = 80  # 25ns to 1us
    m_tofstart = int(tof.attrib['tofstart']) * factor
    m_tofstep = int(tof.attrib['tofstep']) * factor
    m_tofbins = int(tof.attrib['tofbin'])

    for item in root.findall('type/component'):
        if m_modulename == item.attrib['name']:
            m_moduleinfo = item.attrib

    path = '/SANS/workspace/detector/' + SANSgroup[m_modulename]

    m_taskMatrix = RedisRemoteData(m_redisip, path + '/value')
    m_taskTOF = RedisRemoteData(m_redisip, path + '/tof')
    m_taskPID = RedisRemoteData(m_redisip, path + '/pid')
    toflist = [m_tofstep + i * m_tofstep for i in xrange(m_tofbins + 1)]
    m_taskTOF.setData(json.dumps(toflist))
    m_taskTOF.dump()

    m_taskheartbeat = RedisRemoteData(m_redisip,
            '/SANS/heartbeat/detector/' + m_modulename)
    m_taskheartbeat.setData(HBI.HeartBeatCronIncident.encodeHeartBeat(status='running'
                            , hit=0, event=0, pulse=0, idx=os.getpid()))
    m_taskheartbeat.dump()

    idstart = int(m_moduleinfo['idstart'])
    idsize = int(m_moduleinfo['pixels'])
    pidlist = [i + idstart for i in xrange(idsize)]
    m_taskPID.setData(json.dumps(pidlist))
    m_taskPID.dump()

    m_configure = {'pidstart': idstart, 'pidsize': idsize}
    task = DroNECore.DroNEOnline('task')
    task.asTop()
    task.setLogLevel(2)

    # # ===========================

    m_neonRedis = NEON.Neon.NeonRedisSentinel(
        m_redisip,
        i_socket_timeout=10,
        master_name='neonmaster',
        master_timeout=120,
        master_password='sanlie;123',
        idb=0,
        isWritable=True,
        )
    servpob = NEON.Neon.NeonService.POBox(m_neonRedis,
            '/SANS/process/detector', 'server/' + m_modulename)
    servrpc = NEON.Neon.NeonService.NeonRPC(sendPOBox=servpob,
            recvPOBox=servpob, isServer=True)
    nr = NRT.NeonRPCTask('NeonRPC', servrpc, remotedata=m_taskheartbeat)

    import CtrlSvc
    ct = DroNECore.CtrlTask('ctrl')
    pi = PMI.PushMatrixCronIncident('PushMatrix', cron=m_cron,
                                    repeatable=True,
                                    remotedata=m_taskMatrix,
                                    configure=m_configure)
    hi = HBI.HeartBeatCronIncident('HeartBeat', cron=2,
                                   repeatable=True,
                                   remotedata=m_taskheartbeat)
    ni = NRI.NeonRPCCronIncident('NeonRPC', cron=1, repeatable=True)
    ct.add(hi)
    ct.add(ni)
    ct.add(pi)

    # # ===========================

    nu = NUT.NeonUpdateDataTask('UpdateRemoteData',
                                remotedata=m_taskMatrix,
                                configure=m_configure)

    # # ===========================

    import DataSvc
    task.property('svcs').append('SANSDataSvc/DataSvc')
    task.property('svcs').append('CtrlSvc')
    task.property('svcs').append('He3TRawDataInputSvcV02/DataInputSvc')
    task.property('svcs').append('DimRecvSvc/DataProvideSvc')

    iDat = task.find('DataSvc')
    iSvc = task.find('DataInputSvc')
    iPvd = task.find('DataProvideSvc')

    dimsrvname = 'dimserver/' + m_moduleinfo['server']

    iPvd.property('DataSize').set(1000000)
    iPvd.property('DimServerName').set(dimsrvname)
    iSvc.property('BuffSize').set(1000000)

    iSvc.show()
    iPvd.show()

    import Algorithms
    task.property('algs').append('SANSHe3TRecAlg')
    task.property('algs').append('SANSHe3TMapAlg')
    task.property('algs').append('RunningInfAlg')

    # task.property("algs").append("DumpAlg")

    iRun = task.find('RunningInfAlg')
    iRun.property('TofStart').set(m_tofstart)
    iRun.property('TofBins').set(m_tofbins)
    iRun.property('TofStep').set(m_tofstep)

    iMap = task.find('SANSHe3TMapAlg')

    # iMap.property("ConfigFileName").set("configure.xml")

    iMap.show()

    task.setEvtMax(-1)
    task.initialize()
    task.run()


if __name__ == '__main__':
    App(in_module='template', in_redisip=[('10.1.34.116', 9001)],
        in_cron=10)
