import sys
import os
import epics
from epics.ca import CAThread, withInitialContext
import redis
import datetime
import time
import random
import numpy as np
from scipy import exp
from scipy.optimize import leastsq
from scipy.optimize import curve_fit
import matplotlib.pyplot as plt
import matplotlib.animation as anim
from drawnow import drawnow
import warnings
import signal
import json
from Queue import Queue
from threading import Thread
import threading
import logging
import multiprocessing
import paramiko

write = sys.stdout.write
flush = sys.stdout.flush

import warnings
warnings.filterwarnings("ignore")

class getRedisServer():
    def __init__(
        self,
        ip,
        port,
        timeout,
        ):

        self.status=False
        client=False
        self.server=None
        begin=time.time()
        while True:
            if not self.server:
                self.server = redis.Redis(host=ip, port=port, password="sanlie;123", db=0, socket_connect_timeout=1.0)
            else:
                try:
                    client=self.server.client_list()
                except (redis.exceptions.ConnectionError):
                    logging.warning("Attempt to connect NEON again!")
                if client:
                    self.status = True
                    logging.info("NEON connected")
                    break
                else:
                    #logging.exception("NEON not available")
                    logging.error("NEON not available")
                if time.time()-begin>timeout:
                    logging.info("NEON connect timeout")
                    break

    def getStatus(self):
        return self.status

    def getServer(self):
        return self.server

class getNeonServer():
    def __init__(
        self,
        ip,
        port,
        timeout,
        ):

        self.status=False
        client=False
        self.server=None
        begin=time.time()
        while True:
            if not self.server:
                self.server = NEON.Neon.NeonRedis(host=ip, port=port, password="sanlie;123", db = 0, isWritable = True)
            else:
                try:
                    client=self.server.client_list()
                except (redis.exceptions.ConnectionError):
                    logging.warning("Attempt to connect NEON again!")
                if client:
                    self.status = True
                    logging.info("NEON connected")
                    break
                else:
                    #logging.exception("NEON not available")
                    logging.error("NEON not available")
                if time.time()-begin>timeout:
                    logging.info("NEON connect timeout")
                    break

    def getStatus(self):
        return self.status

    def getServer(self):
        return self.server

class getEpicsServer():
    def __init__(
        self,
        pvCommand,
        pvStatus,
        timeout,
        ):
        epics.ca.use_initial_context()

        self.status=False
        client=False

        self.epicsCommand = None
        self.epicsStatus = None
        begin=time.time()
        while True:
            if not client:
                if time.time()-begin>timeout:
                    self.status=False
                    logging.info("EPICS connect timeout")
                    break
                else:
                    try:
                        self.epicsCommand = epics.PV(pvCommand)
                        self.epicsStatus = epics.PV(pvStatus)
                        print self.epicsCommand.get()
                        print self.epicsStatus.get()
                        client=True
                    except:
                        logging.warning("Attempt to connect EPICS again!")


                    if client:
                        self.status=True
                        logging.info("EPICS connected")
                        break

    def getStatus(self):
        return self.status

    def getServer(self):
        return self.epicsCommand, self.epicsStatus

class getSshServer():
    def __init__(self, ip, user, retry=5):
        self.server = None
        self.status=False

        for i in range(retry):
            if not self.server:
                try:
                    _client = paramiko.SSHClient()
                    _client.load_system_host_keys()    
                #ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
                    _client.connect(ip, username=user)
                    #_client = _client.get_transport()
                    #_client = _client.open_session()
                    self.status=True
                    self.server=_client
                    break
                except paramiko.AuthenticationException:
                    print("Authentication failed, %s" % ip)
                except:
                    print("Attempt to connect NEON again, %s" % ip)
                time.sleep(1.0)

    def getStatus(self):
        return self.status

    def getServer(self):
        return self.server

class setHeartbeat(threading.Thread):

   def __init__(
        self,
        pvname,
        refreshtime,
        ):
        threading.Thread.__init__(self)

        self.pvname=epics.PV(pvname)
        self.refreshtime=refreshtime

   def setStatus(self, _status):
	self.status=_status

   def getStatus(self):
	return self.status
   
   def process(self):
        #_data={'timestamp':time.strftime('%Y-%m-%d %H:%M:%S')}
        #self.pvname.put(json.dumps(_data))
        _data=time.strftime('%Y-%m-%d %H:%M:%S')
        self.pvname.put(_data, use_complete=True)
        #print self.pvname.get()

   def run(self):
        while True:
            try:
	        self.process()
	    except:
		pass
            time.sleep(self.refreshtime)

class setStatus(threading.Thread):

   def __init__(
        self,
        pvname,
        refreshtime,
        ):
        threading.Thread.__init__(self)

        self.status='WAITING'
        self.pvname=epics.PV(pvname)
        self.refreshtime=refreshtime

   def setStatus(self, _status):
        self.status=_status

   def getStatus(self):
        return self.status

   def process(self):
        self.pvname.put(self.getStatus(), use_complete=True)
        #print self.pvname.get()

   def run(self):
        while True:
            try:
                self.process()
            except:
                pass
            time.sleep(self.refreshtime)

class getEpicsCommand(threading.Thread):
#class getEpicsCommand(multiprocessing.Process):
    def __init__(self, redisServer, epicsStatus):
        #multiprocessing.Process.__init__(self)
        threading.Thread.__init__(self)
        epics.ca.use_initial_context()
     
        self.redisServer = redisServer
        self.epicsStatus = epicsStatus

        self.pvCommand=epics.PV('EXP_IB1_GP:soft:cmd')
        self.redisPath="/GPPD/control/command"

        self.MYstatusList=["waiting", "unconfigured", "configuring", "ready", "running", "paused", "error"]
	    
        self.lastTime="notupdated"
        print self.lastTime
        self.thisTime="notupdated"

        redisServer.set(self.redisPath, json.dumps(6))

        for i in range(50):
            mantidStatus = self.getMantidStatus()
            pilotStatus = self.getPilotStatus()
            if pilotStatus==1 and mantidStatus==1:
                _status="INITIALIZED"
                self.epicsStatus.put(_status)
                break
            else:
                print "Waiting: pilot status, ", self.MYstatusList[pilotStatus]
                print "Waiting: mantid status, ", self.MYstatusList[mantidStatus]
       
        #self.epicsCommand.add_callback(self.setCommand)

    #def setCommand(self, pvname=None, value=None, char_value=None, timestamp=None, **kw):
    def setCommand(self, char_value=None, **kw):
	    self.epicsQueue.put(char_value)

    def getDroneStatus(self):
        droneStatus = self.redisServer.get(self.droneHeartBeat)
        droneStatus=json.load(droneStatus)['status']
        droneStatus=json.load(droneStatus)['timestamp']
        return droneStatus

    def getMantidStatus(self):
        try:
            self.mantidHeartBeat='/GPPD/heartbeat/mantid'
            mantidStatus = self.redisServer.get(self.mantidHeartBeat)
            mantidStatus=json.loads(mantidStatus)['status']
        except:
            mantidStatus=0

        return mantidStatus

    def getPilotStatus(self):
        try:
            self.pilotHeartBeat='/GPPD/heartbeat/pilot'
            pilotStatus = self.redisServer.get(self.pilotHeartBeat)
            pilotStatus=json.loads(pilotStatus)['status']
        except:
	        pilotStatus=0

        return pilotStatus

    def getEpicsConfigure(self):
        try:
            run_no=int(epics.caget('EXP_IB1_GP:soft:run_no'))
            print run_no
        except:
            run_no="unknown"

        try:
            user_id=epics.caget('EXP_IB1_GP:soft:user_id')
            print user_id
        except:
            user_id="unknown"
        try:
            proposal_id=epics.caget('EXP_IB1_GP:soft:proposal_id')
            print proposal_id
        except:
            proposal_id="unknown"

        _tmin=4000
        _tmax=40000
        _bin=100.0
        ntof=int((_tmax-_tmin)/_bin)
        tofmantid=np.zeros(ntof+1)
        for i in range(ntof):
            tofmantid[i]=int(_tmin+i*_bin-0.5*_bin)
        tofmantid[ntof]=int(_tmin+ntof*_bin-0.5*_bin)

        _configure={}
        _configure['runNo']=run_no
        _configure['userID']=user_id
        _configure['proposalID']=proposal_id
        _configure['tof']=tofmantid.tolist()
        _configure=json.dumps(_configure, ensure_ascii=False)
        print _configure
        self.redisServer.set("/GPPD/control/configure", _configure)

    def run(self):
        while True:
            mantidStatus = self.getMantidStatus()
            pilotStatus = self.getPilotStatus()
            if pilotStatus==6:
                print "ERROR: pilot failed."
                self.epicsStatus.put("ERROR")
                continue
            elif mantidStatus==6:
                print "ERROR: mantid failed."
                self.epicsStatus.put("ERROR")
                continue
            else:
                pass

            try:
                self.thisTime=self.pvCommand.timestamp
            except:
                continue

            if self.lastTime==self.thisTime:
                continue
            else:
                char_value=self.pvCommand.char_value
                self.lastTime=self.thisTime
            
            #char_value = self.epicsQueue.get()
            write('Receive: (%s)\n' % (char_value))
            char_value=int(char_value)
            if char_value == 0:
                _value=0
                #write('Receive: (%s): %s\n' % (time.strftime("%Y-%m-%d %H:%M:%S",time.localtime(timestamp)), char_value))
                self.getEpicsConfigure()
                redisServer.set(self.redisPath, json.dumps(_value))
                while True:
                    mantidStatus = self.getMantidStatus()
                    pilotStatus = self.getPilotStatus()
                    if pilotStatus==3 and mantidStatus==3:
                        _status="READY"
                        self.epicsStatus.put(_status)
                        print "CONF OK"
                        break
                    else:
                        print "Waiting: pilot status, ", self.MYstatusList[pilotStatus]
                        print "Waiting: mantid status, ", self.MYstatusList[mantidStatus]
                    time.sleep(0.1)

            elif char_value == 1:
                mantidStatus = self.getMantidStatus()
                pilotStatus = self.getPilotStatus()
                if pilotStatus!=1 or mantidStatus!=1:
                    _value=1
                    redisServer.set(self.redisPath, json.dumps(_value))
                    while True:
                        mantidStatus = self.getMantidStatus()
                        pilotStatus = self.getPilotStatus()
                        if pilotStatus==1 and mantidStatus==1:
                            print "Unconfigure OK"
                            break
                        else:
                            print "Waiting: pilot status, ", self.MYstatusList[pilotStatus]
                            print "Waiting: mantid status, ", self.MYstatusList[mantidStatus]
                        time.sleep(0.1)

                self.getEpicsConfigure()
                redisServer.set(self.redisPath, json.dumps(0))
                while True:
                    mantidStatus = self.getMantidStatus()
                    pilotStatus = self.getPilotStatus()
                    if pilotStatus==3 and mantidStatus==3:
                        print "Ready OK"
                        break
                    else:
                        print "Waiting: pilot status, ", self.MYstatusList[pilotStatus]
                        print "Waiting: mantid status, ", self.MYstatusList[mantidStatus]
                    time.sleep(0.1)

                _value=2
                redisServer.set(self.redisPath, json.dumps(_value))
                while True:
                    mantidStatus = self.getMantidStatus()
                    pilotStatus = self.getPilotStatus()
                    if pilotStatus==4 and mantidStatus==4:
                        _status="RUNNING"
                        self.epicsStatus.put(_status)
                        print "START OK"
                        break
                    else:
                        print "Waiting: pilot status, ", self.MYstatusList[pilotStatus]
                        print "Waiting: mantid status, ", self.MYstatusList[mantidStatus]
                    time.sleep(0.1)

            elif char_value == 2:
                _value=5
                redisServer.set(self.redisPath, json.dumps(_value))
                while True:
                    mantidStatus = self.getMantidStatus()
                    pilotStatus = self.getPilotStatus()
                    if pilotStatus==3 and mantidStatus==3:
                        _status="INITIALIZED"
                        self.epicsStatus.put(_status)
                        print "STOP OK"
                        break
                    time.sleep(0.1)

                redisServer.set(self.redisPath, json.dumps(1))
                while True:
                    mantidStatus = self.getMantidStatus()
                    pilotStatus = self.getPilotStatus()
                    if pilotStatus==1 and mantidStatus==1:
                        _status="INITIALIZED"
                        self.epicsStatus.put(_status)
                        print "STOP OK"
                        break
                    time.sleep(0.1)
            else:
                write('Warning: invalid command (%s)\n' % (char_value) )
                pass

            time.sleep(0.5)

if __name__=="__main__":
    print "Welcome to CockPit!"
    # ==================================================
    # connect Redis
    ip="10.1.33.141"
    port=9000
    timeout=10
    myredis=getRedisServer(ip, port, timeout)
    redisServer=myredis.getServer()
    print "INFO: Redis Connected."

    # ==================================================
    # connect Epics
    pvCommand = "EXP_IB1_GP:soft:cmd"
    pvStatus = "EXP_IB1_GP:soft:online_stat"
    myepics=getEpicsServer(pvCommand, pvStatus, timeout)
    epicsCommand, epicsStatus = myepics.getServer()
    print "INFO: Epics Connected."

    # ==================================================
    threadGetEpics = getEpicsCommand(redisServer, epicsStatus)
    threadGetEpics.setDaemon(True)
    threadGetEpics.start()
    time.sleep(0.01)

    threadGetEpics.join()
