import sys
import os
import epics
from epics.ca import CAThread, withInitialContext
import redis
import neon
import datetime
import time
import random
import numpy as np
import warnings
import signal
import json
from Queue import Queue
from threading import Thread
import threading
import logging
import multiprocessing
import fcntl
import logging

#write = sys.stdout.write
#flush = sys.stdout.flush

#import warnings
#warnings.filterwarnings("ignore")

logger = logging.getLogger('SANScockpit')
hdlr = logging.FileHandler(os.getcwd()+'/SANScockpit.log')
formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
hdlr.setFormatter(formatter)
logger.addHandler(hdlr)
logger.setLevel(logging.DEBUG)

fh=0
def run_once():
    global fh
    fh=open(os.path.realpath(__file__),'r')
    try:
        fcntl.flock(fh,fcntl.LOCK_EX|fcntl.LOCK_NB)
    except:
        os._exit(1)

def getTime():
    return time.strftime('%Y-%m-%d %H:%M:%S')

class getRedisServer():

   def __init__(
        self,
        ip,
        passwd,
        timeout,
        ):

        from redis.sentinel import Sentinel

        self.status=False
        self.redisWrite=None
        self.redisRead=None
        begin=time.time()
        while True:
            if self.redisWrite is None:
                #self.server = redis.Redis(host=ip, port=port, password=passwd, db=0, socket_connect_timeout=1.0)
                sentinel = Sentinel(ip, socket_timeout=0.1)
                try:
                    self.redisWrite=sentinel.master_for('neonmaster', socket_timeout=30, password=passwd)
                    self.redisRead=sentinel.slave_for('neonmaster', socket_timeout=30, password=passwd)
                except (redis.exceptions.ConnectionError):
                    logger.error("Redis exception")
                if self.redisWrite is not None:
                    if self.redisRead is None: self.redisRead=self.redisWrite
                    self.status = True
                    logger.info("Redis connected")
                    break
                else:
                    logger.error("Redis falied")
                if time.time()-begin>timeout:
                    logger.warning("Reids timeout")
                    break

   def getStatus(self):
        return self.status

   def getRedisWrite(self):
        return self.redisWrite

   def getRedisRead(self):
        return self.redisRead

class getNeonServer():
    def __init__(
        self,
        ip,
        port,
        timeout,
        ):

        self.status=False
        client=False
        self.server=None
        begin=time.time()
        while True:
            if not self.server:
                self.server = neon.Neon.NeonRedis(host=ip, port=port, password="sanlie;123", db = 0, isWritable = True)
            else:
                try:
                    client=self.server.client_list()
                except (redis.exceptions.ConnectionError):
                    logger.warning("Attempt to connect NEON again!")
                if client:
                    self.status = True
                    logger.info("NEON connected")
                    break
                else:
                    logger.error("NEON not available")
                if time.time()-begin>timeout:
                    logger.warning("NEON connect timeout")
                    break

    def getStatus(self):
        return self.status

    def getServer(self):
        return self.server

class getEpicsServer():
    def __init__(
        self,
        retry,
        ):
        epics.ca.use_initial_context()

        pvCommand = "EXP_IB2_SQ:soft:ctrl_cmd"
        pvStatus = "EXP_IB2_SQ:soft:online_stat"

        self.status=False

        self.epicsCommand = None
        self.epicsStatus = None
        
        for i in range(int(retry)):
            if not self.epicsCommand:
                try:
                    self.epicsCommand = epics.PV(pvCommand)
                    self.epicsStatus = epics.PV(pvStatus)
                    self.status=True
                    logger.info("EPICS connected")
                    break
                except:
                    logger.warning("EPICS retry")
            time.sleep(0.2)

    def getStatus(self):
        return self.status

    def getServer(self):
        return self.epicsCommand, self.epicsStatus

class getSshServer():
    def __init__(self, ip, user, retry=5):
        self.server = None
        self.status=False

        for i in range(retry):
            if not self.server:
                try:
                    _client = paramiko.SSHClient()
                    _client.load_system_host_keys()    
                    #ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
                    _client.connect(ip, username=user)
                    #_client = _client.get_transport()
                    #_client = _client.open_session()
                    self.status=True
                    self.server=_client
                    break
                except paramiko.AuthenticationException:
                    logger.warning("Authentication failed, %s" % ip)
                except:
                    logger.warning("Attempt to connect NEON again, %s" % ip)
                time.sleep(1.0)

    def getStatus(self):
        return self.status

    def getServer(self):
        return self.server

class getDroneServer():
    def __init__(self, ip, module):
        self.module = module
        _ssh=getSshServer('10.1.33.143', 'drone', 1)
        _sshServer = _ssh.getServer()
        myssh.append(_ssh1Server)
        myssh.append(_ssh2Server)
        myssh.append(_ssh3Server)
        logger.info("ssh Connected")

        # ==================================================
        #start drone
        _cmd='nohup /home/drone/Workspace/drone/daqrun/onlinedim.py '+group1[0]+' >'+'/home/drone/Workspace/drone/daqrun/log &'
        _cmd='/home/drone/Workspace/drone/daqrun/module131'
        _cmd='/home/drone/Workspace/drone/daqrun/1'
        stdin, stdout, stderr = myssh[0].exec_command(_cmd)
        #print myssh[0].get_transport().open_session().exec_command('')
        #transport = myssh[0].get_transport()
        #transport.set_keepalive(5) 
        stdin, stdout, stderr = myssh[0].exec_command('')

        #stdin, stdout, stderr = transport.open_session().exec_command(_cmd)
        logger.debug(stdout.readlines())

        pass

    def clear(self):
        pass

    def start(self):
        pass
    
    def stop(self):
        _cmd='pkill -9 -u drone '+self.module
        stdin, stdout, stderr = self.myssh.exec_command(_cmd)
        _cmd='pgrep -u drone '+self.module
        for i in range(10):
            stdin, stdout, stderr = self.myssh.exec_command(_cmd)
            print stdin 
            print stdout 
            print stderr
            time.sleep(0.3)

class setHeartbeat(threading.Thread):

    def __init__(
        self,
        refreshtime,
        ):
        threading.Thread.__init__(self)
        pvHeart = "EXP_IB2_SQ:soft:analyse_hb"
        self.pvname=epics.PV(pvHeart)
        self.refreshtime=refreshtime


    def setStatus(self, _status):
        self.status=_status

    def getStatus(self):
        return self.status

    def process(self):
        self.pvname.put(getTime(), use_complete=True)

    def run(self):
        while True:
            try:
                self.process()
            except:
                pass
            time.sleep(self.refreshtime)

class setStatus(threading.Thread):

   def __init__(
        self,
        pvname,
        refreshtime,
        ):
        threading.Thread.__init__(self)

        self.status='WAITING'
        self.pvname=epics.PV(pvname)
        self.refreshtime=refreshtime

   def setStatus(self, _status):
        self.status=_status

   def getStatus(self):
        return self.status

   def process(self):
        self.pvname.put(self.getStatus(), use_complete=True)

   def run(self):
        while True:
            try:
                self.process()
            except:
                pass
            time.sleep(self.refreshtime)

class getEpicsCommand(threading.Thread):
    def __init__(self, redisServer, epicsStatus):
        threading.Thread.__init__(self)
        epics.ca.use_initial_context()

        self.redisServer = redisServer
        self.epicsStatus = epicsStatus

        self.pvCommand=epics.PV('EXP_IB2_SQ:soft:ctrl_cmd')
        self.redisPath="/SANS/control/command"
        
        self.SANSstatusList=['INITIALIZED', 'READY', 'RUNNING']
        self.SANScommandList=["CONF", "START", "STOP", "EXIT", "CANCEL"]
        self.MYstatusList=["waiting", "unconfigured", "configuring", "ready", "running", "paused", "error"]
        self.MYcommandList=["configure", "unconfigure", "start", "pause", "resume", "stop", "abort"]

        self.mantidHeartBeat='/SANS/heartbeat/mantid'
        self.pilotHeartBeat='/SANS/heartbeat/pilot'

        logger.debug("Initializing...")
        self.setTOF()
        try:
            self.getEpicsConfigure()
        except:
            pass
        logger.debug("Initialized!!!")
        
        self.lastTime="-"
        self.thisTime="-"

        self.setCommand(6, 1, 0, -1)

    def setCommand(self, cmd, stat, epics, retry):
        success=False

        cmd=int(cmd)
        stat=int(stat)
        epics=int(epics)
        retry=int(retry)
        if epics!=-1: _status=self.SANSstatusList[epics]
        self.redisServer.set("/SANS/control/command", json.dumps(cmd))

        _count=-1
        while True:
            if retry!=-1:
                _count+=1
                if _count > retry:
                    success=False
                    break

            mantidStatus = self.getMantidStatus()
            pilotStatus = self.getPilotStatus()
            if pilotStatus==stat and mantidStatus==stat:
                logger.debug("pilot & mantid, %s" % self.MYstatusList[pilotStatus])
                if epics!=-1:
                    self.epicsStatus.put(_status)
                    logger.debug("Tell epics, %s" % self.SANSstatusList[epics])
                
                success=True
                break
            else:
                logger.debug("   Waiting for, %s" % self.MYstatusList[stat])
                logger.debug("   pilot,  %s" % self.MYstatusList[pilotStatus])
                logger.debug("   mantid, %s" % self.MYstatusList[mantidStatus])
            time.sleep(0.5)

        return success

    def getDroneStatus(self):
        droneStatus = self.redisServer.get(self.droneHeartBeat)
        droneStatus=json.load(droneStatus)['status']
        droneStatus=json.load(droneStatus)['timestamp']
        return droneStatus

    def getMantidStatus(self):
        try:
            mantidStatus = self.redisServer.get(self.mantidHeartBeat)
            mantidStatus=json.loads(mantidStatus)['status']
        except:
            mantidStatus=0

        return mantidStatus

    def getPilotStatus(self):
        pilotStatus = self.redisServer.get(self.pilotHeartBeat)
        json.loads(pilotStatus)['status']
        try:
            pilotStatus = self.redisServer.get(self.pilotHeartBeat)
            pilotStatus=json.loads(pilotStatus)['status']
        except:
            pilotStatus=0

        return pilotStatus

    def setTOF(self):
        _tmin=4000
        _tmax=40000
        _bin=100.0
        ntof=int((_tmax-_tmin)/_bin)
        self.tofmantid=np.zeros(ntof+1)
        for i in range(ntof+1):
            self.tofmantid[i]=int(_tmin+(i-1)*_bin-0.5*_bin)

        #_json=jsonArray.jsonEncoder(self.tofmantid.tolist())
        #self.redisServer.set("/SANS/workspace/detector/module01/tof", _json)

    def getEpicsConfigure(self):
        try:
            run_no=int(epics.caget('EXP_IB2_SQ:soft:run_no'))
        except:
            run_no="unknown"

        try:
            user_id=epics.caget('EXP_IB2_SQ:soft:user_id')
        except:
            user_id="unknown"

        try:
            proposal_id=epics.caget('EXP_IB2_SQ:soft:proposal_id')
        except:
            proposal_id="unknown"

        _configure={}
        _configure['runNo']=run_no
        _configure['userID']=user_id
        _configure['proposalID']=proposal_id
        _configure['tof']=self.tofmantid.tolist()
        _configure=json.dumps(_configure, ensure_ascii=False)
        self.redisServer.set("/SANS/control/configure", _configure)
        logger.info("Set configure, %d" % run_no)

    def run(self):
        while True:
            mantidStatus = self.getMantidStatus()
            pilotStatus = self.getPilotStatus()
            if pilotStatus==6:
                logger.error("pilot failed")
                self.epicsStatus.put("ERROR")
                continue
            elif mantidStatus==6:
                logger.error("mantid failed")
                self.epicsStatus.put("ERROR")
                continue
            else:
                pass

            try:
                self.thisTime=self.pvCommand.timestamp
            except:
                continue

            if self.lastTime==self.thisTime:
                continue
            else:
                #char_value=self.pvCommand.get()
                try:
                    _tmp=int(epics.caget('EXP_IB2_SQ:soft:ctrl_cmd'))
                    char_value=_tmp
                    self.lastTime=self.thisTime
                except:
                    continue            

            logger.info("Receive command %d" % char_value)
            if char_value == 0:#CONF
                self.getEpicsConfigure()
                time.sleep(0.5)
                _success=self.setCommand(0, 3, 1, 100)
                if not _success:
                    self.setCommand(6, 1, -1, -1)
                    self.setCommand(0, 3, 1, 100)

            elif char_value == 1:#START
                #start
                _success = self.setCommand(2, 4, 2, 100)
                if not _success:
                    #abort
                    self.setCommand(6, 1, -1, -1)
                    #conf
                    self.getEpicsConfigure()
                    time.sleep(0.2)
                    self.setCommand(0, 3, -1, 100)
                    #start
                    self.setCommand(2, 4, 2, 100)

            elif char_value == 2:#STOP
                #stop
                _success = self.setCommand(5, 3, 0, 100)
                if not _success:
                    #abort
                    self.setCommand(6, 1, -1, -1)
                    #conf
                    self.getEpicsConfigure()
                    time.sleep(0.2)
                    self.setCommand(0, 3, 0, 100)
            elif char_value == 3 or char_value == 4:#EXIT or CANCEL
                #abort
                self.setCommand(6, 1, -1, -1)

            else:
                logger.warning("Invalid command %d" % char_value)

            time.sleep(0.5)

if __name__=="__main__":
    run_once()

    logger.info("===================")
    logger.info("Welcome to CockPit!")
    logger.info("        SANS       ")
    logger.info("===================")
    # connect Redis
    try:
        myredis=getRedisServer([('10.1.34.116', 9001), ('10.1.34.116',9011)], "sanlie;123", 10)
        if myredis.getStatus():
            redisServer=myredis.getRedisWrite()
            logger.debug("Redis Connected")
    except:
        redisServer=None
        logger.error("Redis not available")
    #"==================="
    # connect Epics
    try:
        myepics=getEpicsServer(10)
        epicsCommand, epicsStatus = myepics.getServer()
        logger.debug("EPICS Connected")
    except:
        epicsCommand=None
        epicsStatus=None
        logger.error("EPICS Failed")

    try:
        _cmd=int(epicsCommand.get())
        if _cmd < 0 or _cmd>5:
            redisServer.set("/SANS/control/command", json.dumps(-1))
    except:
        pass

    #"==================="
    try:
        threadGetEpics = getEpicsCommand(redisServer, epicsStatus)
        threadGetEpics.setDaemon(True)
        threadGetEpics.start()
        logger.debug("Command thread created")
    except:
        logger.error("Command thread Failed")
    time.sleep(0.1)

    try:
        threadGetEpics.join()
    except:
        pass

    #"==================="
    try:
        epicsStatus.put('ERROR')
        logger.info("SANScockpit quit")
    except:
        pass
