package cn.ac.csns.property.controller;

import cn.ac.csns.property.ejb.GroupingFacade;
import cn.ac.csns.property.ejb.UserFacade;
import cn.ac.csns.property.entity.Grouping;
import cn.ac.csns.property.entity.User;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.ejb.EJB;
import javax.inject.Named;
import javax.enterprise.context.SessionScoped;
import javax.faces.annotation.FacesConfig;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.SecurityContext;
import javax.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.Password;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;

/**
 *
 * @author tangm
 */
@FacesConfig(version = FacesConfig.Version.JSF_2_3)
@DeclareRoles({"admin", "super", "common"})
@Named
@SessionScoped
public class LoginController implements Serializable {

    @NotNull
    private String username;

    @NotNull
    private String password;

    @Inject
    private UserInfoController userInfoController;

    @Inject
    private SecurityContext securityContext;

    @Inject
    private FacesContext facesContext;

    @EJB
    private GroupingFacade groupingFacade;

    @EJB
    private UserFacade userFacade;

    @Resource(name = "jndi/ldap")
    private LdapContext ldapContext;

    private String url;

    /**
     * Creates a new instance of LoginController
     */
    public LoginController() {
    }

    @PostConstruct
    private void init() {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map<String, Object> requestMap = externalContext.getRequestMap();
        url = (String) requestMap.get(RequestDispatcher.FORWARD_SERVLET_PATH);
        String queryString = (String) requestMap.get(RequestDispatcher.FORWARD_QUERY_STRING);
        if (null != queryString && !queryString.trim().isEmpty()) {
            url = url + "?" + queryString;
        }
        if (null == url) {
            url = "/index?faces-redirect=true";
        }
        System.out.println("url: " + url);
    }

    public void test() {
        Credential credential = new UsernamePasswordCredential(username, new Password(password));
        HttpServletRequest request = (HttpServletRequest) facesContext.getExternalContext().getRequest();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();

        AuthenticationStatus authStatus = securityContext.authenticate(request, response,
                AuthenticationParameters.withParams().credential(credential));
        
        switch (authStatus) {
            case SEND_FAILURE:
                System.out.println("Error");
                System.out.println(response.isCommitted());
                facesContext.renderResponse();
                break;
            case SEND_CONTINUE:
                System.out.println("Continue");
                System.out.println(response.isCommitted());
                facesContext.responseComplete();
                facesContext.renderResponse();
                break;
            case NOT_DONE:
                System.out.println("Not done");
                System.out.println(response.isCommitted());
                facesContext.renderResponse();
                break;
            default:
                System.out.println(authStatus);
                System.out.println(response.isCommitted());
                facesContext.renderResponse();
        }
    }

    public String login() {
        Credential credential = new UsernamePasswordCredential(username, new Password(password));
        HttpServletRequest request = (HttpServletRequest) facesContext.getExternalContext().getRequest();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();

        System.out.println(AuthenticationParameters.withParams());
        System.out.println(AuthenticationParameters.withParams().isNewAuthentication());
        AuthenticationStatus authStatus = securityContext.authenticate(request, response,
                AuthenticationParameters.withParams().credential(credential));
        System.out.println("1111111111111111111");
        System.out.println(response.isCommitted());
        if (authStatus.equals(AuthenticationStatus.NOT_DONE)) {
            //facesContext.responseComplete();            
            System.out.println("+++++++++++++++");
            System.out.println(response.isCommitted());
            authStatus = securityContext.authenticate(request, response,
                    AuthenticationParameters.withParams().credential(credential));
            System.out.println(response.isCommitted());
        }

        if (authStatus.equals(AuthenticationStatus.SEND_FAILURE)) {
            System.out.println("2222222222");
            System.out.println(response.isCommitted());
            facesContext.addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_ERROR, "Authenciation failed", null));
            System.out.println(response.isCommitted());
            return null;
        }
        if (authStatus.equals(AuthenticationStatus.SEND_CONTINUE)) {
            //facesContext.responseComplete();
            System.out.println("**********************");
            System.out.println(response.isCommitted());
            authStatus = securityContext.authenticate(request, response,
                    AuthenticationParameters.withParams().credential(credential));
            System.out.println(response.isCommitted());
        }
        System.out.println("#################");
        System.out.println(authStatus);
        System.out.println(response.isCommitted());
        if (authStatus.equals(AuthenticationStatus.SUCCESS)) {
            System.out.println("555555555555555");
            System.out.println(response.isCommitted());
            try {
                SearchControls sc = new SearchControls();
                sc.setSearchScope(SearchControls.SUBTREE_SCOPE);
                sc.setReturningAttributes(new String[]{"cn", "sn", "uid", "trueName", "email"});
                sc.setCountLimit(1);
                sc.setTimeLimit(10*1000);
                NamingEnumeration<SearchResult> results = ldapContext.search("", "(&(cn=" + username + ")(objectClass=users))", sc);
                System.out.println("66666666666666666666666");
                if (results.hasMoreElements()) {
                    SearchResult sr = results.next();
                    Attributes r = sr.getAttributes();
                    String trueName = (String) r.get("trueName").get(0);
                    String email = (String) r.get("email").get(0);
                    String uid = (String) r.get("uid").get(0);
                    boolean admin = securityContext.isCallerInRole("admin");
                    boolean superAdmin = securityContext.isCallerInRole("super");
                    userInfoController.setAdmin(admin);
                    userInfoController.setEmail(email);
                    userInfoController.setSuperAdmin(superAdmin);
                    userInfoController.setTrueName(trueName);
                    userInfoController.setUid(uid);
                    userInfoController.setUserName(username);
                    //List<Grouping> groups = groupingFacade.getByUserName(username);
                    System.out.println("7777777777777777777777777");
                    List<Grouping> groups = groupingFacade.getByEmail(email);
                    groups.stream().filter((item) -> (!item.getName().toLowerCase().equals("admin") && !item.getName().toLowerCase().equals("super")))
                            .forEachOrdered((item) -> {
                                userInfoController.getGroupings().add(item);
                            });
                    userInfoController.getGroupings().stream().map((item) -> userFacade.getByGrouping(item))
                            .filter((temp) -> (!temp.isEmpty())).forEachOrdered((temp) -> {
                        userInfoController.getGroupMembers().addAll(temp);
                    });
                    if (userFacade.findByName(username).isEmpty()) {
                        User user = new User();
                        user.setEmail(email);
                        user.setFullname(trueName);
                        user.setName(username);
                        user.setRole("member");
                        try {
                            userFacade.edit(user);
                        } catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                    }
                    User logged = userFacade.findByName(username).get(0);
                    userInfoController.setUser(logged);
                }
                System.out.println("33333333333333");
                System.out.println(response.isCommitted());
                /**
                 * try { //response.sendRedirect(url); //
                 * request.getRequestDispatcher(url).forward(request, response);
                 * } catch (IOException ex) {
                 * Logger.getLogger(LoginController.class.getName()).log(Level.SEVERE,
                 * null, ex); } catch (ServletException ex) {
                 * Logger.getLogger(LoginController.class.getName()).log(Level.SEVERE,
                 * null, ex); }*
                 */

            } catch (NamingException ex) {
                Logger.getLogger(LoginController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.out.println("444444444444444444");

        System.out.println(authStatus);
        //facesContext.responseComplete();
        System.out.println(url);
        System.out.println(response.isCommitted());
        return url;

    }

    public String logout() {
        HttpServletRequest request = (HttpServletRequest) facesContext.getExternalContext().getRequest();
        try {
            request.logout();
            request.getSession().invalidate();
        } catch (ServletException ex) {
            Logger.getLogger(LoginController.class.getName()).log(Level.SEVERE, null, ex);
        }

        return "/login?faces-redirect=true";
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

}
