package cn.ac.csns.property.controller;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.view.ViewScoped;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.model.file.UploadedFiles;

/**
 *
 * @author tangm
 */
@Named(value = "fileUploadController")
@ViewScoped
public class FileUploadController implements Serializable {

    private UploadedFiles files;

    /**
     * Creates a new instance of FileUploadController
     */
    public FileUploadController() {
    }

    public void handleFileUpload(FileUploadEvent event) throws InterruptedException {
        String fname = event.getFile().getFileName();
        String path = getParentPath();
        try (OutputStream fout = new FileOutputStream(new File(path + File.separator + fname))) {
            int read = 0;
            final byte[] buf = new byte[4096];
            try (InputStream fin = event.getFile().getInputStream()) {
                while ((read = fin.read(buf)) != -1) {
                    fout.write(buf, 0, read);
                }
                fout.flush();
            }
            String summary = ResourceBundle.getBundle("/Bundle").getString("Upload_msg_summary_success");
            String detail = ResourceBundle.getBundle("/Bundle").getString("Upload_msg_detail_success");
            MessageFormat msgFormat = new MessageFormat(detail);
            FacesMessage msg = new FacesMessage(summary, msgFormat.format(new Object[]{fname}));
            FacesContext.getCurrentInstance().addMessage(null, msg);

        } catch (FileNotFoundException ex) {
            Logger.getLogger(FileUploadController.class.getName()).log(Level.SEVERE, null, ex);
            String summary = ResourceBundle.getBundle("/Bundle").getString("Upload_msg_summary_fail");
            FacesMessage msg = new FacesMessage(summary, ex.getLocalizedMessage());
            FacesContext.getCurrentInstance().addMessage(null, msg);
        } catch (IOException ex) {
            Logger.getLogger(FileUploadController.class.getName()).log(Level.SEVERE, null, ex);
            String summary = ResourceBundle.getBundle("/Bundle").getString("Upload_msg_summary_fail");
            FacesMessage msg = new FacesMessage(summary, ex.getLocalizedMessage());
            FacesContext.getCurrentInstance().addMessage(null, msg);
        }
    }

    private String getParentPath() {
        String path = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("app.DATA_FILE_UPLOAD_DIR");
        if (null == path || path.trim().isEmpty()) {
            path = System.getProperty("user.home");
            path += File.separator + "property_data";
        }
        if(!Files.exists(Paths.get(path), LinkOption.NOFOLLOW_LINKS)){
            try {
                Files.createDirectories(Paths.get(path));
            } catch (IOException ex) {
                Logger.getLogger(FileUploadController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return path;
    }

    public UploadedFiles getFiles() {
        return files;
    }

    public void setFiles(UploadedFiles files) {
        this.files = files;
    }

}
