/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.property.entity;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 *
 * @author tangm
 */
@Entity
@Table(name = "group_")
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "Grouping.findAll", query = "SELECT g FROM Grouping g"),
    @NamedQuery(name = "Grouping.findById", query = "SELECT g FROM Grouping g WHERE g.id = :id"),
    @NamedQuery(name = "Grouping.findByName", query = "SELECT g FROM Grouping g WHERE g.name = :name"),
    @NamedQuery(name = "Grouping.findByCode", query = "SELECT g FROM Grouping g WHERE g.code = :code")})
public class Grouping implements Serializable {

    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 100)
    @Column(name = "name")
    private String name;
    @Size(max = 100)
    @Column(name = "code")
    private String code;
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "groupId")
    private List<GoodsGroup> goodsGroupList;

    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Basic(optional = false)
    @Column(name = "id")
    private Integer id;
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "groupId")
    private List<UserGroup> userGroupList;

    public Grouping() {
    }

    public Grouping(Integer id) {
        this.id = id;
    }

    public Grouping(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }


    @XmlTransient
    public List<UserGroup> getUserGroupList() {
        return userGroupList;
    }

    public void setUserGroupList(List<UserGroup> userGroupList) {
        this.userGroupList = userGroupList;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Grouping)) {
            return false;
        }
        Grouping other = (Grouping) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "cn.ac.csns.property.entity.Grouping[ id=" + id + " ]";
    }


    @XmlTransient
    public List<GoodsGroup> getGoodsGroupList() {
        return goodsGroupList;
    }

    public void setGoodsGroupList(List<GoodsGroup> goodsGroupList) {
        this.goodsGroupList = goodsGroupList;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    
}
