/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.property.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 *
 * @author tangm
 */
@Entity
@Table(name = "goods")
@Cacheable(false)
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "Goods.findAll", query = "SELECT g FROM Goods g"),
    @NamedQuery(name = "Goods.findById", query = "SELECT g FROM Goods g WHERE g.id = :id"),
    @NamedQuery(name = "Goods.findByCode", query = "SELECT g FROM Goods g WHERE g.code = :code"),
    @NamedQuery(name = "Goods.findByLabel", query = "SELECT g FROM Goods g WHERE g.label = :label"),
    @NamedQuery(name = "Goods.findByName", query = "SELECT g FROM Goods g WHERE g.name = :name"),
    @NamedQuery(name = "Goods.findByInventoryCode", query = "SELECT g FROM Goods g WHERE g.inventoryCode = :inventoryCode"),
    @NamedQuery(name = "Goods.findByInventoryDate", query = "SELECT g FROM Goods g WHERE g.inventoryDate = :inventoryDate"),
    @NamedQuery(name = "Goods.findByMount", query = "SELECT g FROM Goods g WHERE g.mount = :mount"),
    @NamedQuery(name = "Goods.findByUnit", query = "SELECT g FROM Goods g WHERE g.unit = :unit"),
    @NamedQuery(name = "Goods.findByUnitPrice", query = "SELECT g FROM Goods g WHERE g.unitPrice = :unitPrice"),
    @NamedQuery(name = "Goods.findByTotalPrice", query = "SELECT g FROM Goods g WHERE g.totalPrice = :totalPrice"),
    @NamedQuery(name = "Goods.findByBrand", query = "SELECT g FROM Goods g WHERE g.brand = :brand"),
    @NamedQuery(name = "Goods.findByMode", query = "SELECT g FROM Goods g WHERE g.mode = :mode"),
    @NamedQuery(name = "Goods.findBySpecification", query = "SELECT g FROM Goods g WHERE g.specification = :specification"),
    @NamedQuery(name = "Goods.findByMade", query = "SELECT g FROM Goods g WHERE g.made = :made"),
    @NamedQuery(name = "Goods.findByPlace", query = "SELECT g FROM Goods g WHERE g.place = :place"),
    @NamedQuery(name = "Goods.findByPart", query = "SELECT g FROM Goods g WHERE g.part = :part"),
    @NamedQuery(name = "Goods.findByUsingDate", query = "SELECT g FROM Goods g WHERE g.usingDate = :usingDate"),
    @NamedQuery(name = "Goods.findByPurchaseSource", query = "SELECT g FROM Goods g WHERE g.purchaseSource = :purchaseSource"),
    @NamedQuery(name = "Goods.findBySupplier", query = "SELECT g FROM Goods g WHERE g.supplier = :supplier"),
    @NamedQuery(name = "Goods.findByComment", query = "SELECT g FROM Goods g WHERE g.comment = :comment")})
public class Goods implements Serializable {

    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 100)
    @Column(name = "code")
    private String code;
    @Basic(optional = false)
    @NotNull()
    @Size(min = 1, max = 100)
    @Column(name = "label")
    private String label;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(name = "name")
    private String name;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 100)
    @Column(name = "inventory_code")
    private String inventoryCode;
    @Basic(optional = false)
    @NotNull
    @Column(name = "inventory_date")
    @Temporal(TemporalType.DATE)
    private Date inventoryDate;
    @Basic(optional = false)
    @NotNull
    @Column(name = "mount")
    private float mount = 1.0f;
    @Size(max = 100)
    @Column(name = "unit")
    private String unit;
    @Size(max = 100)
    @Column(name = "brand")
    private String brand;
    @Size(max = 100)
    @Column(name = "mode")
    private String mode;
    // @Max(value=?)  @Min(value=?)//if you know range of your decimal fields consider using these annotations to enforce field validation
    @Size(max = 100)
    @Column(name = "specification")
    private String specification;
    @Size(max = 100)
    @Column(name = "made")
    private String made;
    @Size(max = 255)
    @Column(name = "place")
    private String place;
    @Basic(optional = false)
    @NotNull()
    @Column(name = "part")
    private boolean part;
    @Size(max = 100)
    @Column(name = "purchase_source")
    private String purchaseSource;
    @Size(max = 100)
    @Column(name = "supplier")
    private String supplier;
    @Size(max = 255)
    @Column(name = "comment")
    private String comment;
    @OneToOne(cascade = CascadeType.ALL, mappedBy = "goodsId")
    private GoodsFacility goodsFacility;
    @OneToOne(cascade = CascadeType.ALL, mappedBy = "goodsId")
    private GoodsGroup goodsGroup;
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Basic(optional = false)
    @Column(name = "id")
    private Integer id;
    @Column(name = "unit_price")
    private Float unitPrice;
    @Column(name = "total_price")
    private Float totalPrice;
    @Column(name = "using_date")
    @Temporal(TemporalType.DATE)
    private Date usingDate;
    @JoinColumn(name = "account_id", referencedColumnName = "id")
    @ManyToOne
    private Account accountId;
    @JoinColumn(name = "status_id", referencedColumnName = "id")
    @ManyToOne
    private Status statusId;
    @OneToOne(cascade = CascadeType.ALL, mappedBy = "goodsId")
    private GoodsCategory goodsCategory;
    @OneToOne(cascade = CascadeType.ALL, mappedBy = "goodsId")
    private GoodsUser goodsUser;

    public Goods() {
    }

    public Goods(Integer id) {
        this.id = id;
    }

    public Goods(Integer id, String code, String label, String name, String inventoryCode, Date inventoryDate, float mount, boolean part) {
        this.id = id;
        this.code = code;
        this.label = label;
        this.name = name;
        this.inventoryCode = inventoryCode;
        this.inventoryDate = inventoryDate;
        this.mount = mount;
        this.part = part;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getInventoryCode() {
        return inventoryCode;
    }

    public void setInventoryCode(String inventoryCode) {
        this.inventoryCode = inventoryCode;
    }

    public Date getInventoryDate() {
        return inventoryDate;
    }

    public void setInventoryDate(Date inventoryDate) {
        this.inventoryDate = inventoryDate;
    }


    public Float getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(Float unitPrice) {
        this.unitPrice = unitPrice;
    }

    public Float getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(Float totalPrice) {
        this.totalPrice = totalPrice;
    }


    public Date getUsingDate() {
        return usingDate;
    }

    public void setUsingDate(Date usingDate) {
        this.usingDate = usingDate;
    }

    public String getPurchaseSource() {
        return purchaseSource;
    }

    public void setPurchaseSource(String purchaseSource) {
        this.purchaseSource = purchaseSource;
    }

    public Account getAccountId() {
        return accountId;
    }

    public void setAccountId(Account accountId) {
        this.accountId = accountId;
    }

    public Status getStatusId() {
        return statusId;
    }

    public void setStatusId(Status statusId) {
        this.statusId = statusId;
    }

    public GoodsCategory getGoodsCategory() {
        return goodsCategory;
    }

    public void setGoodsCategory(GoodsCategory goodsCategory) {
        this.goodsCategory = goodsCategory;
    }

    @XmlTransient
    public GoodsUser getGoodsUser() {
        return goodsUser;
    }

    public void setGoodsUser(GoodsUser goodsUser) {
        this.goodsUser = goodsUser;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Goods)) {
            return false;
        }
        Goods other = (Goods) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "cn.ac.csns.property.entity.Goods[ id=" + id + " ]";
    }
    public GoodsGroup getGoodsGroup() {
        return goodsGroup;
    }
    public void setGoodsGroup(GoodsGroup goodsGroup) {
        this.goodsGroup = goodsGroup;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getMount() {
        return mount;
    }

    public void setMount(float mount) {
        this.mount = mount;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public String getMade() {
        return made;
    }

    public void setMade(String made) {
        this.made = made;
    }

    public String getPlace() {
        return place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public boolean getPart() {
        return part;
    }

    public void setPart(boolean part) {
        this.part = part;
    }

    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public GoodsFacility getGoodsFacility() {
        return goodsFacility;
    }

    public void setGoodsFacility(GoodsFacility goodsFacility) {
        this.goodsFacility = goodsFacility;
    }
    
}
