/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.property.ejb;

import cn.ac.csns.property.entity.Grouping;
import cn.ac.csns.property.entity.User;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

/**
 *
 * @author tangm
 */
@Stateless
public class UserFacade extends AbstractFacade<User> {

    @PersistenceContext(unitName = "property_pu")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return em;
    }

    public UserFacade() {
        super(User.class);
    }

    public List<User> getByGrouping(Grouping grouping) {
        String jpql = "SELECT DISTINCT u FROM User u JOIN u.userGroupList ug WHERE ug.groupId = :group";
        return getEntityManager().createQuery(jpql).setParameter("group", grouping).getResultList();
    }
    
    public List<User> findByName(String name) {
        return getEntityManager().createNamedQuery("User.findByName", User.class).setParameter("name", name).getResultList();
    }

}
