/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.property.ejb;

import cn.ac.csns.property.entity.Grouping;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

/**
 *
 * @author tangm
 */
@Stateless
public class GroupingFacade extends AbstractFacade<Grouping> {

    @PersistenceContext(unitName = "property_pu")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return em;
    }

    public GroupingFacade() {
        super(Grouping.class);
    }
    
    public List<Grouping> getByUserName(String username){
        String jpql = "SELECT g FROM Grouping g JOIN g.userGroupList ug JOIN ug.userId u WHERE u.name = :username ";
        return getEntityManager().createQuery(jpql, Grouping.class).setParameter("username", username).getResultList();
    }
    
    public List<Grouping> getByEmail(String email){
        String jpql = "SELECT DISTINCT g FROM Grouping g JOIN g.userGroupList ug WHERE ug.userId.email = :email ";
        return getEntityManager().createQuery(jpql, Grouping.class).setParameter("email", email).getResultList();
    }
}
