package cn.ac.csns.property.controller;

import cn.ac.csns.property.entity.Status;
import cn.ac.csns.property.controller.util.JsfUtil;
import cn.ac.csns.property.controller.util.JsfUtil.PersistAction;
import cn.ac.csns.property.ejb.StatusFacade;

import java.io.Serializable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.inject.Named;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.faces.view.ViewScoped;

@Named("statusController")
@ViewScoped
public class StatusController implements Serializable {

    @EJB
    private cn.ac.csns.property.ejb.StatusFacade ejbFacade;
    private List<Status> items = null;
    private List<Status> filteredItems = null;
    private Status selected;

    public StatusController() {
    }

    public Status getSelected() {
        return selected;
    }

    public void setSelected(Status selected) {
        this.selected = selected;
    }

    protected void setEmbeddableKeys() {
    }

    protected void initializeEmbeddableKey() {
    }

    private StatusFacade getFacade() {
        return ejbFacade;
    }

    public Status prepareCreate() {
        selected = new Status();
        initializeEmbeddableKey();
        return selected;
    }

    public void create() {
        persist(PersistAction.CREATE, ResourceBundle.getBundle("/Bundle").getString("StatusCreated"));
        if (!JsfUtil.isValidationFailed()) {
            items = null;    // Invalidate list of items to trigger re-query.
        }
    }

    public void update() {
        persist(PersistAction.UPDATE, ResourceBundle.getBundle("/Bundle").getString("StatusUpdated"));
    }

    public void destroy() {
        persist(PersistAction.DELETE, ResourceBundle.getBundle("/Bundle").getString("StatusDeleted"));
        if (!JsfUtil.isValidationFailed()) {
            selected = null; // Remove selection
            items = null;    // Invalidate list of items to trigger re-query.
        }
    }

    public List<Status> getItems() {
        if (items == null) {
            items = getFacade().findAll();
        }
        return items;
    }

    public List<Status> getFilteredItems() {
        return filteredItems;
    }

    public void setFilteredItems(List<Status> filteredItems) {
        this.filteredItems = filteredItems;
    }

    private void persist(PersistAction persistAction, String successMessage) {
        if (selected != null) {
            setEmbeddableKeys();
            try {
                if (persistAction != PersistAction.DELETE) {
                    getFacade().edit(selected);
                } else {
                    getFacade().remove(selected);
                }
                JsfUtil.addSuccessMessage(successMessage);
            } catch (EJBException ex) {
                String msg = "";
                Throwable cause = ex.getCause();
                if (cause != null) {
                    msg = cause.getLocalizedMessage();
                }
                if (msg.length() > 0) {
                    JsfUtil.addErrorMessage(msg);
                } else {
                    JsfUtil.addErrorMessage(ex, ResourceBundle.getBundle("/Bundle").getString("PersistenceErrorOccured"));
                }
            } catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                JsfUtil.addErrorMessage(ex, ResourceBundle.getBundle("/Bundle").getString("PersistenceErrorOccured"));
            }
        }
    }

    public Status getStatus(java.lang.Integer id) {
        return getFacade().find(id);
    }

    public List<Status> getItemsAvailableSelectMany() {
        return getFacade().findAll();
    }

    public List<Status> getItemsAvailableSelectOne() {
        return getFacade().findAll();
    }

    @FacesConverter(forClass = Status.class)
    public static class StatusControllerConverter implements Converter {

        @Override
        public Object getAsObject(FacesContext facesContext, UIComponent component, String value) {
            if (value == null || value.length() == 0) {
                return null;
            }
            StatusController controller = (StatusController) facesContext.getApplication().getELResolver().
                    getValue(facesContext.getELContext(), null, "statusController");
            return controller.getStatus(getKey(value));
        }

        java.lang.Integer getKey(String value) {
            java.lang.Integer key;
            key = Integer.valueOf(value);
            return key;
        }

        String getStringKey(java.lang.Integer value) {
            StringBuilder sb = new StringBuilder();
            sb.append(value);
            return sb.toString();
        }

        @Override
        public String getAsString(FacesContext facesContext, UIComponent component, Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof Status) {
                Status o = (Status) object;
                return getStringKey(o.getId());
            } else {
                Logger.getLogger(this.getClass().getName())
                        .log(Level.SEVERE, "object {0} is of type {1}; expected type: {2}", 
                                new Object[]{object, object.getClass().getName(),
                                    Status.class.getName()});
                return null;
            }
        }

    }

}
