package cn.ac.csns.property.controller;

import cn.ac.csns.property.entity.GoodsUser;
import cn.ac.csns.property.controller.util.JsfUtil;
import cn.ac.csns.property.controller.util.JsfUtil.PersistAction;
import cn.ac.csns.property.ejb.GoodsUserFacade;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.inject.Named;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;

@Named("goodsUserController")
@ViewScoped
public class GoodsUserController implements Serializable {

    @EJB
    private cn.ac.csns.property.ejb.GoodsUserFacade ejbFacade;
    private List<GoodsUser> items = null;
    private List<GoodsUser> filteredItems = null;
    private GoodsUser selected;
    @Inject
    private UserInfoController userInfoController;

    public GoodsUserController() {
    }

    public GoodsUser getSelected() {
        return selected;
    }

    public void setSelected(GoodsUser selected) {
        this.selected = selected;
    }

    protected void setEmbeddableKeys() {
    }

    protected void initializeEmbeddableKey() {
    }

    private GoodsUserFacade getFacade() {
        return ejbFacade;
    }

    public GoodsUser prepareCreate() {
        selected = new GoodsUser();
        initializeEmbeddableKey();
        return selected;
    }

    public void create() {
        persist(PersistAction.CREATE, ResourceBundle.getBundle("/Bundle").getString("GoodsUserCreated"));
        if (!JsfUtil.isValidationFailed()) {
            items = null;    // Invalidate list of items to trigger re-query.
        }
    }

    public void update() {
        persist(PersistAction.UPDATE, ResourceBundle.getBundle("/Bundle").getString("GoodsUserUpdated"));
    }

    public void destroy() {
        persist(PersistAction.DELETE, ResourceBundle.getBundle("/Bundle").getString("GoodsUserDeleted"));
        if (!JsfUtil.isValidationFailed()) {
            selected = null; // Remove selection
            items = null;    // Invalidate list of items to trigger re-query.
        }
    }

    public List<GoodsUser> getItems() {
        if (items == null) {
            List<GoodsUser> all = getFacade().findAll();
            if (userInfoController.isAdmin() || userInfoController.isSuperAdmin()) {
                items = all;
            } else {
                items = new ArrayList<>();
                if (null != userInfoController.getUserName()) {
                    all.stream().filter((GoodsUser item) -> {
                        return item.getUserId().getEmail()
                                .equalsIgnoreCase(userInfoController.getEmail());
                    }).forEachOrdered((item) -> items.add(item));
                }
            }
        }
        return items;
    }

    public List<GoodsUser> getFilteredItems() {
        return filteredItems;
    }

    public void setFilteredItems(List<GoodsUser> filteredItems) {
        this.filteredItems = filteredItems;
    }

    private void persist(PersistAction persistAction, String successMessage) {
        if (selected != null) {
            setEmbeddableKeys();
            try {
                if (persistAction != PersistAction.DELETE) {
                    getFacade().edit(selected);
                } else {
                    getFacade().remove(selected);
                }
                JsfUtil.addSuccessMessage(successMessage);
            } catch (EJBException ex) {
                String msg = "";
                Throwable cause = ex.getCause();
                if (cause != null) {
                    msg = cause.getLocalizedMessage();
                }
                if (msg.length() > 0) {
                    JsfUtil.addErrorMessage(msg);
                } else {
                    JsfUtil.addErrorMessage(ex, ResourceBundle.getBundle("/Bundle").getString("PersistenceErrorOccured"));
                }
            } catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                JsfUtil.addErrorMessage(ex, ResourceBundle.getBundle("/Bundle").getString("PersistenceErrorOccured"));
            }
        }
    }

    public GoodsUser getGoodsUser(java.lang.Integer id) {
        return getFacade().find(id);
    }

    public List<GoodsUser> getItemsAvailableSelectMany() {
        return getFacade().findAll();
    }

    public List<GoodsUser> getItemsAvailableSelectOne() {
        return getFacade().findAll();
    }

    @FacesConverter(forClass = GoodsUser.class)
    public static class GoodsUserControllerConverter implements Converter {

        @Override
        public Object getAsObject(FacesContext facesContext, UIComponent component, String value) {
            if (value == null || value.length() == 0) {
                return null;
            }
            GoodsUserController controller = (GoodsUserController) facesContext.getApplication().getELResolver().
                    getValue(facesContext.getELContext(), null, "goodsUserController");
            return controller.getGoodsUser(getKey(value));
        }

        java.lang.Integer getKey(String value) {
            java.lang.Integer key;
            key = Integer.valueOf(value);
            return key;
        }

        String getStringKey(java.lang.Integer value) {
            StringBuilder sb = new StringBuilder();
            sb.append(value);
            return sb.toString();
        }

        @Override
        public String getAsString(FacesContext facesContext, UIComponent component, Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof GoodsUser) {
                GoodsUser o = (GoodsUser) object;
                return getStringKey(o.getId());
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "object {0} is of type {1}; expected type: {2}", new Object[]{object, object.getClass().getName(), GoodsUser.class.getName()});
                return null;
            }
        }

    }

}
