package cn.ac.csns.property.controller;

import cn.ac.csns.property.entity.Goods;
import cn.ac.csns.property.controller.util.JsfUtil;
import cn.ac.csns.property.controller.util.JsfUtil.PersistAction;
import cn.ac.csns.property.ejb.GoodsFacade;
import cn.ac.csns.property.entity.Category;
import cn.ac.csns.property.entity.Grouping;
import cn.ac.csns.property.entity.Status;
import cn.ac.csns.property.entity.User;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.inject.Named;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;

@Named("goodsController")
@ViewScoped
public class GoodsController implements Serializable {

    @EJB
    private cn.ac.csns.property.ejb.GoodsFacade ejbFacade;
    @Inject
    private UserController userController;
    @Inject
    private GroupingController groupingController;
    private List<Goods> items = null;
    private List<Goods> filteredItems;
    private Goods selected;
    private String filterMode = "startsWith";
    @Inject
    private UserInfoController userInfoController;
    @Inject
    private StatusController statusController;
    private List<Grouping> groupings = null;
    private List<User> users = null;
    private final Map<Status, Float> statusStat = new HashMap<>();
    private final Map<Category, Float> c1Stat = new HashMap<>();
    private final Map<Category, Float> c2Stat = new HashMap<>();
    private final Map<Category, Float> c3Stat = new HashMap<>();
    private final Map<Category, Float> c4Stat = new HashMap<>();
    private final Map<Grouping, Map<Integer, Float>> groupingStat = new HashMap<>();

    public GoodsController() {
    }

    public void updateStat(boolean includeGroupItems) {
        statusStat.clear();
        statusController.getItems().stream().forEachOrdered((item) -> {
            statusStat.put(item, 0.0f);
        });
        c1Stat.clear();
        c2Stat.clear();
        c3Stat.clear();
        c4Stat.clear();
        groupingStat.clear();

        List<Goods> totalGoods;
        if (null != getFilteredItems()) {
            totalGoods = getFilteredItems();
        } else {
            if (false == includeGroupItems) {
                totalGoods = getOwnItems();
            } else {
                totalGoods = getItems(includeGroupItems);
            }
        }
        Set<Integer> years = new HashSet<>();

        totalGoods.stream().forEachOrdered((item) -> {
            statusStat.put(item.getStatusId(), statusStat.getOrDefault(item.getStatusId(), 0.0f) + item.getMount());
            if (null != item.getGoodsCategory()) {
                if (null != item.getGoodsCategory().getC1Id()) {
                    c1Stat.put(item.getGoodsCategory().getC1Id(), c1Stat.getOrDefault(item.getGoodsCategory().getC1Id(), 0.0f) + item.getMount());
                }
                if (null != item.getGoodsCategory().getC2Id()) {
                    c2Stat.put(item.getGoodsCategory().getC2Id(), c2Stat.getOrDefault(item.getGoodsCategory().getC2Id(), 0.0f) + item.getMount());
                }
                if (null != item.getGoodsCategory().getC3Id()) {
                    c3Stat.put(item.getGoodsCategory().getC3Id(), c3Stat.getOrDefault(item.getGoodsCategory().getC3Id(), 0.0f) + item.getMount());
                }
                if (null != item.getGoodsCategory().getC4Id()) {
                    c4Stat.put(item.getGoodsCategory().getC4Id(), c4Stat.getOrDefault(item.getGoodsCategory().getC4Id(), 0.0f) + item.getMount());
                }
            }
            if (null != item.getGoodsGroup()) {
                Grouping grouping = item.getGoodsGroup().getGroupId();
                Map<Integer, Float> value = groupingStat.getOrDefault(grouping, new HashMap<>());
                int year = item.getInventoryDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                value.put(year, value.getOrDefault(year, 0.0f) + item.getMount());
                groupingStat.put(grouping, value);
                years.add(year);
            }
        });
        groupingStat.values().forEach(v -> {
            years.stream().forEachOrdered(y -> {
                if (!v.containsKey(y)) {
                    v.put(y, 0.0f);
                }
            });
        });
    }

    public Map<Status, Float> getStatusStat() {
        return statusStat;
    }

    public Map<Category, Float> getCategoryStat(int level) {
        switch (level) {
            case 1:
                return c1Stat;
            case 2:
                return c2Stat;
            case 3:
                return c3Stat;
            case 4:
                return c4Stat;
            default:
                return new HashMap<>();
        }
    }

    public Map<Grouping, Map<Integer, Float>> getGroupingStat() {
        return groupingStat;
    }

    public List<Grouping> getGroupings() {
        if (null == groupings) {
            if (userInfoController.isAdmin() || userInfoController.isSuperAdmin()) {
                groupings = groupingController.getItems();
            } else {
                groupings = userInfoController.getGroupings();
            }
        }
        return groupings;
    }

    public List<User> getUsers() {
        if (null == users) {
            if (userInfoController.isAdmin() || userInfoController.isSuperAdmin()) {
                users = userController.getItems();
            } else {
                users = userInfoController.getGroupMembers();
            }
        }
        return users;
    }

    public Goods getSelected() {
        return selected;
    }

    public void setSelected(Goods selected) {
        this.selected = selected;
    }

    protected void setEmbeddableKeys() {
    }

    protected void initializeEmbeddableKey() {
    }

    private GoodsFacade getFacade() {
        return ejbFacade;
    }

    public Goods prepareCreate() {
        selected = new Goods();
        initializeEmbeddableKey();
        return selected;
    }

    public void create() {
        persist(PersistAction.CREATE, ResourceBundle.getBundle("/Bundle").getString("GoodsCreated"));
        if (!JsfUtil.isValidationFailed()) {
            items = null;    // Invalidate list of items to trigger re-query.
        }
    }

    public void update() {
        persist(PersistAction.UPDATE, ResourceBundle.getBundle("/Bundle").getString("GoodsUpdated"));
    }

    public void destroy() {
        persist(PersistAction.DELETE, ResourceBundle.getBundle("/Bundle").getString("GoodsDeleted"));
        if (!JsfUtil.isValidationFailed()) {
            selected = null; // Remove selection
            items = null;    // Invalidate list of items to trigger re-query.
        }
    }

    public List<Goods> getItems() {
        if (items == null) {
            List<Goods> all = getFacade().findAll();
            if (userInfoController.isAdmin() || userInfoController.isSuperAdmin()) {
                items = all;
            } else {
                items = new ArrayList<>();
                userInfoController.getGroupings().forEach((group) -> {
                    all.stream().filter((item) -> (item.getGoodsGroup().getGroupId().equals(group)))
                            .forEachOrdered((item) -> {
                                items.add(item);
                            });
                });
            }
        }
        return items;
    }

    public List<Goods> getItems(boolean includeGroupItems) {
        if (items == null) {
            List<Goods> all = getFacade().findAll();
            if (userInfoController.isAdmin() || userInfoController.isSuperAdmin()) {
                items = all;
            } else {
                items = new ArrayList<>();
                if (null == userInfoController.getUserName()) {
                    return items;
                }
                if (includeGroupItems) {
                    userInfoController.getGroupings().forEach((Grouping group) -> {
                        all.stream().filter((item) -> (item.getGoodsGroup().getGroupId().equals(group)))
                                .forEachOrdered((item) -> {
                                    items.add(item);
                                });
                    });
                } else {
                    all.stream().filter((Goods item) -> {
                        return item.getGoodsUser().getUserId().getEmail()
                                .equalsIgnoreCase(userInfoController.getEmail());
                    }).forEachOrdered((item) -> {
                        items.add(item);
                    });
                }
            }
        }
        return items;
    }

    public List<Goods> getOwnItems() {
        if (items == null) {
            items = new ArrayList<>();

            if (null == userInfoController.getUserName()) {
                return items;
            }

            List<Goods> all = getFacade().findAll();

            all.stream().filter((Goods item) -> {
                return item.getGoodsUser().getUserId().getEmail()
                        .equalsIgnoreCase(userInfoController.getEmail());
            }).forEachOrdered((item) -> {
                items.add(item);
            });
        }
        return items;
    }

    private void persist(PersistAction persistAction, String successMessage) {
        if (selected != null) {
            setEmbeddableKeys();
            try {
                if (persistAction != PersistAction.DELETE) {
                    getFacade().edit(selected);
                } else {
                    getFacade().remove(selected);
                }
                JsfUtil.addSuccessMessage(successMessage);
            } catch (EJBException ex) {
                String msg = "";
                Throwable cause = ex.getCause();
                if (cause != null) {
                    msg = cause.getLocalizedMessage();
                }
                if (msg.length() > 0) {
                    JsfUtil.addErrorMessage(msg);
                } else {
                    JsfUtil.addErrorMessage(ex, ResourceBundle.getBundle("/Bundle").getString("PersistenceErrorOccured"));
                }
            } catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                JsfUtil.addErrorMessage(ex, ResourceBundle.getBundle("/Bundle").getString("PersistenceErrorOccured"));
            }
        }
    }

    public Goods getGoods(java.lang.Integer id) {
        return getFacade().find(id);
    }

    public List<Goods> getItemsAvailableSelectMany() {
        return getFacade().findAll();
    }

    public List<Goods> getItemsAvailableSelectOne() {
        return getFacade().findAll();
    }

    public List<Goods> getFilteredItems() {
        return filteredItems;
    }

    public void setFilteredItems(List<Goods> filteredItems) {
        this.filteredItems = filteredItems;
    }

    public String getFilterMode() {
        return filterMode;
    }

    public void setFilterMode(String filterMode) {
        this.filterMode = filterMode;
    }

    @FacesConverter(forClass = Goods.class)
    public static class GoodsControllerConverter implements Converter {

        @Override
        public Object getAsObject(FacesContext facesContext, UIComponent component, String value) {
            if (value == null || value.length() == 0) {
                return null;
            }
            GoodsController controller = (GoodsController) facesContext.getApplication().getELResolver().
                    getValue(facesContext.getELContext(), null, "goodsController");
            return controller.getGoods(getKey(value));
        }

        java.lang.Integer getKey(String value) {
            java.lang.Integer key;
            key = Integer.valueOf(value);
            return key;
        }

        String getStringKey(java.lang.Integer value) {
            StringBuilder sb = new StringBuilder();
            sb.append(value);
            return sb.toString();
        }

        @Override
        public String getAsString(FacesContext facesContext, UIComponent component, Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof Goods) {
                Goods o = (Goods) object;
                return getStringKey(o.getId());
            } else {
                Logger.getLogger(this.getClass().getName())
                        .log(Level.SEVERE, "object {0} is of type {1}; expected type: {2}",
                                new Object[]{object, object.getClass().getName(),
                                    Goods.class.getName()});
                return null;
            }
        }

    }

}
