package cn.ac.csns.property.controller;

import cn.ac.csns.property.entity.GoodsCategory;
import cn.ac.csns.property.controller.util.JsfUtil;
import cn.ac.csns.property.controller.util.JsfUtil.PersistAction;
import cn.ac.csns.property.ejb.GoodsCategoryFacade;
import cn.ac.csns.property.entity.Grouping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.inject.Named;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;

@Named("goodsCategoryController")
@ViewScoped
public class GoodsCategoryController implements Serializable {

    @EJB
    private cn.ac.csns.property.ejb.GoodsCategoryFacade ejbFacade;
    private List<GoodsCategory> items = null;
    private List<GoodsCategory> filteredItems = null;
    private GoodsCategory selected;
    @Inject
    private UserInfoController userInfoController;

    public GoodsCategoryController() {
    }

    public GoodsCategory getSelected() {
        return selected;
    }

    public void setSelected(GoodsCategory selected) {
        this.selected = selected;
    }

    protected void setEmbeddableKeys() {
    }

    protected void initializeEmbeddableKey() {
    }

    private GoodsCategoryFacade getFacade() {
        return ejbFacade;
    }

    public GoodsCategory prepareCreate() {
        selected = new GoodsCategory();
        initializeEmbeddableKey();
        return selected;
    }

    public void create() {
        persist(PersistAction.CREATE, ResourceBundle.getBundle("/Bundle").getString("GoodsCategoryCreated"));
        if (!JsfUtil.isValidationFailed()) {
            items = null;    // Invalidate list of items to trigger re-query.
        }
    }

    public void update() {
        persist(PersistAction.UPDATE, ResourceBundle.getBundle("/Bundle").getString("GoodsCategoryUpdated"));
    }

    public void destroy() {
        persist(PersistAction.DELETE, ResourceBundle.getBundle("/Bundle").getString("GoodsCategoryDeleted"));
        if (!JsfUtil.isValidationFailed()) {
            selected = null; // Remove selection
            items = null;    // Invalidate list of items to trigger re-query.
        }
    }

    public List<GoodsCategory> getItems() {
        if (items == null) {
            items = getFacade().findAll();
        }
        return items;
    }

    public List<GoodsCategory> getItems(boolean includeGroupItems) {
        if (items == null) {
            List<GoodsCategory> all = getFacade().findAll();
            if (userInfoController.isAdmin() || userInfoController.isSuperAdmin()) {
                items = all;
            }
            items = new ArrayList<>();
            if (null == userInfoController.getUserName()) {
                return items;
            }
            if (includeGroupItems) {
                userInfoController.getGroupings().forEach((Grouping group) -> {
                    all.stream().filter((item) -> {
                        return item.getGoodsId().getGoodsGroup().getGroupId().equals(group);
                    }).forEachOrdered((item) -> {
                        items.add(item);
                    });
                });
            } else {
                all.stream().filter((item) -> {
                    return item.getGoodsId().getGoodsUser().getUserId().getEmail()
                            .equalsIgnoreCase(userInfoController.getEmail());
                }).forEachOrdered((item) -> {
                    items.add(item);
                });
            }
        }
        return items;
    }

    public List<GoodsCategory> getFilteredItems() {
        return filteredItems;
    }

    public void setFilteredItems(List<GoodsCategory> filteredItems) {
        this.filteredItems = filteredItems;
    }

    private void persist(PersistAction persistAction, String successMessage) {
        if (selected != null) {
            setEmbeddableKeys();
            try {
                if (persistAction != PersistAction.DELETE) {
                    getFacade().edit(selected);
                } else {
                    getFacade().remove(selected);
                }
                JsfUtil.addSuccessMessage(successMessage);
            } catch (EJBException ex) {
                String msg = "";
                Throwable cause = ex.getCause();
                if (cause != null) {
                    msg = cause.getLocalizedMessage();
                }
                if (msg.length() > 0) {
                    JsfUtil.addErrorMessage(msg);
                } else {
                    JsfUtil.addErrorMessage(ex, ResourceBundle.getBundle("/Bundle").getString("PersistenceErrorOccured"));
                }
            } catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                JsfUtil.addErrorMessage(ex, ResourceBundle.getBundle("/Bundle").getString("PersistenceErrorOccured"));
            }
        }
    }

    public GoodsCategory getGoodsCategory(java.lang.Integer id) {
        return getFacade().find(id);
    }

    public List<GoodsCategory> getItemsAvailableSelectMany() {
        return getFacade().findAll();
    }

    public List<GoodsCategory> getItemsAvailableSelectOne() {
        return getFacade().findAll();
    }

    @FacesConverter(forClass = GoodsCategory.class)
    public static class GoodsCategoryControllerConverter implements Converter {

        @Override
        public Object getAsObject(FacesContext facesContext, UIComponent component, String value) {
            if (value == null || value.length() == 0) {
                return null;
            }
            GoodsCategoryController controller = (GoodsCategoryController) facesContext.getApplication().getELResolver().
                    getValue(facesContext.getELContext(), null, "goodsCategoryController");
            return controller.getGoodsCategory(getKey(value));
        }

        java.lang.Integer getKey(String value) {
            java.lang.Integer key;
            key = Integer.valueOf(value);
            return key;
        }

        String getStringKey(java.lang.Integer value) {
            StringBuilder sb = new StringBuilder();
            sb.append(value);
            return sb.toString();
        }

        @Override
        public String getAsString(FacesContext facesContext, UIComponent component, Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof GoodsCategory) {
                GoodsCategory o = (GoodsCategory) object;
                return getStringKey(o.getId());
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "object {0} is of type {1}; expected type: {2}", new Object[]{object, object.getClass().getName(), GoodsCategory.class.getName()});
                return null;
            }
        }

    }

}
