package cn.ac.csns.property;

import javax.inject.Named;
import javax.enterprise.context.ApplicationScoped;
import javax.security.enterprise.authentication.mechanism.http.CustomFormAuthenticationMechanismDefinition;
import javax.security.enterprise.authentication.mechanism.http.LoginToContinue;
import javax.security.enterprise.identitystore.DatabaseIdentityStoreDefinition;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition;

/**
 *
 * @author tangm
 */
@CustomFormAuthenticationMechanismDefinition(
        loginToContinue = @LoginToContinue(
                loginPage = "/login.xhtml",
                errorPage = "/error.xhtml",
                useForwardToLogin = false
        )
)
@LdapIdentityStoreDefinition(
        url = "ldap://ldap.csns.ihep.ac.cn",
        callerSearchBase = "ou=users,dc=ihep,dc=ac,dc=cn",
        callerSearchFilter = "(&(cn=%s)(objectClass=users))",
        maxResults = 1,
        priority = 80,
        useFor = {IdentityStore.ValidationType.VALIDATE}
)
@DatabaseIdentityStoreDefinition(
        dataSourceLookup = "jdbc/mysql",
        groupsQuery = "select groupname from vug where username = ?",
        priority = 90,
        useFor = {IdentityStore.ValidationType.PROVIDE_GROUPS}
)
@Named
@ApplicationScoped
public class AppConfig {

    /**
     * Creates a new instance of AppConfig
     */
    public AppConfig() {
    }

}
