/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.property.entity;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

/**
 *
 * @author tangm
 */
@Entity
@Table(name = "categorymap",
       uniqueConstraints = @UniqueConstraint(columnNames = {"group_name", "goods_name"})
)
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "CategoryMap.findAll", query = "SELECT c FROM CategoryMap c"),
    @NamedQuery(name = "CategoryMap.findById", query = "SELECT c FROM CategoryMap c WHERE c.id = :id"),
    @NamedQuery(name = "CategoryMap.findByGroupName", query = "SELECT c FROM CategoryMap c WHERE c.groupName = :groupName"),
    @NamedQuery(name = "CategoryMap.findByGoodsName", query = "SELECT c FROM CategoryMap c WHERE c.goodsName = :goodsName"),
    @NamedQuery(name = "CategoryMap.findByC1", query = "SELECT c FROM CategoryMap c WHERE c.c1 = :c1"),
    @NamedQuery(name = "CategoryMap.findByC2", query = "SELECT c FROM CategoryMap c WHERE c.c2 = :c2"),
    @NamedQuery(name = "CategoryMap.findByC3", query = "SELECT c FROM CategoryMap c WHERE c.c3 = :c3"),
    @NamedQuery(name = "CategoryMap.findByC4", query = "SELECT c FROM CategoryMap c WHERE c.c4 = :c4"),
    @NamedQuery(name = "CategoryMap.findByC5", query = "SELECT c FROM CategoryMap c WHERE c.c5 = :c5"),
    @NamedQuery(name = "CategoryMap.findByC6", query = "SELECT c FROM CategoryMap c WHERE c.c6 = :c6")})
public class CategoryMap implements Serializable {

    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Basic(optional = false)
    @Column(name = "id")
    private Integer id;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 100)
    @Column(name = "group_name")
    private String groupName;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 100)
    @Column(name = "goods_name")
    private String goodsName;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 100)
    @Column(name = "c1")
    private String c1;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 100)
    @Column(name = "c2")
    private String c2;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 100)
    @Column(name = "c3")
    private String c3;
    @Size(max = 100)
    @Column(name = "c4")
    private String c4;
    @Size(max = 100)
    @Column(name = "c5")
    private String c5;
    @Size(max = 100)
    @Column(name = "c6")
    private String c6;

    public CategoryMap() {
    }

    public CategoryMap(Integer id) {
        this.id = id;
    }

    public CategoryMap(Integer id, String groupName, String goodsName, String c1, String c2, String c3) {
        this.id = id;
        this.groupName = groupName;
        this.goodsName = goodsName;
        this.c1 = c1;
        this.c2 = c2;
        this.c3 = c3;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getC1() {
        return c1;
    }

    public void setC1(String c1) {
        this.c1 = c1;
    }

    public String getC2() {
        return c2;
    }

    public void setC2(String c2) {
        this.c2 = c2;
    }

    public String getC3() {
        return c3;
    }

    public void setC3(String c3) {
        this.c3 = c3;
    }

    public String getC4() {
        return c4;
    }

    public void setC4(String c4) {
        this.c4 = c4;
    }

    public String getC5() {
        return c5;
    }

    public void setC5(String c5) {
        this.c5 = c5;
    }

    public String getC6() {
        return c6;
    }

    public void setC6(String c6) {
        this.c6 = c6;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof CategoryMap)) {
            return false;
        }
        CategoryMap other = (CategoryMap) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "cn.ac.csns.property.entity.CategoryMap[ id=" + id + " ]";
    }
    
}
