/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.property.entity;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 *
 * @author tangm
 */
@Entity
@Table(name = "category",
       uniqueConstraints = @UniqueConstraint(columnNames = {"facility_id", "name", "level"})
)
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "Category.findAll", query = "SELECT c FROM Category c"),
    @NamedQuery(name = "Category.findById", query = "SELECT c FROM Category c WHERE c.id = :id"),
    @NamedQuery(name = "Category.findByName", query = "SELECT c FROM Category c WHERE c.name = :name"),
    @NamedQuery(name = "Category.findByLevel", query = "SELECT c FROM Category c WHERE c.level = :level")})
public class Category implements Serializable {

    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Basic(optional = false)
    @Column(name = "id")
    private Integer id;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 100)
    @Column(name = "name")
    private String name;
    @Basic(optional = false)
    @NotNull
    @Column(name = "level")
    private short level;
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "c1Id")
    private List<GoodsCategory> goodsCategoryList;
    @OneToMany(mappedBy = "c2Id")
    private List<GoodsCategory> goodsCategoryList1;
    @OneToMany(mappedBy = "c3Id")
    private List<GoodsCategory> goodsCategoryList2;
    @OneToMany(mappedBy = "c4Id")
    private List<GoodsCategory> goodsCategoryList3;
    @OneToMany(mappedBy = "c5Id")
    private List<GoodsCategory> goodsCategoryList4;
    @OneToMany(mappedBy = "c6Id")
    private List<GoodsCategory> goodsCategoryList5;
    @JoinColumn(name = "facility_id", referencedColumnName = "id")
    @ManyToOne(optional = false)
    private Facility facilityId;

    public Category() {
    }

    public Category(Integer id) {
        this.id = id;
    }

    public Category(Integer id, String name, short level) {
        this.id = id;
        this.name = name;
        this.level = level;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public short getLevel() {
        return level;
    }

    public void setLevel(short level) {
        this.level = level;
    }

    @XmlTransient
    public List<GoodsCategory> getGoodsCategoryList() {
        return goodsCategoryList;
    }

    public void setGoodsCategoryList(List<GoodsCategory> goodsCategoryList) {
        this.goodsCategoryList = goodsCategoryList;
    }

    @XmlTransient
    public List<GoodsCategory> getGoodsCategoryList1() {
        return goodsCategoryList1;
    }

    public void setGoodsCategoryList1(List<GoodsCategory> goodsCategoryList1) {
        this.goodsCategoryList1 = goodsCategoryList1;
    }

    @XmlTransient
    public List<GoodsCategory> getGoodsCategoryList2() {
        return goodsCategoryList2;
    }

    public void setGoodsCategoryList2(List<GoodsCategory> goodsCategoryList2) {
        this.goodsCategoryList2 = goodsCategoryList2;
    }

    @XmlTransient
    public List<GoodsCategory> getGoodsCategoryList3() {
        return goodsCategoryList3;
    }

    public void setGoodsCategoryList3(List<GoodsCategory> goodsCategoryList3) {
        this.goodsCategoryList3 = goodsCategoryList3;
    }

    @XmlTransient
    public List<GoodsCategory> getGoodsCategoryList4() {
        return goodsCategoryList4;
    }

    public void setGoodsCategoryList4(List<GoodsCategory> goodsCategoryList4) {
        this.goodsCategoryList4 = goodsCategoryList4;
    }

    @XmlTransient
    public List<GoodsCategory> getGoodsCategoryList5() {
        return goodsCategoryList5;
    }

    public void setGoodsCategoryList5(List<GoodsCategory> goodsCategoryList5) {
        this.goodsCategoryList5 = goodsCategoryList5;
    }

    public Facility getFacilityId() {
        return facilityId;
    }

    public void setFacilityId(Facility facilityId) {
        this.facilityId = facilityId;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Category)) {
            return false;
        }
        Category other = (Category) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "cn.ac.csns.property.entity.Category[ id=" + id + " ]";
    }
    
}
