# -*- coding: utf-8 -*-

"""
    :author: Junrong Zhang
    :copyright: © 2020 CSNS
    :license: GPL V3, see LICENSE for more details.
"""

def hcline(data, name, *args, **kwargs):
    '''
    data: array[x, y1, y2 ....]
    name: array[y1, y2 ...]
    '''
    dataRead=data
    print(dataRead)
    output={}
    
    output['chart']={}
    output['chart']['type']='line'

    if "title" in kwargs:
        output['title']={"text": kwargs["title"]}

    if "xlabel" in kwargs:
        output['xAxis']={}
        output['xAxis']['title']={"text": kwargs["xlabel"]}
    
    if "xlog" in kwargs:
        output['xAxis']={}
        output['xAxis']['type']="logarithmic"
        #output["xAxis"]["type"] = "datetime"
    
    if "xdate" in kwargs:
        output['xAxis']={}
        output["xAxis"]["type"] = "datetime"

    if "xmin" in kwargs:
        output['xAxis']={}
        output['xAxis']['min']=kwargs["xmin"]

    if "xmax" in kwargs:
        output['xAxis']={}
        output['xAxis']['max']=kwargs["xmax"]

    if "ylabel" in kwargs:
        output['yAxis']={}
        output['yAxis']['title']={"text": kwargs["ylabel"]}

    if "ylog" in kwargs:
        output['yAxis']={}
        output['yAxis']['type']="logarithmic"
    
    if "ydate" in kwargs:
        output['yAxis']={}
        output["yAxis"]["type"] = "datetime"

    if "ymin" in kwargs:
        output['yAxis']={}
        output['yAxis']['min']=kwargs["xmin"]

    if "ymax" in kwargs:
        output['yAxis']={}
        output['yAxis']['max']=kwargs["ymax"]

    if "zoom" in kwargs:
        if kwargs["zoom"] not in ("x", "y", "xy"):
            raise ValueError("zoom must be in ('x', 'y', 'xy')")
        output["chart"]["zoomType"] = kwargs["zoom"]

    if len(name)!=len(data)-1:
            raise ValueError("data column must match")

    _series=[]
    for i in range(1,len(name)+1):
        _line={}
        _point = []
        for j in range(len(data[0])):
            _point.append([data[0][j], data[i][j]])

        _line['name']=name[i-1]
        _line['data']=_point

        _series.append(_line)


    output["series"]=_series

    return output


def hcmap(data, *args, **kwargs):
    '''
    data: array[x, y, z ....]
    x[n]
    y[m]
    z[nxm]
    '''
    #print(data)
    output={}
    output['chart']={}
    output['chart']['type']='heatmap'
    '''
    output['chart']['zoomType']='xy'
    output['chart']['panning']=True
    output['chart']['panKey']='shift'
    
    output['colorAxis']={}
    '''
    
    
    if "title" in kwargs:
        output['title']={"text": kwargs["title"]}
    '''
    if "boost" in kwargs:
        output['boost']={"useGPUTranslations": "true"}
    '''

    output['xAxis']={}
    if "xlabel" in kwargs:
        output['xAxis']['title']={"text": kwargs["xlabel"]}

    if "xmin" in kwargs:
        #output['xAxis']={}
        output['xAxis']['min']=kwargs["xmin"]

    if "xmax" in kwargs:
        #output['xAxis']={}
        output['xAxis']['max']=kwargs["xmax"]

    output['yAxis']={}
    if "ylabel" in kwargs:
        output['yAxis']['title']={"text": kwargs["ylabel"]}

    if "ymin" in kwargs:
        #output['yAxis']={}
        output['yAxis']['min']=kwargs["ymin"]

    if "ymax" in kwargs:
        #output['yAxis']={}
        output['yAxis']['max']=kwargs["ymax"]
    
    output['colorAxis']={}
    if "colormin" in kwargs:
        output['colorAxis']['min']=kwargs["colormin"]
    
    if "colormax" in kwargs:
        #output['colorAxis']={}
        output['colorAxis']['max']=kwargs["colormax"]
    
    
    
    _series={}

    _point = []
    #k=0
    
    
    
    for i in range(len(data[0])-1):
        for j in range(len(data[1])-1):
            _point.append([data[0][i], data[1][j], data[2][j][i]])
            #k=k+1
            #print([data[0][i], data[1][j], data[2][j][i]])
    
    IQxyMax=float(max(max(data[2])))   
    print(IQxyMax)
    output['colorAxis']['stops']=[]
    
    output['colorAxis']['min']=0
    output['colorAxis']['max']=float(IQxyMax)
    output['colorAxis']['stops'].append([0, '#3060cf'])
    output['colorAxis']['stops'].append([float(0.5*IQxyMax), '#fffbbc'])
    output['colorAxis']['stops'].append([float(0.9*IQxyMax), '#c4463a'])
    output['colorAxis']['stops'].append([float(1*IQxyMax), '#c4463a'])
    
    output['xAxis']['tickPositions']=[float(kwargs["xmin"]),0,float(kwargs["xmax"])]
    output['yAxis']['tickPositions']=[float(kwargs["ymin"]),0,float(kwargs["ymax"])]
    
    '''
    output['colorAxis']['max']=[]
    output['colorAxis']['max']=max(max(data[2]))
    output['colorAxis']['min']=[]
    output['colorAxis']['min']=min(min(data[2]))
    print(max(max(data[2]))
    print(min(min(data[2]))
    '''
    
    
    
    #_series['boostThreshold']=100
    _series['tooltip']={}
    _series['tooltip']['headerFormat']=''
    _series['data']=_point

    output["series"]=_series

    return output
