﻿# -*- coding: utf-8 -*-

"""
    :author: Junrong Zhang
    :copyright: © 2020 CSNS
    :license: GPL V3, see LICENSE for more details.
"""

from flask_socketio import emit, SocketIO
from flask_rq2 import RQ
myrq=RQ(burst=True)
import mantid.simpleapi as md
from .models import hcline, hcmap
from .config.development import REDIS_URL, NEXUS_PATH, IDF_PATH, CAL_PATH, PARAM_PATH


#for the searching of mask and calibration files
import os
from os import walk


prepath_data = NEXUS_PATH
prepath_read = PARAM_PATH
monsIDF = IDF_PATH
cal_file_path=CAL_PATH
mask_file_path=CAL_PATH

def find_mask_file():
    mask_files=[]
    for (root, dirs, files) in walk(mask_file_path):
        for f in files:
            if f[0:4] == "mask":
                mask_files.append(f)
    return mask_files
    
    
def find_cal_file():
    cal_files=[]
    for (root, dirs, files) in walk(cal_file_path):
        for f in files:
            if f[0:11] == "calibration":
                cal_files.append(f)
    return cal_files
               
def loadMonsWS(wsList, output):
    for ix in wsList:
        #name='RUN'+str(int(ix)).zfill(7)
        path_tmp = prepath_data+"/"+ix+"/detector.nxs"
        md.LoadCSNSNexus(Instrument = "SANS", Filename = path_tmp, OutputWorkspace = ix, Loadbank=False, Loadmonitor =True, Monitorname = "monitor2,monitor3")
        md.LoadInstrument(Workspace = ix, Filename=monsIDF, RewriteSpectraMap =True)

    for i in range(len(wsList)):
        if len(wsList)== 1:
            md.CloneWorkspace(InputWorkspace=str(wsList[i]), OutputWorkspace=output)
            md.DeleteWorkspace(Workspace=str(wsList[i]))
        elif wsList[i+1]!=wsList[-1]:
            md.Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=str(wsList[i+1]))
            md.DeleteWorkspace(Workspace=str(wsList[i]))
        else:
            md.Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=output)
            md.DeleteWorkspace(Workspace=str(wsList[i]))
            md.DeleteWorkspace(Workspace=str(wsList[i+1]))
            break

def loadMon2WS(wsList, output):
    for ix in wsList:
        #name='RUN'+str(int(ix)).zfill(7)
        path_tmp = prepath_data+"/"+ix+"/detector.nxs"
        md.LoadCSNSNexus(Instrument = "SANS", Filename = path_tmp, OutputWorkspace = ix, Loadbank=False, Loadmonitor =True, Monitorname = "monitor2")
        md.LoadInstrument(Workspace = ix, Filename=monsIDF, RewriteSpectraMap =True)

    for i in range(len(wsList)):
        if len(wsList)== 1:
            md.CloneWorkspace(InputWorkspace=str(wsList[i]), OutputWorkspace=output)
            md.DeleteWorkspace(Workspace=str(wsList[i]))
        elif wsList[i+1]!=wsList[-1]:
            md.Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=str(wsList[i+1]))
            md.DeleteWorkspace(Workspace=str(wsList[i]))
        else:
            md.Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=output)
            md.DeleteWorkspace(Workspace=str(wsList[i]))
            md.DeleteWorkspace(Workspace=str(wsList[i+1]))
            break
            
def loadDetWS(wsList,output):
    for ix in wsList:
        path_tmp = prepath_data+"/"+ix+"/detector.nxs"
        md.LoadCSNSNexus(Instrument = "SANS", Filename = path_tmp, OutputWorkspace = ix, Bankname = 'module1', Loadbank=True, Loadmonitor =False)
        md.LoadInstrument(Workspace = str(ix), Filename=prepath_read+'/detector.xml', RewriteSpectraMap =True)

    for i in range(len(wsList)):
        if len(wsList)== 1:
            md.CloneWorkspace(InputWorkspace=str(wsList[i]), OutputWorkspace=output)
            md.DeleteWorkspace(Workspace=str(wsList[i]))
        elif wsList[i+1]!=wsList[-1]:
            md.Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=str(wsList[i+1]))
            md.DeleteWorkspace(Workspace=str(wsList[i]))
        else:
            md.Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=output)
            md.DeleteWorkspace(Workspace=str(wsList[i]))
            md.DeleteWorkspace(Workspace=str(wsList[i+1]))
            break




def getWSData(wsname):
    md.ConvertToPointData(InputWorkspace=wsname,OutputWorkspace=wsname)
    _x = md.mtd[wsname].readX(0)
    _y = md.mtd[wsname].readY(0)
    return _x, _y

'''
def getWS3DData(wsname):
    md.ConvertToPointData(InputWorkspace=wsname,OutputWorkspace=wsname)
    length = len(md.mtd[wsname].readX(0))
    _x=[]
    _y=[]
    _z=[]
    
    #_x.append(md.mtd[wsname].readX(0))
    #_y.append(md.mtd[wsname].readX(0))
    _line=[]
    for i in range(length):
        #_point=[]
        _x.append(md.mtd[wsname].readX(0)[i])
        _y.append(md.mtd[wsname].readX(0)[i])
        for j in range(length):
            #_point.append(md.mtd[wsname].readY(i)[j])
            _line.append(md.mtd[wsname].readY(i)[j])
        _z.append(_line)        
        
    return _x, _y, _z
'''
def getWS3DData(wsname):
    md.ConvertToPointData(InputWorkspace=wsname,OutputWorkspace=wsname)
    length = len(md.mtd[wsname].readX(0))
    _x=[]
    _y=[]
    _z=[]
    
    #_x.append(md.mtd[wsname].readX(0))
    #_y.append(md.mtd[wsname].readX(0))
    for i in range(length):
        #_point=[]
        _x.append(md.mtd[wsname].readX(0)[i])
        _y.append(md.mtd[wsname].readX(0)[i])
        _line=[]
        for j in range(length):
            #_point.append(md.mtd[wsname].readY(i)[j])
            _line.append(md.mtd[wsname].readY(i)[j])
        _z.append(_line)        
        
    return _x, _y, _z
            
@myrq.job
def plot_trans_empty_trans(ns, data):
    #job = myrq.get_current_job()
    socket = SocketIO(message_queue=REDIS_URL)

    #=======================
    #samRun=data['trans_sample_trans_runno']
    empRun=data['trans_empty_trans_runno']
    
    #loadMonsWS(samRun, "monTranSam") 
    loadMonsWS(empRun, "monTran") 
    #md.ConvertUnits(InputWorkspace='monTranSam', OutputWorkspace='monTranSam', Target='Wavelength', AlignBins=True)
    md.ConvertUnits(InputWorkspace='monTran', OutputWorkspace='monTran', Target='Wavelength', AlignBins=True)
    wave_rebin = data["Trans_Wavelength_Min"]+","+data["Trans_Wavelength_Step"]+","+data["Trans_Wavelength_Max"]
    #md.Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam", Params=wave_rebin)
    md.Rebin(InputWorkspace='monTran', OutputWorkspace="monTran", Params=wave_rebin)
    #md.CropWorkspace(InputWorkspace='monTranSam', OutputWorkspace='sam_2',StartWorkspaceIndex=0, EndWorkspaceIndex=0)
    md.CropWorkspace(InputWorkspace='monTran', OutputWorkspace='emp_2',StartWorkspaceIndex=0, EndWorkspaceIndex=0)
    #md.CropWorkspace(InputWorkspace='monTranSam', OutputWorkspace='sam_3',StartWorkspaceIndex=1, EndWorkspaceIndex=1)
    md.CropWorkspace(InputWorkspace='monTran', OutputWorkspace='emp_3',StartWorkspaceIndex=1, EndWorkspaceIndex=1)
    
    #x is same for different spectrum, which is the wavelength
    #_,sam_2= getWSData("sam_2")
    #_,sam_3= getWSData("sam_3")
    _,emp_2= getWSData("emp_2")
    x,emp_3= getWSData("emp_3")

    _data=[]
    _data.append(x)
    #_data.append(sam_2)
    _data.append(emp_2)
    name=[]
    #name.append("sample")
    name.append("empty")
    series1 = hcline(_data, name, title="Monitor2 Spectrum", xlabel="TOF", ylabel="Intensity")

    _data=[]
    _data.append(x)
    #_data.append(sam_3)
    _data.append(emp_3)
    name=[]
    #name.append("sample")
    name.append("empty")
    series2 = hcline(_data, name, title="Monitor3 Spectrum", xlabel="TOF", ylabel="Intensity")

    series={}
    series['series1']=series1
    series['series2']=series2

    socket.emit(data['event'], series, namespace=ns)


@myrq.job
def plot_trans_sample_trans(ns, data):
    #job = myrq.get_current_job()
    socket = SocketIO(message_queue=REDIS_URL)

    #=======================
    samRun=data['trans_sample_trans_runno']
    #empRun=data['trans_empty_trans_runno']
    
    loadMonsWS(samRun, "monTranSam") 
    #loadMonsWS(empRun, "monTran") 
    md.ConvertUnits(InputWorkspace='monTranSam', OutputWorkspace='monTranSam', Target='Wavelength', AlignBins=True)
    #md.ConvertUnits(InputWorkspace='monTran', OutputWorkspace='monTran', Target='Wavelength', AlignBins=True)
    wave_rebin = data["Trans_Wavelength_Min"]+","+data["Trans_Wavelength_Step"]+","+data["Trans_Wavelength_Max"]
    md.Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam", Params=wave_rebin)
    #md.Rebin(InputWorkspace='monTran', OutputWorkspace="monTran", Params=wave_rebin)
    md.CropWorkspace(InputWorkspace='monTranSam', OutputWorkspace='sam_2',StartWorkspaceIndex=0, EndWorkspaceIndex=0)
    #md.CropWorkspace(InputWorkspace='monTran', OutputWorkspace='emp_2',StartWorkspaceIndex=0, EndWorkspaceIndex=0)
    md.CropWorkspace(InputWorkspace='monTranSam', OutputWorkspace='sam_3',StartWorkspaceIndex=1, EndWorkspaceIndex=1)
    #md.CropWorkspace(InputWorkspace='monTran', OutputWorkspace='emp_3',StartWorkspaceIndex=1, EndWorkspaceIndex=1)

    _,sam_2= getWSData("sam_2")
    x,sam_3= getWSData("sam_3")
    #_,emp_2= getWSData("emp_2")
    #x,emp_3= getWSData("emp_3")

    _data=[]
    _data.append(x)
    _data.append(sam_2)
    #_data.append(emp_2)
    name=[]
    name.append("sample")
    #name.append("empty")
    series1 = hcline(_data, name, title="Monitor2 Spectrum", xlabel="TOF", ylabel="Intensity")

    _data=[]
    _data.append(x)
    _data.append(sam_3)
    #_data.append(emp_3)
    name=[]
    name.append("sample")
    #name.append("empty")
    series2 = hcline(_data, name, title="Monitor3 Spectrum", xlabel="TOF", ylabel="Intensity")

    series={}
    series['series1']=series1
    series['series2']=series2

    socket.emit(data['event'], series, namespace=ns)


@myrq.job
def plot_trans_emptycell_trans(ns, data):
    #job = myrq.get_current_job()
    socket = SocketIO(message_queue=REDIS_URL)

    #=======================
    samRun=data['trans_emptycell_trans_runno']
    #empRun=data['trans_empty_trans_runno']
    
    loadMonsWS(samRun, "monTranSam") 
    #loadMonsWS(empRun, "monTran") 
    md.ConvertUnits(InputWorkspace='monTranSam', OutputWorkspace='monTranSam', Target='Wavelength', AlignBins=True)
    #md.ConvertUnits(InputWorkspace='monTran', OutputWorkspace='monTran', Target='Wavelength', AlignBins=True)
    wave_rebin = data["Trans_Wavelength_Min"]+","+data["Trans_Wavelength_Step"]+","+data["Trans_Wavelength_Max"]
    md.Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam", Params=wave_rebin)
    #md.Rebin(InputWorkspace='monTran', OutputWorkspace="monTran", Params=wave_rebin)
    md.CropWorkspace(InputWorkspace='monTranSam', OutputWorkspace='sam_2',StartWorkspaceIndex=0, EndWorkspaceIndex=0)
    #md.CropWorkspace(InputWorkspace='monTran', OutputWorkspace='emp_2',StartWorkspaceIndex=0, EndWorkspaceIndex=0)
    md.CropWorkspace(InputWorkspace='monTranSam', OutputWorkspace='sam_3',StartWorkspaceIndex=1, EndWorkspaceIndex=1)
    #md.CropWorkspace(InputWorkspace='monTran', OutputWorkspace='emp_3',StartWorkspaceIndex=1, EndWorkspaceIndex=1)

    _,sam_2= getWSData("sam_2")
    x,sam_3= getWSData("sam_3")
    #_,emp_2= getWSData("emp_2")
    #x,emp_3= getWSData("emp_3")

    _data=[]
    _data.append(x)
    _data.append(sam_2)
    #_data.append(emp_2)
    name=[]
    name.append("emptycell")
    #name.append("empty")
    series1 = hcline(_data, name, title="Monitor2 Spectrum", xlabel="TOF", ylabel="Intensity")

    _data=[]
    _data.append(x)
    _data.append(sam_3)
    #_data.append(emp_3)
    name=[]
    name.append("emptycell")
    #name.append("empty")
    series2 = hcline(_data, name, title="Monitor3 Spectrum", xlabel="TOF", ylabel="Intensity")

    series={}
    series['series1']=series1
    series['series2']=series2

    socket.emit(data['event'], series, namespace=ns)


@myrq.job
def plot_trans_solvent_trans(ns, data):
    #job = myrq.get_current_job()
    socket = SocketIO(message_queue=REDIS_URL)

    #=======================
    samRun=data['trans_solvent_trans_runno']
    #empRun=data['trans_empty_trans_runno']
    
    loadMonsWS(samRun, "monTranSam") 
    #loadMonsWS(empRun, "monTran") 
    md.ConvertUnits(InputWorkspace='monTranSam', OutputWorkspace='monTranSam', Target='Wavelength', AlignBins=True)
    #md.ConvertUnits(InputWorkspace='monTran', OutputWorkspace='monTran', Target='Wavelength', AlignBins=True)
    wave_rebin = data["Trans_Wavelength_Min"]+","+data["Trans_Wavelength_Step"]+","+data["Trans_Wavelength_Max"]
    md.Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam", Params=wave_rebin)
    #md.Rebin(InputWorkspace='monTran', OutputWorkspace="monTran", Params=wave_rebin)
    md.CropWorkspace(InputWorkspace='monTranSam', OutputWorkspace='sam_2',StartWorkspaceIndex=0, EndWorkspaceIndex=0)
    #md.CropWorkspace(InputWorkspace='monTran', OutputWorkspace='emp_2',StartWorkspaceIndex=0, EndWorkspaceIndex=0)
    md.CropWorkspace(InputWorkspace='monTranSam', OutputWorkspace='sam_3',StartWorkspaceIndex=1, EndWorkspaceIndex=1)
    #md.CropWorkspace(InputWorkspace='monTran', OutputWorkspace='emp_3',StartWorkspaceIndex=1, EndWorkspaceIndex=1)

    _,sam_2= getWSData("sam_2")
    x,sam_3= getWSData("sam_3")
    #_,emp_2= getWSData("emp_2")
    #x,emp_3= getWSData("emp_3")

    _data=[]
    _data.append(x)
    _data.append(sam_2)
    #_data.append(emp_2)
    name=[]
    name.append("solvent")
    #name.append("empty")
    series1 = hcline(_data, name, title="Monitor2 Spectrum", xlabel="TOF", ylabel="Intensity")

    _data=[]
    _data.append(x)
    _data.append(sam_3)
    #_data.append(emp_3)
    name=[]
    name.append("solvent")
    #name.append("empty")
    series2 = hcline(_data, name, title="Monitor3 Spectrum", xlabel="TOF", ylabel="Intensity")

    series={}
    series['series1']=series1
    series['series2']=series2

    socket.emit(data['event'], series, namespace=ns)


@myrq.job
def cal_trans(ns, data):
    #job = myrq.get_current_job()
    socket = SocketIO(message_queue=REDIS_URL)
    print(data)
    
    series={}
    
    samRun=data['trans_sample_trans_runno']
    empRun=data['trans_empty_trans_runno']
    #bool emptycellChecked
    emptycellChecked=data['is_emptycell']
    #bool solventChecked
    solventChecked=data['is_solvent']
    #print(data['is_emptycell'])
    
    loadMonsWS(samRun, "monTranSam") 
    loadMonsWS(empRun, "monTran") 
    md.ConvertUnits(InputWorkspace='monTranSam', OutputWorkspace='monTranSam', Target='Wavelength', AlignBins=True)
    md.ConvertUnits(InputWorkspace='monTran', OutputWorkspace='monTran', Target='Wavelength', AlignBins=True)
    wave_rebin = data["Trans_Wavelength_Min"]+","+data["Trans_Wavelength_Step"]+','+data["Trans_Wavelength_Max"]
    md.Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam", Params=wave_rebin)
    md.Rebin(InputWorkspace='monTran', OutputWorkspace="monTran", Params=wave_rebin)
    md.CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace='ans_sam', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
    
    fitMethod = data["Trans_TransFittingMethod"]
    if fitMethod == "Smooth":
        smoothNP = data["Trans_Smooth_Ns"]
        md.SmoothData(InputWorkspace='ans_sam_unfitted', OutputWorkspace='ans_sam_unfitted', NPoints=smoothNP)
    elif fitMethod == "Linear":
        md.CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace='ans_sam', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Linear', OutputUnfittedData=True)
    elif fitMethod == "Raw":
        pass
    else:
        md.CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace='ans_sam', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)

    
    _, p_cal = getWSData("ans_sam")
    x, p_raw = getWSData("ans_sam_unfitted")
    
    _data=[]
    _data.append(x)
    _data.append(p_cal)
    _data.append(p_raw)
    name=[]
    name.append("sample_fitted")
    name.append("sample_raw")
    
    
    
    '''
    _dataSampleRaw=[]
    _dataSampleRaw.append(x)
    _dataSampleRaw.append(p_raw)
    name=[]
    name.append("sample_raw")
    
    series1 = hcline(_dataSampleRaw, name, title="Transmission", xlabel="lambda(AA)", ylabel="Trans")
    series['series1']=series1
    
    _dataSampleFitted=[]
    _dataSampleFitted.append(x)
    _dataSampleFitted.append(p_cal)
    name=[]
    name.append("sample_fitted")
    
    series2 = hcline(_dataSampleRaw, name, title="Transmission", xlabel="lambda(AA)", ylabel="Trans")
    series['series2']=series2
    '''
    
    if (emptycellChecked):
        emptycellRun=data['trans_emptycell_trans_runno']
        loadMonsWS(emptycellRun, "monTranEmptycell")
        md.ConvertUnits(InputWorkspace='monTranEmptycell', OutputWorkspace='monTranEmptycell', Target='Wavelength', AlignBins=True)
        md.Rebin(InputWorkspace='monTranEmptycell', OutputWorkspace="monTranEmptycell", Params=wave_rebin)
        print(wave_rebin)
        md.CalculateTransmission(SampleRunWorkspace='monTranEmptycell', DirectRunWorkspace='monTran', OutputWorkspace='ans_emptycell', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
        fitMethod = data["Trans_TransFittingMethod"]
        if fitMethod == "Smooth":
            smoothNP = data["Trans_Smooth_Ns"]
            md.SmoothData(InputWorkspace='ans_emptycell_unfitted', OutputWorkspace='ans_emptycell_unfitted', NPoints=smoothNP)
        elif fitMethod == "Linear":
            md.CalculateTransmission(SampleRunWorkspace='monTranEmptycell', DirectRunWorkspace='monTran', OutputWorkspace='ans_emptycell', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Linear', OutputUnfittedData=True)
        elif fitMethod == "Raw":
            pass
        else:
            md.CalculateTransmission(SampleRunWorkspace='monTranEmptycell', DirectRunWorkspace='monTran', OutputWorkspace='ans_emptycell', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
        
        x, p1_cal = getWSData("ans_emptycell")
        _, p1_raw = getWSData("ans_emptycell_unfitted")
        
        #_data=[]
        #_data.append(x)
        _data.append(p1_cal)
        _data.append(p1_raw)
        
        #name=[]
        name.append("emptycell_fitted")
        name.append("emptycell_raw")
        
        
        
        '''
        _dataEmptycellRaw=[]
        _dataEmptycellRaw.append(x)
        _dataEmptycellRaw.append(p_raw)
        name=[]
        name.append("emptycell_raw")
    
        series3 = hcline(_dataEmptycellRaw, name, title="Transmission", xlabel="lambda(AA)", ylabel="Trans")
        series['series3']=series3
        
        
        _dataEmptycellFitted=[]
        _dataEmptycellFitted.append(x)
        _dataEmptycellFitted.append(p_cal)
        name=[]
        name.append("emptycell_fitted")
        
        series4 = hcline(_dataEmptycellFitted, name, title="Transmission", xlabel="lambda(AA)", ylabel="Trans")
        series['series4']=series4
        '''
        
    if (solventChecked):
        emptycellRun=data['trans_solvent_trans_runno']
        loadMonsWS(emptycellRun, "monTranSolvent")
        md.ConvertUnits(InputWorkspace='monTranSolvent', OutputWorkspace='monTranSolvent', Target='Wavelength', AlignBins=True)
        md.Rebin(InputWorkspace='monTranSolvent', OutputWorkspace="monTranSolvent", Params=wave_rebin)
        md.CalculateTransmission(SampleRunWorkspace='monTranSolvent', DirectRunWorkspace='monTran', OutputWorkspace='ans_solvent', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
        fitMethod = data["Trans_TransFittingMethod"]
        if fitMethod == "Smooth":
            smoothNP = data["Trans_Smooth_Ns"]
            md.SmoothData(InputWorkspace='ans_solvent_unfitted', OutputWorkspace='ans_solvent_unfitted', NPoints=smoothNP)
        elif fitMethod == "Linear":
            md.CalculateTransmission(SampleRunWorkspace='monTranSolvent', DirectRunWorkspace='monTran', OutputWorkspace='ans_solvent', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Linear', OutputUnfittedData=True)
        elif fitMethod == "Raw":
            pass
        else:
            md.CalculateTransmission(SampleRunWorkspace='monTranSolvent', DirectRunWorkspace='monTran', OutputWorkspace='ans_solvent', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
        
        _, p_cal = getWSData("ans_solvent")
        x, p_raw = getWSData("ans_solvent_unfitted")
        
        _data=_data
        _data.append(p_cal)
        _data.append(p_raw)
    
        name.append("solvent_fitted")
        name.append("solvent_raw")
        
        
        
        '''
        _dataSolventRaw=[]
        _dataSolventRaw.append(x)
        _dataSolventRaw.append(p_raw)
        name=[]
        name.append("solvent_raw")
    
        series5 = hcline(_dataSolventRaw, name, title="Transmission", xlabel="lambda(AA)", ylabel="Trans")
        series['series5']=series5
        
        
        _dataSolventFitted=[]
        _dataSolventFitted.append(x)
        _dataSolventFitted.append(p_cal)
        name=[]
        name.append("solvent_fitted")
    
        series6 = hcline(_dataSolventFitted, name, title="Transmission", xlabel="lambda(AA)", ylabel="Trans")
        series['series6']=series6
        '''
        
    
    
    series = hcline(_data, name, title="Transmission", xlabel="Wavelength (AA)", ylabel="Intensity")
 
    socket.emit(data['event'], series, namespace=ns)


@myrq.job
def cal_iq(ns, data):
    
    socket = SocketIO(message_queue=REDIS_URL)
    
    print(data)
    
    
    samRun=data['iq_sample_trans_runno']
    empRun=data['iq_empty_trans_runno']
    samScat=data['iq_sample_scatt_runno']
    empScat=data['iq_empty_direct_runno']
    emptycellChecked=data['is_emptycell']
    solventChecked=data['is_solvent']
    cal_file=data['calibration_file']
    mask_file=data['mask_file']
    iq_thickness=data['iq_thickness']
    iq_diameter=6.8#should be read from calfile, next step.
    
    
    volume=3.14*(float(iq_diameter)/20.0)**2*(float(iq_thickness)/10.0)
    md.CreateSingleValuedWorkspace(DataValue=volume, OutputWorkspace='volume')
    
    loadMonsWS(samRun, "monTranSam") 
    loadMonsWS(empRun, "monTran") 
    md.ConvertUnits(InputWorkspace='monTranSam', OutputWorkspace='monTranSam', Target='Wavelength', AlignBins=True)
    md.ConvertUnits(InputWorkspace='monTran', OutputWorkspace='monTran', Target='Wavelength', AlignBins=True)
    wave_rebin = data["iq_Trans_Wavelength_Min"]+","+data["iq_Trans_Wavelength_Step"]+','+data["iq_Trans_Wavelength_Max"]
    md.Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam", Params=wave_rebin)
    md.Rebin(InputWorkspace='monTran', OutputWorkspace="monTran", Params=wave_rebin)


    md.CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace='ans', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
    
    
    
    fitMethod = data["iq_Trans_TransFittingMethod"]
    if fitMethod == "Smooth":
        smoothNP = data["Trans_Smooth_Ns"]
        md.SmoothData(InputWorkspace='ans_unfitted', OutputWorkspace='ans_unfitted', NPoints=smoothNP)
    elif fitMethod == "Linear":
        md.CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace='ans', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Linear', OutputUnfittedData=True)
    elif fitMethod == "Raw":
        pass
    else:
        md.CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace='ans', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)

    
    
    loadDetWS(samScat, "ScatSam") 
    loadDetWS(empScat, "ScatEmp") 
    md.LoadInstrument(Workspace='ScatSam', Filename=prepath_read+'/detector.xml', RewriteSpectraMap=True)
    
    
    md.LoadAscii(Filename=cal_file_path+'/'+cal_file, OutputWorkspace='cal', Separator='Automatic', Unit='Wavelength')
    md.ConvertToHistogram(InputWorkspace='cal', OutputWorkspace='cal')
    md.Rebin(InputWorkspace='cal', OutputWorkspace='cal', Params=wave_rebin)
    
    Q_rebin=data["iq_q_min"]+","+data["iq_q_step"]+','+data["iq_q_max"]
    
    
    mask=md.LoadMask(Instrument=prepath_read+'/detector.xml', InputFile=prepath_read+'/'+mask_file)
    md.MaskDetectors(Workspace='ScatSam', MaskedWorkspace=mask)
    md.MaskDetectors(Workspace='ScatEmp', MaskedWorkspace=mask)
    
    md.ConvertUnits(InputWorkspace="ScatSam", OutputWorkspace="ScatSam", Target="Wavelength", AlignBins=True)
    md.ConvertUnits(InputWorkspace="ScatEmp", OutputWorkspace="ScatEmp", Target="Wavelength", AlignBins=True)
    
    md.Rebin(InputWorkspace='ScatSam',OutputWorkspace='ScatSam',Params=wave_rebin)
    md.Rebin(InputWorkspace='ScatEmp',OutputWorkspace='ScatEmp',Params=wave_rebin)
    
    loadMon2WS(samScat, "M2Sam") 
    loadMon2WS(empScat, "M2Emp")
    
    nameMon=md.mtd['M2Sam']
    counts=sum(nameMon.readY(0))*1.0
    #print(counts)
    md.CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
    md.Divide(LHSWorkspace='ScatSam', RHSWorkspace='m2', OutputWorkspace='ScatSamNormalized', AllowDifferentNumberSpectra=True)
    md.ApplyTransmissionCorrection(InputWorkspace='ScatSamNormalized',TransmissionWorkspace='ans',OutputWorkspace='ScatSamNormalized',ThetaDependent=True)
    md.DeleteWorkspace(Workspace='m2')
    #print(volume)
    md.Divide(LHSWorkspace='ScatSamNormalized', RHSWorkspace='cal', OutputWorkspace='ScatSam_cal', AllowDifferentNumberSpectra=True)
    md.Divide(LHSWorkspace='ScatSam_cal', RHSWorkspace='volume', OutputWorkspace='ScatSam_final', AllowDifferentNumberSpectra=True)
    md.Q1D(DetBankWorkspace="ScatSam_final", OutputWorkspace="IQ_ScatSam", OutputBinning=Q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
    md.ReplaceSpecialValues(InputWorkspace="IQ_ScatSam", OutputWorkspace="IQ_ScatSam", NaNValue=0, InfinityValue=0)
    
    x, iq1 = getWSData("IQ_ScatSam")
    #print(iq1)
    
    
    
    
    nameMon=md.mtd['M2Emp']
    counts=sum(nameMon.readY(0))*1.0
    #print(counts)
    md.CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
    md.Divide(LHSWorkspace='ScatEmp', RHSWorkspace='m2', OutputWorkspace='ScatEmpNormalized', AllowDifferentNumberSpectra=True)
    md.DeleteWorkspace(Workspace='m2')
    #print(volume)
    md.Divide(LHSWorkspace='ScatEmpNormalized', RHSWorkspace='cal', OutputWorkspace='ScatEmp_cal', AllowDifferentNumberSpectra=True)
    md.Divide(LHSWorkspace='ScatEmp_cal', RHSWorkspace='volume', OutputWorkspace='ScatEmp_final', AllowDifferentNumberSpectra=True)
    md.Q1D(DetBankWorkspace="ScatEmp_final", OutputWorkspace="IQ_ScatEmp", OutputBinning=Q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
    md.ReplaceSpecialValues(InputWorkspace="IQ_ScatEmp", OutputWorkspace="IQ_ScatEmp", NaNValue=0, InfinityValue=0)
    
    x, iq2 = getWSData("IQ_ScatEmp")
    #print(iq2)
    
    md.Minus(LHSWorkspace='IQ_ScatSam', RHSWorkspace='IQ_ScatEmp',OutputWorkspace='IQ_ScatSam_EmpSub')
    
    x, iq = getWSData("IQ_ScatSam_EmpSub")
    
    _data=[]
    _data.append(x)
    _data.append(iq)
    
    name=[]
    name.append("IQ_SamSubEmp")
    
    series={}
    
    
    
    #series = hcline(_data, name, title="IQ", xlabel="wavelength(AA)", ylabel="Intensity")
    
    
    
    
    if (emptycellChecked):
        
        emptycellRun=data['iq_emptycell_trans_runno']
        emptycellScat=data['iq_emptycell_scatt_runno']
        
        loadMonsWS(emptycellRun, "monTranEmptycell")
        
        loadDetWS(emptycellScat, "ScatEC")
        
        
        md.ConvertUnits(InputWorkspace='monTranEmptycell', OutputWorkspace='monTranEmptycell', Target='Wavelength', AlignBins=True)
        md.Rebin(InputWorkspace='monTranEmptycell', OutputWorkspace="monTranEmptycell", Params=wave_rebin)
        md.CalculateTransmission(SampleRunWorkspace='monTranEmptycell', DirectRunWorkspace='monTran', OutputWorkspace='ans_ec', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
        if fitMethod == "Smooth":
            smoothNP = data["Trans_Smooth_Ns"]
            md.SmoothData(InputWorkspace='ans_ec_unfitted', OutputWorkspace='ans_ec_unfitted', NPoints=smoothNP)
        elif fitMethod == "Linear":
            md.CalculateTransmission(SampleRunWorkspace='monTranEmptycell', DirectRunWorkspace='monTran', OutputWorkspace='ans_ec', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Linear', OutputUnfittedData=True)
        elif fitMethod == "Raw":
            pass
        else:
            md.CalculateTransmission(SampleRunWorkspace='monTranEmptycell', DirectRunWorkspace='monTran', OutputWorkspace='ans_ec', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
            
            
        md.MaskDetectors(Workspace='ScatEC', MaskedWorkspace=mask)
    
        md.ConvertUnits(InputWorkspace="ScatEC", OutputWorkspace="ScatEC", Target="Wavelength", AlignBins=True)
    
        md.Rebin(InputWorkspace='ScatEC',OutputWorkspace='ScatEC',Params=wave_rebin)
     
        
        loadMon2WS(emptycellScat, "M2EC")
        nameMon=md.mtd['M2EC']
        counts=sum(nameMon.readY(0))*1.0
        md.CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
        md.Divide(LHSWorkspace='ScatEC', RHSWorkspace='m2', OutputWorkspace='ScatEmptycellNormalized', AllowDifferentNumberSpectra=True)
        md.ApplyTransmissionCorrection(InputWorkspace='ScatEmptycellNormalized',TransmissionWorkspace='ans_ec',OutputWorkspace='ScatEmptycellNormalized',ThetaDependent=True)
        md.DeleteWorkspace(Workspace='m2')
        md.Divide(LHSWorkspace='ScatEmptycellNormalized', RHSWorkspace='cal', OutputWorkspace='ScatEmptycell_cal', AllowDifferentNumberSpectra=True)
        md.Divide(LHSWorkspace='ScatEmptycell_cal', RHSWorkspace='volume', OutputWorkspace='ScatEmptycell_final', AllowDifferentNumberSpectra=True)
        md.Q1D(DetBankWorkspace="ScatEmptycell_final", OutputWorkspace="IQ_ScatEmptycell", OutputBinning=Q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
        md.ReplaceSpecialValues(InputWorkspace="IQ_ScatEmptycell", OutputWorkspace="IQ_ScatEmptycell", NaNValue=0, InfinityValue=0)
        
        md.Minus(LHSWorkspace='IQ_ScatEmptycell', RHSWorkspace='IQ_ScatEmp',OutputWorkspace='IQ_ScatEC_EmpSub')    
            
        x2, iq2 = getWSData("IQ_ScatEC_EmpSub")    
           
        
        
        #_data.append(x2)
        _data.append(iq2)
        
        name.append("IQ_ECSubEmp")   
    
    if (solventChecked):
    
        volumeFraction=float(data['iq_solvent_volumefraction'])
        md.CreateSingleValuedWorkspace(DataValue=volumeFraction, OutputWorkspace='volumeFraction')
        
        solventRun=data['iq_solvent_trans_runno']
        solventScat=data['iq_solvent_scatt_runno']
        
        loadMonsWS(solventRun, "monTranSolvent")
        
        loadDetWS(solventScat, "ScatSol")
        
        
        md.ConvertUnits(InputWorkspace='monTranSolvent', OutputWorkspace='monTranSolvent', Target='Wavelength', AlignBins=True)
        md.Rebin(InputWorkspace='monTranSolvent', OutputWorkspace="monTranSolvent", Params=wave_rebin)
        md.CalculateTransmission(SampleRunWorkspace='monTranSolvent', DirectRunWorkspace='monTran', OutputWorkspace='ans_sol', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
        if fitMethod == "Smooth":
            smoothNP = data["Trans_Smooth_Ns"]
            md.SmoothData(InputWorkspace='ans_sol_unfitted', OutputWorkspace='ans_sol_unfitted', NPoints=smoothNP)
        elif fitMethod == "Linear":
            md.CalculateTransmission(SampleRunWorkspace='monTranSolvent', DirectRunWorkspace='monTran', OutputWorkspace='ans_sol', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Linear', OutputUnfittedData=True)
        elif fitMethod == "Raw":
            pass
        else:
            md.CalculateTransmission(SampleRunWorkspace='monTranSolvent', DirectRunWorkspace='monTran', OutputWorkspace='ans_sol', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
            
            
        md.MaskDetectors(Workspace='ScatSol', MaskedWorkspace=mask)
    
        md.ConvertUnits(InputWorkspace="ScatSol", OutputWorkspace="ScatSol", Target="Wavelength", AlignBins=True)
    
        md.Rebin(InputWorkspace='ScatSol',OutputWorkspace='ScatSol',Params=wave_rebin)
     
        
        loadMon2WS(solventScat, "M2Sol")
        nameMon=md.mtd['M2Sol']
        counts=sum(nameMon.readY(0))*1.0
        md.CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
        md.Divide(LHSWorkspace='ScatSol', RHSWorkspace='m2', OutputWorkspace='ScatSolventNormalized', AllowDifferentNumberSpectra=True)
        md.ApplyTransmissionCorrection(InputWorkspace='ScatSolventNormalized',TransmissionWorkspace='ans_sol',OutputWorkspace='ScatSolventNormalized',ThetaDependent=True)
        md.DeleteWorkspace(Workspace='m2')
        md.Divide(LHSWorkspace='ScatSolventNormalized', RHSWorkspace='cal', OutputWorkspace='ScatSolvent_cal', AllowDifferentNumberSpectra=True)
        md.Divide(LHSWorkspace='ScatSolvent_cal', RHSWorkspace='volume', OutputWorkspace='ScatSolvent_final', AllowDifferentNumberSpectra=True)
        md.Q1D(DetBankWorkspace="ScatSolvent_final", OutputWorkspace="IQ_ScatSolvent", OutputBinning=Q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
        md.ReplaceSpecialValues(InputWorkspace="IQ_ScatSolvent", OutputWorkspace="IQ_ScatSolvent", NaNValue=0, InfinityValue=0)
        
        md.Minus(LHSWorkspace='IQ_ScatSolvent', RHSWorkspace='IQ_ScatEmp',OutputWorkspace='IQ_ScatSol_EmpSub')    
            
        x3, iq3 = getWSData("IQ_ScatSol_EmpSub") 
           
        
        
        #_data.append(x2)
        _data.append(iq3)
        
        name.append("IQ_SolSubEmp") 
        
        md.Multiply(LHSWorkspace='IQ_ScatSol_EmpSub', RHSWorkspace='volumeFraction', OutputWorkspace='IQ_ScatSol_EmpSub_VF', AllowDifferentNumberSpectra=True)
        md.Minus(LHSWorkspace='IQ_ScatSam_EmpSub', RHSWorkspace='IQ_ScatSol_EmpSub_VF',OutputWorkspace='IQ_Scat_Solute')  
        x4, iq4 = getWSData("IQ_Scat_Solute")   
        
        _data.append(iq4)
        name.append("IQ_Solute") 
        
        
    
    
    
    
    
    
    
    
    
    
    
    
    
    '''
    print(x)
    print(iq)
    '''
    #print(_data)
    #print(name)
    series = hcline(_data, name, title="IQ", xlabel="Q(AA-1)", ylabel="Intensity")
    socket.emit(data['event'], series, namespace=ns)


@myrq.job
def cal_iq2d(ns, data):
    
    socket = SocketIO(message_queue=REDIS_URL)
    
    #print(data)
    
    
    samRun=data['iq2d_sample_trans_runno']
    empRun=data['iq2d_empty_trans_runno']
    samScat=data['iq2d_sample_scatt_runno']
    empScat=data['iq2d_empty_direct_runno']
    emptycellChecked=data['is_emptycell']
    solventChecked=data['is_solvent']
    cal_file=data['calibration_file']
    mask_file=data['mask_file']
    iq2d_thickness=data['iq2d_thickness']
    iq2d_diameter=6.8#should be read from calfile, next step.
    
    QxyMax=float(data['iq2d_q_max'])
    Qstep=float(data['iq2d_q_step'])
    
    volume=3.14*(float(iq2d_diameter)/20.0)**2*(float(iq2d_thickness)/10.0)
    md.CreateSingleValuedWorkspace(DataValue=volume, OutputWorkspace='volume')
    
    loadMonsWS(samRun, "monTranSam") 
    loadMonsWS(empRun, "monTran") 
    md.ConvertUnits(InputWorkspace='monTranSam', OutputWorkspace='monTranSam', Target='Wavelength', AlignBins=True)
    md.ConvertUnits(InputWorkspace='monTran', OutputWorkspace='monTran', Target='Wavelength', AlignBins=True)
    wave_rebin = data["iq2d_Trans_Wavelength_Min"]+","+data["iq2d_Trans_Wavelength_Step"]+','+data["iq2d_Trans_Wavelength_Max"]
    md.Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam", Params=wave_rebin)
    md.Rebin(InputWorkspace='monTran', OutputWorkspace="monTran", Params=wave_rebin)


    md.CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace='ans', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
    
    
    
    fitMethod = data["iq2d_Trans_TransFittingMethod"]
    if fitMethod == "Smooth":
        smoothNP = data["Trans_Smooth_Ns"]
        md.SmoothData(InputWorkspace='ans_unfitted', OutputWorkspace='ans_unfitted', NPoints=smoothNP)
    elif fitMethod == "Linear":
        md.CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace='ans', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Linear', OutputUnfittedData=True)
    elif fitMethod == "Raw":
        pass
    else:
        md.CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace='ans', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)

    
    
    loadDetWS(samScat, "ScatSam") 
    loadDetWS(empScat, "ScatEmp") 
    md.LoadInstrument(Workspace='ScatSam', Filename=prepath_read+'/detector.xml', RewriteSpectraMap=True)
    md.LoadInstrument(Workspace='ScatEmp', Filename=prepath_read+'/detector.xml', RewriteSpectraMap=True)
    
    
    md.LoadAscii(Filename=cal_file_path+'/'+cal_file, OutputWorkspace='cal', Separator='Automatic', Unit='Wavelength')
    md.ConvertToHistogram(InputWorkspace='cal', OutputWorkspace='cal')
    md.Rebin(InputWorkspace='cal', OutputWorkspace='cal', Params=wave_rebin)
    
    #Q_rebin=data["iq2d_q_min"]+","+data["iq2d_q_step"]+','+data["iq2d_q_max"]
    
    
    mask=md.LoadMask(Instrument=prepath_read+'/detector.xml', InputFile=prepath_read+'/'+mask_file)
    md.MaskDetectors(Workspace='ScatSam', MaskedWorkspace=mask)
    md.MaskDetectors(Workspace='ScatEmp', MaskedWorkspace=mask)
    
    md.ConvertUnits(InputWorkspace="ScatSam", OutputWorkspace="ScatSam", Target="Wavelength", AlignBins=True)
    md.ConvertUnits(InputWorkspace="ScatEmp", OutputWorkspace="ScatEmp", Target="Wavelength", AlignBins=True)
    
    md.Rebin(InputWorkspace='ScatSam',OutputWorkspace='ScatSam',Params=wave_rebin)
    md.Rebin(InputWorkspace='ScatEmp',OutputWorkspace='ScatEmp',Params=wave_rebin)
    
    loadMon2WS(samScat, "M2Sam") 
    loadMon2WS(empScat, "M2Emp")
    
    nameMon=md.mtd['M2Sam']
    counts=sum(nameMon.readY(0))*1.0
    md.CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
    md.Divide(LHSWorkspace='ScatSam', RHSWorkspace='m2', OutputWorkspace='ScatSamNormalized', AllowDifferentNumberSpectra=True)
    md.ApplyTransmissionCorrection(InputWorkspace='ScatSamNormalized',TransmissionWorkspace='ans',OutputWorkspace='ScatSamNormalized',ThetaDependent=True)
    md.DeleteWorkspace(Workspace='m2')
    md.Divide(LHSWorkspace='ScatSamNormalized', RHSWorkspace='cal', OutputWorkspace='ScatSam_cal', AllowDifferentNumberSpectra=True)
    md.Divide(LHSWorkspace='ScatSam_cal', RHSWorkspace='volume', OutputWorkspace='ScatSam_final', AllowDifferentNumberSpectra=True)
    md.Qxy(InputWorkspace="ScatSam_final", OutputWorkspace="IQ_ScatSam", MaxQxy=QxyMax, DeltaQ=Qstep)
    md.ReplaceSpecialValues(InputWorkspace="IQ_ScatSam", OutputWorkspace="IQ_ScatSam", NaNValue=0, InfinityValue=0)
    
    
    
    
    
    nameMon=md.mtd['M2Emp']
    counts=sum(nameMon.readY(0))*1.0
    md.CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
    md.Divide(LHSWorkspace='ScatEmp', RHSWorkspace='m2', OutputWorkspace='ScatEmpNormalized', AllowDifferentNumberSpectra=True)
    md.DeleteWorkspace(Workspace='m2')
    md.Divide(LHSWorkspace='ScatEmpNormalized', RHSWorkspace='cal', OutputWorkspace='ScatEmp_cal', AllowDifferentNumberSpectra=True)
    md.Divide(LHSWorkspace='ScatEmp_cal', RHSWorkspace='volume', OutputWorkspace='ScatEmp_final', AllowDifferentNumberSpectra=True) 
    md.Qxy(InputWorkspace="ScatEmp_final", OutputWorkspace="IQ_ScatEmp", MaxQxy=QxyMax, DeltaQ=Qstep)
    md.ReplaceSpecialValues(InputWorkspace="IQ_ScatEmp", OutputWorkspace="IQ_ScatEmp", NaNValue=0, InfinityValue=0)
    
    md.Minus(LHSWorkspace='IQ_ScatSam', RHSWorkspace='IQ_ScatEmp',OutputWorkspace='IQ2D_ScatSam_EmpSub')
    
    #md.ConvertToPointData(InputWorkspace='IQ2D_ScatSam_EmpSub',OutputWorkspace='IQ2D_ScatSam_EmpSub')
    
    Qx,Qy,IQ=getWS3DData("IQ2D_ScatSam_EmpSub")
    
    _data=[]
    _data.append([a*10.0 for a in Qx])
    _data.append([a*10.0 for a in Qy])
    _data.append(IQ)
    '''
    print(Qx)
    print(Qy)
    #print(_data)
    '''
    
    
    
    '''
    Qxy, iq2d = getWSData("IQ2D_ScatSam_EmpSub")
    
    _data=[]
    _data.append(Qxy)
    _data.append(iq2d)
    '''
    
    series={}   
    #print(_data)
    #print(name)
    series = hcmap(_data, title="IQ2D", xlabel="Qx(nm-1)", ylabel="Qy(nm-1)", xmin=-float(10.0*QxyMax),xmax=float(10.0*QxyMax),ymin=-float(10.0*QxyMax),ymax=float(10.0*QxyMax))
    socket.emit(data['event'], series, namespace=ns)   
    
    
    
    
    
    
    
    
    
    
    

    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    






'''
@myrq.job
def find_mask_file(ns):
    mask_files=[]
    for (root, dirs, files) in walk(mask_file_path):
        for f in files:
            if f[-1:4] = "mask":
                mask_files.append(f)
            
        
    socket.emit(data['event'], mask_files, namespace=ns)
'''