# -*- coding: utf-8 -*-

"""
    :author: Junrong Zhang
    :copyright: © 2020 CSNS
    :license: GPL V3, see LICENSE for more details.
"""

from app.sans import sans_bp

import os
import sys
import random
import time
from flask import session, render_template, url_for, send_from_directory, request, flash
from flask_login import LoginManager, current_user, login_required, login_user, logout_user
from flask_socketio import emit, Namespace
#from auth import PermissionChecker
#from auth_helper import app, clearSession, icatHelper, socketio
import signal
import rq
import psutil
import redis
from app.jobs import plotTrans, calcTrans
from flask import current_app as app
from app.auth import icat_helper, auth_helper, auth
from app import socketio

global ipList
ipList={}
global nsList
nsList={}

class myNamespace(Namespace):
    def __init__(self, namespace=None, check=False):
        super().__init__()
        self.namespace = namespace

    def on_trans_plot(self, data):
        print("<==================================")
        print("on plot trans")
        print (self.namespace[0:]," to redis", data)

        job = app.queue.enqueue(plotTrans, self.namespace, data)

    def on_trans_calc(self, data):
        print("<==================================")
        print("on calc trans")
        print (self.namespace[0:]," to redis", data)

        job = app.queue.enqueue(calcTrans, self.namespace, data)

    def on_connect(self):
        print("<==================================")
        print("3: connect")
        if True:
            _uuid = self.namespace[1:]
            _ip=dict(request.event['args'][0])['REMOTE_ADDR']
            if _uuid in ipList.keys():
                if ipList[_uuid]!=_ip:
                    ipList[_uuid]=_ip
                    nsList[_uuid]=self
                    print("Warning: ", _uuid, " not match ", _ip)
            else:
                ipList[_uuid]=_ip
                nsList[_uuid]=self
                #myredis.setRedisData("flask_client",ipList)
                print("Add tab: ", _uuid, _ip)
            print("All clients: ", ipList)
            print("All clients: ", nsList)
        else:
            print("Warning: first contact!")

    def on_disconnect(self):
        print("<==================================")
        print("5: disconnect")
        try:
            _uuid = self.namespace[1:]
            if _uuid in ipList.keys():
                ipList.pop(_uuid)
                nsList.pop(_uuid)
                #myredis.setRedisData("flask_client",ipList)
                print("Loss tab: ", _uuid)
        except:
            print("Warning: something wrong ", ipList)

        print("All clients: ", ipList)
        print("All clients: ", nsList)

@sans_bp.route('/')
def index():
    if 'icatSessionId' in session:
        _icatSession = auth_helper.icatHelper.getSessionById(session['icatSessionId'])
        if auth.PermissionChecker.isSessionValid(_icatSession):
            _icatSession.refresh()
        else:
            auth_helper.learSession()
    else:
        auth_helper.clearSession()

    _username = session.get('username', None)
    _p = []
    if _username is not None:
        _session = auth_helper.icatHelper.getSessionById(session['icatSessionId'])
        _facilities = _session.search('SELECT f FROM Facility f')
        _proposals = auth_helper.icatHelper.getOwnProposals(_session)
        for _proposal in _proposals:
            _temp = {}
            _id = _proposal['Investigation']['id']
            _datasets = auth_helper.icatHelper.getDatasetsForProposal(_session, _id)
            _facility = auth_helper.icatHelper.getFacilityForProposal(_session, _id)
            _instruments = auth_helper.icatHelper.getInstrumentsForProposal(_session, _id)
            _temp['id'] = _id
            _temp['investigation'] = _proposal['Investigation']
            _temp['datasets'] = _datasets
            _temp['facility'] = _facility
            _temp['instruments'] = _instruments
            _p.append(_temp)
    return render_template('index.html', proposals = _p)

@sans_bp.route('/favicon.ico')
def favicon():
    return send_from_directory(os.path.join(app.root_path, 'static'), 'img/csns-logo.png', mimetype='image/png')

@sans_bp.route('/sans/analysis', methods=['GET','POST'])
@login_required
def analysis():
    if request.method == 'POST':
        _facility_id = request.form['f_id']
        _instrument_id = request.form['i_id']
        _proposal_id = request.form['p_id']
        _uuid = request.form['uuid']
    else:
        _proposal_id = request.args.get('p_id')
        _uuid = request.args.get('uuid')

    print("<==================================")
    print("analysis")

    _icatSessionId = session.get("icatSessionId", None)
    if _icatSessionId is None:
        return redirect('/login')

    try:
        _icatSession = auth_helper.icatHelper.getSessionById(_icatSessionId)
        if not auth.PermissionChecker.isSessionValid(_icatSession):
            return redirect('/login')

        if auth.PermissionChecker.isAccessPermitted(_icatSession, int(_proposal_id)):
            _proposal = auth_helper.icatHelper.getProposalById(_icatSession, int(_proposal_id))
        else:
            print('Access not permitted')

        _ip=request.remote_addr
        if _uuid in ipList.keys():
            if ipList[_uuid]!=_ip:
                print(_uuid, " not match ", _ip)
            _success=False
        else:
            ipList[_uuid]=_ip
            nsList[_uuid]=myNamespace('/'+ _uuid)
            #myredis.setRedisData("flask_client",ipList)
            _success=True

        if _success:
            print("create new tab: ", _uuid)
        else:
            print("refresh old tab: ", _uuid)

        socketio.on_namespace(myNamespace('/'+ _uuid))
    except Exception as ex:
        print(ex)
        flash(str(ex))

    return render_template('analysis.html', proposal=_proposal, uuid = _uuid)
 
def clearon():
    #myredis.delete("flask_client")
    try:
        pass
        #_ipList=myredis.getRedisData("flask_client")
    except:
        _ipList={}

    print("info: restore the existing connections: ",_ipList)
    for (k,v) in _ipList.items():
        socketio.on_namespace(myNamespace("/"+k, True))
